##################################################################
# Subaru HDS : Making Bad Pixel Mask from BIAS
#  developed by Akito Tajitsu <tajitsu@subaru.naoj.org>
#              2011.09.30 ver.1.00
###################################################################
procedure mkbadmask(inimage,outimage)
#
file	inimage		{prompt= "Input BIAS image "}
file	outimage	{prompt= "Output MASK image \n"}

int   lower=-100 {prompt="Lower limit replacement window"}
int   upper=300 {prompt="Upper limit replacement window\n"}

bool  clean=yes {prompt="Clean up by wacosm11"}
int  base=1 {prompt="Baseline for wacosm11"}

#

begin
string 	inimg, outimg
string temp1, temp2, temp3
int lw, up

inimg=inimage
outimg=outimage

lw=lower
up=upper

temp1 = mktemp('tmp.mkbad.')
temp2 = mktemp('tmp.mkbad.')

imcopy(inimg, temp1)
imreplace(temp1, 0, imagina=0.,upper=up, lower=INDEF, radius=0.)
imreplace(temp1, 1, imagina=0.,upper=INDEF, lower=up, radius=0.)

imcopy(inimg, temp2)
imreplace(temp2, 0, imagina=0.,upper=INDEF, lower=lw, radius=0.)
imreplace(temp2, 1, imagina=0.,upper=lw, lower=INDEF, radius=0.)

if(clean){
  temp3 = mktemp('tmp.mkbad.')
  imarith(temp1, "+", temp2, temp3)

  wacosm11(temp3, outimg, base=base)
  imdelete(temp3)
}
else{
  imarith(temp1, "+", temp2, outimg)
}

imdelete(temp1)
imdelete(temp2)


printf(">>> Mask for fixpix \"%s\" has been created!\n",outimg)

bye
end
