#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include "distcalib.h"

/* 2006/11/11
	change to swith imaging and spectroscopy mode by option -i or -s
	default is imaging mode
*/

int main(int argc, char *argv[])
{
	FILE	*fp;
	float	*idata,*odata;
	struct distortion	distpar;
	struct header	headpar;
	char	buf[256],infile[256],outfile[256];
	double	col_cam=COL_CAM_IMAG;
	int	arg_offset=0;

	if(argc<4 || (argc>=5&&argv[1][0]!='-'))
	{
		fprintf(stderr,"for imaging data:\n");
		fprintf(stderr,"\t %s [distortion file] [input] [output]\n",argv[0]);
		fprintf(stderr,"\t %s -i [distortion file] [input] [output]\n",argv[0]);
		fprintf(stderr,"for spectroscopy :\n");
		fprintf(stderr,"\t %s -s [distortion file] [input] [output]\n",argv[0]);
		return 0;
	}
	else if(argc==5)
	{
		arg_offset=1;
		if(strcmp(argv[1],"-i")==0)
			col_cam=COL_CAM_IMAG;
		else if(strcmp(argv[1],"-s")==0)
			col_cam=COL_CAM_SPEC;
		else
		{
			fprintf(stderr,"unknown option : %s\n",argv[1]);
			return 0;
		}
	}

	if(read_distpars(argv[1+arg_offset],&distpar)!=DC_OK)
		return 0;

	if(strstr(argv[2+arg_offset],"fits\0")==NULL)
		sprintf(infile,"%s.fits",argv[2+arg_offset]);
	else
		strcpy(infile,argv[2+arg_offset]);
	if(strstr(argv[3+arg_offset],"fits\0")==NULL)
		sprintf(outfile,"%s.fits",argv[3+arg_offset]);
	else
		strcpy(outfile,argv[3+arg_offset]);

	if(read_headpars(infile,&headpar)!=DC_OK)
		return 0;

	idata=(float *)malloc(sizeof(float)*headpar.xlen*headpar.ylen);
	odata=(float *)malloc(sizeof(float)*headpar.xlen*headpar.ylen);
	if(fitsopen2(infile,idata,headpar.xlen*headpar.ylen)!=DC_OK)
		return 0;

	if((fp=fopen(outfile,"rt"))!=NULL)
	{
		fclose(fp);
		printf("%s exists. overwrite? ([y]/n):",outfile);
		fgets(buf,sizeof(buf),stdin);
		if(buf[0]=='n')
		{
			printf("terminate program.\n");
			return 0;
		}
		else
		{
			sprintf(buf,"rm -f %s",outfile);
			system(buf);
		}
	}

	system("date");

	if(distcalib(idata,odata,headpar,distpar,0.0,col_cam)!=DC_OK)
		return 0;
	if(fits_create2d(outfile,odata,headpar.xlen,headpar.ylen)!=DC_OK)
		return 0;
	if(copy_header(infile,outfile)!=DC_OK)
		return 0;

	system("date");

	return 0;
}
