#define	DC_OK	0
#define	DC_ERR	-1
#define	BUFSIZE	1024
//#define DEBUG
//#define DISTFILE "/home/hattori/FOCASRED/DATA/DistChipDat.MIT.090904.dat"

#define	COL_CAM_IMAG	1.0
#define	COL_CAM_SPEC	1.25

struct distortion {
	double	yshift;
	double	gapsize;
	double	diffrot;
	double	beta;
	double	dist_cenx;
	double	dist_ceny;
	double	mask_cenx;
	double	mask_ceny;
	double	mask_rot_cenx;
	double	mask_rot_ceny;
	double	rotator_cenx;
	double	rotator_ceny;
	double	coef[4];
	double	coefinv[4];
	double	theta_offset;
	int	overscan;
};

#define	NDISTPARS	22

struct header {
	long	xlen;
	long	ylen;
	int	xbin;
	int	ybin;
	int	chip;
};

int distcalib(float *, float *, struct header, struct distortion, double, double);
void distcor(double *, double *, struct distortion);
void rotate(double *, double *, double, double, double);
int read_distpars(char *, struct distortion *);
int read_headpars(char *, struct header *);
int fitsopen2(char *, float *, long);
void printerror(int);
int getxylen(char *, long *, long *);
int get_fits_head(char *, char *, char *);
int datawrite2d(char *, float *, long, long, long, long);
int fits_create2d(char *, float *, long, long);
int copy_header(char *, char *);
int check_keyname(char *);
int copy_wcs(char *, char *);
int copy_focashead(char *, char *);
