# FOCAS distortion correction and combine 2 frames
procedure bigimage( chip1, chip2, output)
#
file	chip1	{prompt="input chip1 images"}
file	chip2	{prompt="input chip2 images"}
file	output	{prompt="output images"}

string	obsmode="imaging"	{prompt="spectroscopy/imaging",enum="spectroscopy|imaging"}
string	distdata="DistChipDat.MIT.090904.dat"	{prompt="distortion data file in FOCASREDHOME$DATA/"}
struct *list1
struct *list2
struct *list3

bool verbose=yes

begin
	string	inlist1,inlist2,outlist
	string	distfile,focasred_dir
	string	inimg1,inimg2,outimg
	string	tmp1,tmp2,tmp3
	string	obs_mode
	int	n_image_in1,n_image_in2,n_image_out
	bool	verb

# initialize variables
	inlist1=chip1
	inlist2=chip2
	outlist=output
	focasred_dir = osfn("FOCASREDHOME$")
	distfile = focasred_dir//"/DATA/"//distdata
	if(obsmode=="spectroscopy")
		obs_mode="-s"
	else if(obsmode=="imaging")
		obs_mode="-i"
	else
	{
		print("invalid observation mode :",obsmode)
		goto bye
	}
	verb=verbose

	sections(inlist1,option='nolist')
	n_image_in1 = sections.nimages
	sections(inlist2,option='nolist')
	n_image_in2 = sections.nimages
	sections(outlist,option='nolist')
	n_image_out = sections.nimages

	if(n_image_in1 != n_image_out || n_image_in1 != n_image_in2)
	{
		print("ERROR: Number of input/output images not the same")
		clbye()
	}

# task definition
	task	$cbigimage = ("$"//focasred_dir//"/bin/bigimage")

# prepare for main loop
	tmp1=mktemp("dc_tmp.")
	tmp2=mktemp("dc_tmp.")
	tmp3=mktemp("dc_tmp.")
	sections(inlist1,option='fullname', > tmp1)
	sections(inlist2,option='fullname', > tmp2)
	sections(outlist,option='fullname', > tmp3)
	list1=tmp1
	list2=tmp2
	list3=tmp3

#
	while( fscan(list1,inimg1)==1 && fscan(list2,inimg2)==1 && fscan(list3,outimg)==1)
	{
		print("bigimage"," ",obs_mode," ",distfile," ",inimg1," ",inimg2," ",outimg)
		if(verb==yes)
			cbigimage(obs_mode,distfile,inimg1,inimg2,outimg)
		else
			cbigimage(obs_mode,distfile,inimg1,inimg2,outimg,>&"dev$null")
	}

	delete(tmp1,ver-)
	delete(tmp2,ver-)
	delete(tmp3,ver-)

	bye
end

