#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include "focas_util.h"
#include "fio.h"

#define	NSLITMAX	100

int main(int argc, char *argv[])
{
	struct sbr_parameters	slits[NSLITMAX];
	struct mdp_parameters	slits_mdp[NSLITMAX];
	int	i,nslit=NSLITMAX,nslit_mdp=NSLITMAX;
	int	flag_mdp=0;
	struct header	headpars;	// chip#, pixel, binning
	struct spmode	specpars;	// grism, filter, etc.
//	struct grism_parameters	grismpars;
	struct distortion	distpars;
	double	x1pix,y1pix;
	double	x2pix,y2pix;
	double	dx,ycen,fwidth;
	double	mask_rot;
	float	*input;
	long	x1,x2,y1,y2,ty;
	char	fname[BUFSIZE];

	// ds9 reg file
	FILE	*fp;
	char	regname[BUFSIZE],imname[BUFSIZE],imname2[BUFSIZE],*cp;

	if(argc!=6&&argc!=7&&argc!=8)
	{
		fprintf(stderr,"usage : %s [FOCASREDHOME] [distortion data] [fits] [sbr] [rot]\n",argv[0]);
		fprintf(stderr,"usage : %s [FOCASREDHOME] [distortion data] [fits] [sbr] [rot] [dx]\n",argv[0]);
		fprintf(stderr,"usage : %s [FOCASREDHOME] [distortion data] [fits] [sbr] [rot] [dx] [mdp]\n",argv[0]);
		return 0;
	}

	if(argc==7||argc==8)
	{
		if(sscanf(argv[6],"%lf",&dx)!=1)
		{
			fprintf(stderr,"unknown format for [dx] : %s\n",argv[6]);
			return 0;
		}
	}
	else
		dx=0.0;

// read parameters and image
	sprintf(fname,"%s/DATA/%s",argv[1],argv[2]);
	if(read_distpars(fname,&distpars)!=DC_OK)
		return 0;

	if(read_headpars(argv[3],&headpars)!=FCS_OK)
		return 0;
	input=(float *)malloc(sizeof(float)*headpars.xlen*headpars.ylen);
	if(fitsopen2(argv[3],input,headpars.xlen*headpars.ylen)!=DC_OK)
		return 0;

	sprintf(fname,"%s/DATA/",argv[1]);
	if(get_specmode(fname,headpars.grism,headpars.filter,&specpars)!=FCS_OK)
		return 0;

	if(sscanf(argv[5],"%lf",&mask_rot)!=1)
	{
		fprintf(stderr,"unknown format for [rot] : %s\n",argv[5]);
		return 0;
	}

// read sbr (mask design) file
	if(readsbr(argv[4],slits,&nslit)!=FCS_OK)
		return 0;

	specpars.dispersion*=headpars.ybin;

// read mdp file (option)
	if(argc==8)
	{
		if(readmdp(argv[7],slits_mdp,&nslit_mdp)!=FCS_OK)
			fprintf(stderr,"error in reading MDP file %s.\n",argv[7]);
		else
		{
			if(nslit_mdp!=nslit)
				fprintf(stderr,"warning! number of slits in sbr and mdp file is different!\n");

			flag_mdp=1;
		}
	}


// prepare for DS9 region file
	sprintf(regname,"%s.reg",argv[3]);
	fp=fopen(regname,"wt");
	fprintf(fp,"image\n");

// main loop
	for(i=0;i<nslit;i++)
	{
		// skip if an alignment hole
		if(slits[i].type=='C')
			continue;

		// convert to slit position on CCD
		x1pix=slits[i].x1;
		x2pix=slits[i].x2;
		y1pix=slits[i].y1;
		y2pix=slits[i].y2;
		sbr2mdp_rot(&x1pix,&y1pix,distpars,mask_rot);
		sbr2mdp_rot(&x2pix,&y2pix,distpars,mask_rot);

		// calc region to extract
		x1pix/=headpars.xbin;
		y1pix/=headpars.ybin;
		x2pix/=headpars.xbin;
		y2pix/=headpars.ybin;
		// apply manual shift dx
		x1pix+=dx;
		x2pix+=dx;
		// apply the shift by grism
		x1pix-=specpars.dx/headpars.xbin;
		x2pix-=specpars.dx/headpars.xbin;

		x1=(int)floor(x1pix)-1;
		x2=(int)ceil(x2pix)-1;
		ycen=(y1pix+y2pix)/2.0;
		y1=(int)(ycen+(specpars.w1-specpars.wc)/specpars.dispersion);
		y2=(int)(ycen+(specpars.w2-specpars.wc)/specpars.dispersion);
		if(y1>y2)
		{
			ty=y1;
			y1=y2;
			y2=ty;
		}
		y1=y1-1;
		y2=y2+1;

		if(x1<1) x1=1;
		if(x2>headpars.xlen) x2=headpars.xlen;
		if(y1<1) y1=1;
		if(y2>headpars.ylen) y2=headpars.ylen;

		// output
		strcpy(imname,argv[3]);
		if((cp=strstr(imname,".fits"))!=NULL)
			*cp='\0';
		sprintf(imname2,"%s.%03d.fits",imname,i+1);
		printf("imcopy %s[%ld:%ld,%ld:%ld] %s\n",argv[3],x1,x2,y1,y2,imname2);
		printf("hedit %s CRPIX1 1.0 ver- update+ add+ show-\n",imname2);
		printf("hedit %s CRVAL1 1.0 ver- update+ add+ show-\n",imname2);
		printf("hedit %s CDELT1 1.0 ver- update+ add+ show-\n",imname2);
		printf("hedit %s CTYPE1 LINEAR ver- update+ add+ show-\n",imname2);
		printf("hedit %s CRPIX2 %lf ver- update+ add+ show-\n",imname2,ycen-y1+1.0);
		printf("hedit %s CRVAL2 %lf ver- update+ add+ show-\n",imname2,specpars.wc);
		printf("hedit %s CDELT2 %lf ver- update+ add+ show-\n",imname2,specpars.dispersion);
		printf("hedit %s CTYPE2 LINEAR ver- update+ add+ show-\n",imname2);
		// slit width in pixel
		fwidth=slits[i].width*distpars.beta/0.015/headpars.ybin;
		printf("hedit %s FWIDTH %lf ver- update+ add+ show-\n",imname2,fwidth);
		// extracted position
		printf("hedit %s EXT_X1 %ld ver- update+ add+ show-\n",imname2,x1);
		printf("hedit %s EXT_X2 %ld ver- update+ add+ show-\n",imname2,x2);
		printf("hedit %s EXT_Y1 %ld ver- update+ add+ show-\n",imname2,y1);
		printf("hedit %s EXT_Y2 %ld ver- update+ add+ show-\n",imname2,y2);
		// remove headers added by imcopy
		printf("hedit %s LTV1 0 ver- update+ delete+ show-\n",imname2);
		printf("hedit %s LTV2 0 ver- update+ delete+ show-\n",imname2);
		// mdp commenet
		if(flag_mdp==1 && i<nslit_mdp)
			printf("hedit %s MDPCOMNT \"%s\" ver- update+ add+ show-\n",imname2,slits_mdp[i].comment);

		// reg
		fprintf(fp,"box(%f,%lf,%ld,10,0) # text={%d}\n",(x2+x1)/2.0,ycen,x2-x1,i+1);
	}

	fclose(fp);

	return 0;
}

