#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include "focas_util.h"
#include "fio.h"

#define	NSLITMAX	100
#define	BUFFER	20	// buffer for the size of output image
#define	GAP	3	// clearance gap between slits

int main(int argc, char *argv[])
{
	struct sbr_parameters	slits[NSLITMAX];
	int	i,nslit=NSLITMAX;
	struct header	headpars;	// chip#, pixel, binning
	struct spmode	specpars;	// grism, filter, etc.
//	struct grism_parameters	grismpars;
	struct distortion	distpars;
	double	x1pix,y1pix;
	double	x2pix,y2pix;
	double	cent_wav;
	double	ypos_wc;	// y pixel position of specpars.wc (CRPIX2)
	double	dx,ycen,mask_rot;
	float	*input,*output,value,*output2;
	long	x1,x2,y1,y2,ty;
	long	output_xlen,output_ylen,output_xin=0;
	long	x,y,pos;
	char	fname[BUFSIZE];

	// ds9 reg file
	FILE	*fp;
	char	regname[BUFSIZE];

	if(argc!=7&&argc!=8)
	{
		fprintf(stderr,"usage : %s [FOCASREDHOME] [distortion data] [fits] [sbr] [output] [rot]\n",argv[0]);
		fprintf(stderr,"usage : %s [FOCASREDHOME] [distortion data] [fits] [sbr] [output] [rot] [dx]\n",argv[0]);
		return 0;
	}

	if(argc==8)
	{
		if(sscanf(argv[7],"%lf",&dx)!=1)
		{
			fprintf(stderr,"unknown format for [dx] : %s\n",argv[7]);
			return 0;
		}
	}
	else
		dx=0.0;

// read parameters and image
	if(read_headpars(argv[3],&headpars)!=FCS_OK)
		return 0;
	input=(float *)malloc(sizeof(float)*headpars.xlen*headpars.ylen);
	if(fitsopen2(argv[3],input,headpars.xlen*headpars.ylen)!=DC_OK)
		return 0;

	sprintf(fname,"%s/DATA/%s",argv[1],argv[2]);
	if(read_distpars(fname,&distpars)!=DC_OK)
		return 0;

	sprintf(fname,"%s/DATA/",argv[1]);
	if(get_specmode(fname,headpars.grism,headpars.filter,&specpars)!=FCS_OK)
		return 0;

	if(readsbr(argv[4],slits,&nslit)!=FCS_OK)
		return 0;

	if(sscanf(argv[6],"%lf",&mask_rot)!=1)
	{
		fprintf(stderr,"unknown format for [mask_rot] : %s\n",argv[6]);
		return 0;
	}

	specpars.dispersion*=headpars.ybin;
	output_xlen=headpars.xlen+BUFFER;
	output_ylen=(int)fabs((specpars.w2-specpars.w1)/specpars.dispersion)+BUFFER;
	output=(float *)malloc(sizeof(float)*output_xlen*output_ylen);

	sprintf(regname,"%s.reg",argv[3]);
	fp=fopen(regname,"wt");
	fprintf(fp,"image\n");

	for(i=0;i<nslit;i++)
	{
		// skip if an alignment hole
		if(slits[i].type=='C')
			continue;

		// convert to slit position on CCD
		x1pix=slits[i].x1;
		x2pix=slits[i].x2;
		y1pix=slits[i].y1;
		y2pix=slits[i].y2;
		sbr2mdp_rot(&x1pix,&y1pix,distpars,mask_rot);
		sbr2mdp_rot(&x2pix,&y2pix,distpars,mask_rot);

/*		if(headpars.chip==1)
		{
			x1pix=x1pix-(2047-distpars.overscan)-distpars.gapsize+distpars.overscan;
			x2pix=x2pix-(2047-distpars.overscan)-distpars.gapsize+distpars.overscan;
		}
		else
		{
			y1pix=y1pix-distpars.yshift;
			y2pix=y2pix-distpars.yshift;
		}
*/

		// calc region to extract
		// apply dx to x position
		x1pix/=headpars.xbin;
		y1pix/=headpars.ybin;
		x2pix/=headpars.xbin;
		y2pix/=headpars.ybin;
		// apply the manual shift dx
		x1pix+=dx;
		x2pix+=dx;
		// apply the shift by grism
		x1pix-=specpars.dx/headpars.xbin;
		x2pix-=specpars.dx/headpars.xbin;

		cent_wav=specpars.wc;
//		straight_wav((slits[i].x1+slits[i].x2)/2.0,(slits[i].y1+slits[i].y2)/2.0,grismpars,&cent_wav);
		x1=(int)floor(x1pix)-1;
		x2=(int)ceil(x2pix)-1;
		  // ypos at specpars.wc (<- nominal central wavelength)
		//ycen=(y1pix+y2pix)/2.0-(cent_wav-specpars.wc)/specpars.dispersion;
		ycen=(y1pix+y2pix)/2.0;
		y1=(int)(ycen+(specpars.w1-specpars.wc)/specpars.dispersion);
		y2=(int)(ycen+(specpars.w2-specpars.wc)/specpars.dispersion);
		if(y1>y2)
		{
			ty=y1;
			y1=y2;
			y2=ty;
		}
		y1=y1-1;
		y2=y2+1;

		// output
		for(y=y1;y<=y2;y++)
		{
		   for(x=x1;x<=x2;x++)
		   {
			pos=output_xin+(x-x1)+(y-y1)*output_xlen;
			if(x<1||x>headpars.xlen||y<1||y>headpars.ylen)
				value=0.0;
			else
				value=input[(x-1)+(y-1)*headpars.xlen];

			output[pos]=value;
		   }
		}
		output_xin+=(x2-x1+GAP);

		// reg
		fprintf(fp,"box(%f,%lf,%ld,10,0) # text={%d}\n",(x2+x1)/2.0,ycen,x2-x1,i+1);
	}

	fclose(fp);

	output2=(float *)malloc(sizeof(float)*output_xin*output_ylen);
	for(x=0;x<output_xin;x++)
	{
		for(y=0;y<output_ylen;y++)
			output2[x+y*output_xin]=output[x+y*output_xlen];
	}

	if(datawrite2d(argv[5],output2,1,output_xin,1,output_ylen)!=DC_OK)
		return 0;

	if(copy_header(argv[3],argv[5])!=DC_OK)
		return 0;

	if(specpars.dispersion>0.0)
		ypos_wc=(specpars.wc-specpars.w1)/specpars.dispersion+1.0;
	else
		ypos_wc=(specpars.wc-specpars.w2)/specpars.dispersion+1.0;

	if(write_fits_head_float(argv[5],"CRPIX1",1.0,"Reference pixel in X (pixel)")) return 0;
	if(write_fits_head_float(argv[5],"CRPIX2",(float)ypos_wc,"Reference pixel in Y (pixel)")) return 0;
	if(write_fits_head_float(argv[5],"CRVAL1",1.0,"Physical value of the reference pixel X")) return 0;
	if(write_fits_head_float(argv[5],"CRVAL2",(float)specpars.wc,"Physical value of the reference pixel Y")) return 0;
	if(write_fits_head_float(argv[5],"CDELT1",1.0,"X Scale projected on detector (#/pix)")) return 0;
	if(write_fits_head_float(argv[5],"CDELT2",(float)specpars.dispersion,"Y Scale projected on detector (#/pix)")) return 0;
	if(write_fits_head_string(argv[5],"CTYPE1","LINEAR  ","")) return 0;
	if(write_fits_head_string(argv[5],"CTYPE2","LINEAR  ","")) return 0;

	return 0;
}

