#define	DC_OK	0
#define	DC_ERR	-1
#define	FCS_OK	0
#define	FCS_ERR	-1
#define	BUFSIZE	1024

#define PI      (atan(1.0)*4.0)
#define RAD     (180.0/PI)

#define	FCOL	1097.7	// collimator focal length in mm
#define	FCAM	329.4	// camera focal length in mm

#define BARCODE	"barcode.dat"
#define SPECMODE	"specmode.dat"

struct distortion {
	double	yshift;
	double	gapsize;
	double	diffrot;
	double	beta;
	double	dist_cenx;
	double	dist_ceny;
	double	mask_cenx;
	double	mask_ceny;
	double	mask_rot_cenx;
	double	mask_rot_ceny;
	double	rotator_cenx;
	double	rotator_ceny;
	double	coef[4];
	double	coefinv[4];
	double	theta_offset;
	int	overscan;
};
#define	NDISTPARS	22

#define CURRENT_DISTFILE "/home/hattori/FOCASRED/DATA/DistChipDat.HPK.101112.dat"

struct sbr_parameters {
	double	x1;
	double	x2;
	double	y1;
	double	y2;
	char	type;
	double	width;
} ;

struct mdp_parameters {
	double	x;
	double	y;
	double	length;
	double	width;
	double	angle;
	double	priority;
	char	type;
	char	comment[BUFSIZE];
};

struct header {
	long	xlen;
	long	ylen;
	int	xbin;
	int	ybin;
	int	chip;
	char	filter[16];	// barcode
	char	grism[16];	// barcode
};

struct spmode {
	char	grism[16];
	char	filter[16];
	double	wc;		// straight-through wavelength (A)
	double	w1;		// min. wavelength (A)
	double	w2;		// max. wavelength (A)
	double	dispersion;	// A/pixel
	double	dx;		// shift along x (pix)
};

int read_distpars(char *, struct distortion *);
int read_headpars(char *, struct header *);
int readsbr(char *, struct sbr_parameters *, int *);
int readmdp(char *, struct mdp_parameters *, int *);
int get_specmode(char *, char *, char *, struct spmode *);
int sbr2mdp(double *, double *, struct distortion);
int sbr2mdp_rot(double *, double *, struct distortion, double);
