#include <fitsio.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "focas_util.h"
#include "fio.h"

int fitsopen2(fname,data,ndata)
char	*fname;
long	ndata;
float	*data;
{
	fitsfile	*fptr;
	float	nulval=0.0;
	int	anynul,status=0;
	int	start=1;

	if(fits_open_file(&fptr,fname,READONLY,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_read_img(fptr,TFLOAT,start,ndata,&nulval,data,&anynul,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}


void printerror(int status)
{
	if(status)
		fits_report_error(stderr,status);

	return;
}

int getxylen(fname,rxlen,rylen)
char	*fname;
long	*rxlen,*rylen;
{
	fitsfile	*fptr;
	int	status;
	char	comment[80];
	long	xlen,ylen;
	long	naxis;

	status=0;

	if(fits_open_file(&fptr,fname,READONLY,&status))
	{
//		printf("cannot open %s!\n",fname);
		printerror(status);
		return DC_ERR;
	}

	if(fits_read_key_lng(fptr,"NAXIS",&naxis,comment,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_read_key_lng(fptr,"NAXIS1",&xlen,comment,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(naxis==1)
	{
		ylen=1;
	}
	else
	{
		if(fits_read_key_lng(fptr,"NAXIS2",&ylen,comment,&status))
		{
			printerror(status);
			return DC_ERR;
		}
	}

	if(fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	*rxlen=xlen;
	*rylen=ylen;

	return DC_OK;
}

int get_fits_head(fname,keyword,output)
char	*fname,*keyword,*output;
{
	fitsfile	*fptr;
	int	status;
	char	comment[80];

	status=0;

	if(fits_open_file(&fptr,fname,READONLY,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_read_key(fptr,TSTRING,keyword,output,comment,&status))
	{
		printerror(status);
		fprintf(stderr,"(keyword : %s)\n",keyword);
		return DC_ERR;
	}

	if(fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}


int datawrite2d(fname,data,x1,x2,y1,y2)
char	*fname;
float	*data;
long	x1,x2,y1,y2;
{
	fitsfile	*fptr;
	int	status;
	long	naxis,axlen[2];
	long	xlen,ylen;
	FILE	*fp;
	char	yn,buf[256];
	char	comment[80];

	status=0;

	if((fp=fopen(fname,"rt"))==NULL)
	{
//		printf("error in opening. creating a new file.\n");

		if(fits_create_file(&fptr,fname,&status))
		{
			printerror(status);
			return DC_ERR;
		}
		axlen[0]=xlen=x2-x1+1;
		axlen[1]=ylen=y2-y1+1;
		if(fits_create_img(fptr,FLOAT_IMG,2,axlen,&status))
		{
			printerror(status);
			return DC_ERR;
		}
		fits_close_file(fptr,&status);
		if( fits_open_file(&fptr,fname,READWRITE,&status))
		{
			printerror(status);
			return DC_ERR;
		}
	}
	else
	{
		fclose(fp);
		printf("file %s exists. over write? [y/(n)]:\n",fname);
		fgets(buf,sizeof(buf),stdin);
		if(buf[0]=='\n')
			yn='n';
		else
			sscanf(buf,"%c",&yn);

		if(yn!='y')
			return DC_ERR;

		if( fits_open_file(&fptr,fname,READWRITE,&status))
		{
			printerror(status);
			return DC_ERR;
		}
		if( fits_read_key_lng(fptr,"NAXIS",&naxis,comment,&status))
		{
			printerror(status);
			return DC_ERR;
		}

		if( fits_read_key_lng(fptr,"NAXIS1",&xlen,comment,&status))
		{
			printerror(status);
			return DC_ERR;
		}

		if( fits_read_key_lng(fptr,"NAXIS2",&ylen,comment,&status))
		{
			printerror(status);
			return DC_ERR;
		}

		if(naxis!=2)
		{
			printf("%s is not 2-dimentional image!\n",fname);
			return DC_ERR;
		}

		if(xlen!=x2-x1+1 || ylen!=y2-y1+1)
		{
			printf("%s has different size!\n",fname);
			return DC_ERR;
		}
	}

	if( fits_write_img(fptr,TFLOAT,1,xlen*ylen,data,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if( fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

int fits_create2d(char *fname, float *data, long xlen, long ylen)
{
	
	fitsfile	*fptr;
	int	status=0;
	long	axlen[2];

	if(fits_create_file(&fptr,fname,&status))
	{
		printerror(status);
		return DC_ERR;
	}
	axlen[0]=xlen;
	axlen[1]=ylen;
	if(fits_create_img(fptr,-32,2,axlen,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_write_img(fptr,TFLOAT,1,xlen*ylen,data,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if( fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

int copy_header(char *infile, char *outfile)
{
	fitsfile	*ifptr,*ofptr;
	int	status=0;
	char	keyname[16],value[80],comment[80];
	char	buf[256];
	int	i,nhead;

	if(fits_open_file(&ifptr,infile,READONLY,&status))
	{
		fprintf(stderr,"file open error : %s\n",infile);
		printerror(status);
		return DC_ERR;
	}

	if(fits_open_file(&ofptr,outfile,READWRITE,&status))
	{
		fprintf(stderr,"file open error : %s\n",outfile);
		printerror(status);
		status=0;
		fits_close_file(ifptr,&status);
		return DC_ERR;
	}
	// get number of header keywords
	if(fits_get_hdrspace(ifptr,&nhead,NULL,&status))
	{
		fprintf(stderr,"fits_get_hdrspace()\n");
		printerror(status);
		status=0;
		fits_close_file(ifptr,&status);
		fits_close_file(ofptr,&status);
		return DC_ERR;
	}
	for(i=1;i<=nhead;i++)
	{
		if(fits_read_keyn(ifptr,i,keyname,value,comment,&status))
		{
			fprintf(stderr,"fits_read_keyn()\n");
			printerror(status);
			status=0;
			fits_close_file(ifptr,&status);
			fits_close_file(ofptr,&status);
			return DC_ERR;
		}
		if(check_keyname(keyname)==DC_OK)
		{
			fits_read_record(ifptr,i,buf,&status);
			if(fits_write_record(ofptr,buf,&status))
				printerror(status);
		}
	}

	if( fits_close_file(ifptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}
	if( fits_close_file(ofptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

int check_keyname(char *keyname)
{
	char ignore_headers[64][9] = { "SIMPLE", "BITPIX", "NAXIS", "NAXIS1",
			"NAXIS2", "EXTEND", "BSCALE", "BZERO", "BUNIT", "BLANK"};
	int i,nhead=10;

	for(i=0;i<nhead;i++)
	{
		if(strcmp(keyname,ignore_headers[i])==0)
			return DC_ERR;
	}

	return DC_OK;
}

int copy_wcs(char *infile, char *outfile)
{
	fitsfile	*ifptr,*ofptr;
	int	status=0;
	char	comment[80];
	char	str_headers[64][9] = { "CTYPE1", "CTYPE2", "CUNIT1", "CUNIT2",
			"WCS-ORIG", "RADECSYS", "RA", "DEC", "OBJECT"};
	char	flt_headers[64][9] = { "EQUINOX", "CRVAL1", "CRPIX1", "CDELT1",
			"CRVAL2", "CRPIX2", "CDELT2", "PC001001", "PC001002",
			"PC002001", "PC002002", "CD1_1", "CD1_2", "CD2_1",
			"CD2_2"};
	int	nstr=9, nflt=15, i;
	char	strvalue[64];
	float	fltvalue;

	if(fits_open_file(&ifptr,infile,READONLY,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_open_file(&ofptr,outfile,READWRITE,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	for(i=0;i<nstr;i++)
	{
		if(!fits_read_key(ifptr,TSTRING,str_headers[i],strvalue,
				comment,&status))
		{
			if(fits_write_key(ofptr,TSTRING,str_headers[i],strvalue,
					comment,&status))
				printerror(status);
		}
	}

	for(i=0;i<nflt;i++)
	{
		if(!fits_read_key(ifptr,TFLOAT,flt_headers[i],&fltvalue,
				comment,&status))
		{
			if(fits_write_key(ofptr,TFLOAT,flt_headers[i],&fltvalue,
					comment,&status))
				printerror(status);
		}
	}

	if( fits_close_file(ifptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}
	if( fits_close_file(ofptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

int copy_focashead(char *infile, char *outfile)
{
	fitsfile	*ifptr,*ofptr;
	char	headlist[1024];
	FILE	*fp;
	int	status=0,type;
	char	comment[80],buf[256];
	void	*value=(void *)malloc(sizeof(char)*80);
	char	key[16];

	if(fits_open_file(&ifptr,infile,READONLY,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_open_file(&ofptr,outfile,READWRITE,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	sprintf(headlist,"%s/DATA/header.txt",getenv("FOCASREDHOME"));
	if((fp=fopen(headlist,"rt"))==NULL)
	{
		perror("fopen");
		return DC_ERR;
	}

	while(fgets(buf,sizeof(buf),fp)!=NULL)
	{
		if(buf[0]!='#')
		{
			sscanf(buf,"%s %d",key,&type);
			if(!fits_read_key(ifptr,type,key,value,comment,&status))
			{
				if(fits_write_key(ofptr,type,key,value,comment,
						&status))
					printerror(status);
			}
		}
	}
	fclose(fp);

	if( fits_close_file(ifptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}
	if( fits_close_file(ofptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

int write_fits_head_float(char *file, char *keyname, float fltvalue, char *comment)
{
	fitsfile	*fptr;
	int	status=0;
	float	value;

	value=fltvalue;

	if(fits_open_file(&fptr,file,READWRITE,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_write_key(fptr,TFLOAT,keyname,&value,comment,&status))
		printerror(status);

	if( fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

int write_fits_head_string(char *file, char *keyname, char *strvalue, char *comment)
{
	fitsfile	*fptr;
	int	status=0;

	if(fits_open_file(&fptr,file,READWRITE,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	if(fits_write_key(fptr,TSTRING,keyname,strvalue,comment,&status))
		printerror(status);

	if( fits_close_file(fptr,&status))
	{
		printerror(status);
		return DC_ERR;
	}

	return DC_OK;
}

