#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "distcalib.h"

int main(int argc, char *argv[])
{
	FILE	*fp;
	float	*idata1,*idata2,*odata1,*odata2;
	float	*output;
	struct distortion	distpar;
	struct header	headpar,headpar2;
	char	buf[BUFSIZE];
	char	infile1[BUFSIZE],infile2[BUFSIZE],outfile[BUFSIZE];
	long	lx,ly,xlen,ylen;
	long	nx,ny,xshift;
//	long	yshift;
	double	delta_x;
	int	arg_offset=0,ret;
	double	col_cam=1.0;

	if(argc<5 || (argc>=6&&argv[1][0]!='-'))
	{
		fprintf(stderr,"for imaging data:\n");
		fprintf(stderr,"\t %s [distortion file] [chip1] [chip2] [output]\n",argv[0]);
		fprintf(stderr,"\t %s -i [distortion file] [chip1] [chip2] [output]\n",argv[0]);
		fprintf(stderr,"for spectroscopy :\n");
		fprintf(stderr,"\t %s -s [distortion file] [chip1] [chip2] [output]\n",argv[0]);

		return 0;
	}
	else if(argc==6)
	{
		arg_offset=1;
		if(strcmp(argv[1],"-i")==0)
			col_cam=COL_CAM_IMAG;
		else if(strcmp(argv[1],"-s")==0)
			col_cam=COL_CAM_SPEC;
		else
		{
			fprintf(stderr,"unknown option : %s\n",argv[1]);
			return 0;
		}
	}

	if(read_distpars(argv[1+arg_offset],&distpar)!=DC_OK)
		return 0;

	// file extension check
	if(strstr(argv[2+arg_offset],"fits\0")==NULL)
		sprintf(infile1,"%s.fits",argv[2+arg_offset]);
	else
		strcpy(infile1,argv[2+arg_offset]);

	if(strstr(argv[3+arg_offset],"fits\0")==NULL)
		sprintf(infile2,"%s.fits",argv[3+arg_offset]);
	else
		strcpy(infile2,argv[3+arg_offset]);

	if(strstr(argv[4+arg_offset],"fits\0")==NULL)
		sprintf(outfile,"%s.fits",argv[4+arg_offset]);
	else
		strcpy(outfile,argv[4+arg_offset]);

	if(read_headpars(infile1,&headpar)!=DC_OK)
		return 0;
	if(read_headpars(infile2,&headpar2)!=DC_OK)
		return 0;

	if(headpar.xlen!=headpar2.xlen||headpar.ylen!=headpar2.ylen)
	{
		fprintf(stderr,"%s and %s have different image size!\n",
				infile1,infile2);
		return 0;
	}
	idata1=(float *)malloc(sizeof(float)*headpar.xlen*headpar.ylen);
	idata2=(float *)malloc(sizeof(float)*headpar.xlen*headpar.ylen);
	odata1=(float *)malloc(sizeof(float)*headpar.xlen*headpar.ylen);
	odata2=(float *)malloc(sizeof(float)*headpar.xlen*headpar.ylen);
	if(fitsopen2(infile1,idata1,headpar.xlen*headpar.ylen)!=DC_OK)
		return 0;
	if(fitsopen2(infile2,idata2,headpar.xlen*headpar.ylen)!=DC_OK)
		return 0;

	if((fp=fopen(outfile,"rt"))!=NULL)
	{
		fclose(fp);
		fprintf(stderr,"%s exists. overwrite? ([y]/n):",outfile);
		if(fgets(buf,sizeof(buf),stdin)==NULL) return 0;
		if(buf[0]=='n')
		{
			fprintf(stderr,"terminate program.\n");
			return 0;
		}
		else
		{
			sprintf(buf,"rm -f %s",outfile);
			ret=system(buf);
		}
	}

	// size of the resulting image
	xlen=(long)(headpar.xlen-distpar.overscan/headpar.xbin+0.5)*2+1+(long)ceil(distpar.gapsize/headpar.xbin);
	ylen=headpar.ylen;
	// calc shift
	delta_x=(headpar.xlen-distpar.overscan/headpar.xbin)+distpar.gapsize/headpar.xbin-distpar.overscan/headpar.xbin;
	if(delta_x-floor(delta_x)<0.5)
		xshift=(long)floor(delta_x);
	else
		xshift=(long)ceil(delta_x);

	ret=system("date");

	// chip1, without shift or rotation
	if(distcalib(idata1,odata1,headpar,distpar,0.0,0.0,col_cam)!=DC_OK)
		return 0;
	// chip2, with shift and rotation
	if(distcalib(idata2,odata2,headpar2,distpar,xshift-delta_x,distpar.yshift/headpar.ybin,col_cam)!=DC_OK)
		return 0;

	free(idata1);
	free(idata2);

	printf("combining images...");
	fflush(stdout);

	output=(float *)malloc(sizeof(float)*xlen*ylen);
	for(ly=1;ly<=ylen;ly++)
	{
		for(lx=1;lx<=xlen;lx++)
		{
			// if chip2
			if(lx<=headpar.xlen-distpar.overscan/headpar.xbin)
			{
				nx=lx;
				ny=ly;
				if(nx>=1&&nx<=headpar.xlen&&ny>=1&&ny<=headpar.ylen)
					output[lx-1+xlen*(ly-1)]=odata2[nx-1+headpar.xlen*(ny-1)];
			}
			// if chip1
			else if(lx>=headpar.xlen-(distpar.overscan-distpar.gapsize)/headpar.xbin)
			{
//				nx=(long)(lx-(headpar.xlen-distpar.overscan/headpar.xbin+1)-distpar.gapsize/headpar.xbin+distpar.overscan/headpar.xbin-1+0.5);
				nx=lx-xshift;
				ny=ly;
				if(nx>=1&&nx<=headpar.xlen&&ny>=1&&ny<=headpar.ylen)
					output[lx-1+xlen*(ly-1)]=odata1[nx-1+headpar.xlen*(ny-1)];
			}
			else
				output[lx-1+xlen*(ly-1)]=0.0;
		}
	}

	if(fits_create2d(outfile,output,xlen,ylen)!=DC_OK)
		return 0;
	// copy header of chip2
	if(copy_header(infile2,outfile)!=DC_OK)
	{
		if(copy_focashead(infile2,outfile)!=DC_OK)
			fprintf(stderr,"WARNING!!! FITS header will not be copied.\n");
	}

	printf("done.\n");

	ret=system("date");

	return 0;
}
