#include <stdio.h>
#include <string.h>
#include <math.h>

#define	BUFSIZE	512
#define	MAXNUM	64
#define DEBUG
#define	RADIAN	57.29577951

int main(int argc, char *argv[])
{
	FILE	*fp;
	double	tx,ty;
	double	objx,objy;
	double	slitx,slity;
	int	file_num;
	char	buf[BUFSIZE];
	double	dalpha,ddec;

	if(argc!=2)
	{
		printf("usage : %s [imexam output]\n",argv[0]);
		return 0;
	}

	if((fp=fopen(argv[1],"rt"))==NULL)
	{
		printf("cannot open %s!\n",argv[1]);
		return 0;
	}

	while(fgets(buf,sizeof(buf),fp)!=NULL)
	{
		if(strncmp(buf,"# [1]",5)==0)
		{
			if(sscanf(buf,"# [1] FCSA%d.fits",&file_num)!=1)
			{
				printf("#warning : unknown format\n");
				printf("#%s",buf);
				continue;
			}
		}
		else if(strncmp(buf,"#   COL",6)==0)
		{
			fgets(buf,sizeof(buf),fp);
			if(sscanf(buf,"%lf %lf %lf %lf",&tx,&ty,&objx,
						&objy)!=4)
			{
				printf("#warning : unknown format\n");
				printf("#%s",buf);
				continue;
			}
#ifdef DEBUG
			printf("#obj: pix(%f,%f), world(%f,%f)\n",tx,ty,
					objx,objy);
#endif
		}
		else if(strncmp(buf,"Columns",7)==0)
		{
		}
		else if(buf[0]!='#')
		{
			sscanf(buf,"%lf %lf",&tx,&ty);
			fgets(buf,sizeof(buf),fp);
			sscanf(buf,"%lf %lf",&slitx,&slity);
#ifdef DEBUG
			printf("#slit: pix(%f,%f), world(%f,%f)\n",tx,ty,
					slitx,slity);
#endif
		}
	}
	fclose(fp);

//	dalpha=(objx-slitx)*3600.0/cos(objy/RADIAN);
	dalpha=(objx-slitx)*3600.0;
	ddec=(objy-slity)*3600.0;
	printf("dalpha=%f\nddec=%f\n",dalpha,ddec);

	return 0;
}

