#include <stdio.h>
#include <string.h>
#include <math.h>

#define	BUFSIZE	512
#define	MAXNUM	64
#define DEBUG
#define	CCDGAP	5.085	// in arcsec
#define	PIXELSIZE	(0.1037*2)	// in arcsec for 2x2 binned image
#define	OVSCAN	28	// width in pixel
#define	XMAX	996	// in chip2
#define	RADIAN	57.29577951

void fit_line(double[], double[], int, double[]);

int main(int argc, char *argv[])
{
	int	i,j;
	FILE	*fp;
	double	objx[2][MAXNUM],objy[2][MAXNUM];	// object on chip1/2
	double	slitx[2][MAXNUM],slity[2][MAXNUM];	// slit on chip1/2
	int	nobj[2]={0,0},nslit[2]={0,0};	// number of object/slit on chip1
	double	dy[2][MAXNUM];	// displacement between object and slit
	int	chip=1;
	int	file_num;
	char	buf[BUFSIZE];
	int	column1,column2;
	double	fittedfunc[3];	// fittedfunc[order]
	double	dtheta,ty,dx;

	if(argc!=2)
	{
		printf("usage : %s [imexam output]\n",argv[0]);
		return 0;
	}

	if((fp=fopen(argv[1],"rt"))==NULL)
	{
		printf("cannot open %s!\n",argv[1]);
		return 0;
	}

	while(fgets(buf,sizeof(buf),fp)!=NULL)
	{
		if(strncmp(buf,"# [1]",5)==0)
		{
			if(sscanf(buf,"# [1] FCSA%d.fits",&file_num)!=1)
			{
				printf("#warning : unknown format\n");
				printf("#%s",buf);
				continue;
			}
			if(file_num%2==1) chip=1;
			else chip=2;

#ifdef DEBUG
			printf("#chip=%d\n",chip);
#endif
		}
		else if(strncmp(buf,"#   COL",6)==0)
		{
			fgets(buf,sizeof(buf),fp);
			if(sscanf(buf,"%lf %lf",&objx[chip-1][nobj[chip-1]],
						&objy[chip-1][nobj[chip-1]])!=2)
			{
				printf("#warning : unknown format\n");
				printf("#%s",buf);
				continue;
			}
#ifdef DEBUG
			printf("#obj[%d][%d]=(%f,%f)\n",chip-1,nobj[chip-1],
					objx[chip-1][nobj[chip-1]],
					objy[chip-1][nobj[chip-1]]);
#endif
			nobj[chip-1]++;
		}
		else if(strncmp(buf,"Columns",7)==0)
		{
			if(sscanf(buf,"Columns %d-%d: center=%lf",&column1,
				&column2,&slity[chip-1][nslit[chip-1]])!=3)
			{
				printf("#warning : unknown format\n");
				printf("#%s",buf);
				continue;
			}
			slitx[chip-1][nslit[chip-1]]=(column1+column2)/2.0;
#ifdef DEBUG
			printf("#slit[%d][%d]=(%f,%f)\n",chip-1,nslit[chip-1],
					slitx[chip-1][nslit[chip-1]],
					slity[chip-1][nslit[chip-1]]);
#endif
			nslit[chip-1]++;
		}
	}
	fclose(fp);

	for(i=0;i<2;i++)
	{
		if(nslit[i]>1)
		{
			fit_line(slitx[i],slity[i],nslit[i],fittedfunc);
			if(fittedfunc[1]>0.0)
				printf("#y=%.2f+%gx, sigmay=%g\n",
					fittedfunc[0],fittedfunc[1],
					fittedfunc[2]);
			else
				printf("#y=%.2f%gx, sigmay=%g\n",
					fittedfunc[0],fittedfunc[1],
					fittedfunc[2]);
		}
		else if(nslit[i]==1)
		{
			fittedfunc[0]=slity[i][0];
			fittedfunc[1]=0.0;
		}
		else if(nslit[i]==0)
		{
			fittedfunc[0]=0.0;
			fittedfunc[1]=0.0;
		}

		if(nobj[i]>0)
		{
			if(nslit[i]==1)
				printf("#warning : only one-point for slit on chip%d\n",i+1);
			else if(nslit[i]==0)
				printf("#warning : no slit point for chip%d\n",i+1);

			printf("### chip%d ###\n",i+1);
			printf("#objx\tobjy\tslity\tdy(obj-slit)\n");
			for(j=0;j<nobj[i];j++)
			{
				ty=fittedfunc[0]+objx[i][j]*fittedfunc[1];
				dy[i][j]=objy[i][j]-ty;
				printf("%.2f\t%.2f\t%.2f\t%.2f\n",objx[i][j],
						objy[i][j],ty,dy[i][j]);
			}

			// in case of multiple object on 1 chip
			if(nobj[i]>1)
			{
				dtheta=-1.0*RADIAN*atan((dy[i][0]-dy[i][1])/(objx[i][0]-objx[i][1]));
				printf("theta=%f\n",dtheta);
			}
		}
	}

	if(nobj[0]==1 && nobj[1]==1)
	{
		dx=objx[0][0]+(XMAX-objx[1][0])+CCDGAP/PIXELSIZE-OVSCAN*2.0;
		dtheta=-1.0*RADIAN*atan((dy[0][0]-dy[1][0])/dx);
		printf("### chip 1 and 2 ###\n");
		printf("dx=%f, theta=%f\n",dx,dtheta);
	}

	return 0;
}

void fit_line(double x[], double y[], int ndata, double result[3])
{
	int	i;
	double	sx=0.0,sx2=0.0;
	double	sy=0.0,sxy=0.0;
	double	sigma=0.0;

	for(i=0;i<ndata;i++)
	{
		sx+=x[i];
		sx2+=x[i]*x[i];
		sy+=y[i];
		sxy+=x[i]*y[i];
	}

	result[0]=(sy*sx2-sxy*sx)/(ndata*sx2-sx*sx);
	result[1]=(sx*sy-ndata*sxy)/(sx*sx-ndata*sx2);

	if(ndata>2)
	{
		for(i=0;i<ndata;i++)
			sigma+=pow(y[i]-result[0]-result[1]*x[i],2.0);
		sigma=sqrt(sigma);
		result[2]=sigma;
	}
	else
		result[2]=0.0;

	return;
}
