; 
; Examples of TRACK_MOUSE usage.
; RSM, 1998 March.
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 


; This is the event handler
;
PRO TRACK_MOUSE_EVENT, EVENT


WIDGET_CONTROL, EVENT.TOP, GET_UVALUE = DRAW1, /NO_COPY

TYPE = TAG_NAMES(EVENT, /STRUCTURE)
CASE TYPE OF

 
 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 ;
 ; The button widget events
 ;
 'WIDGET_BUTTON': BEGIN

    WIDGET_CONTROL, EVENT.ID, GET_VALUE = VALUE, GET_UVALUE = UVALUE
                   
    UVALUE = STRUPCASE(UVALUE)
    CASE 1 OF 

         UVALUE EQ 'QUIT': BEGIN
               WIDGET_CONTROL, EVENT.TOP, /DESTROY
               RETURN
               END


         UVALUE EQ 'X': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, /GET_XRANGE)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END
                              
         UVALUE EQ 'Y': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, /GET_YRANGE)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END

         UVALUE EQ 'BOX': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END


         UVALUE EQ 'XNOWAIT': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, $
                  /GET_XRANGE, /NOWAIT)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END
                              
         UVALUE EQ 'YNOWAIT': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, $
                  /GET_YRANGE, /NOWAIT)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END

         UVALUE EQ 'BOXNOWAIT': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, /NOWAIT)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END


         UVALUE EQ 'XTOLERANCE': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, XTOL = 0.04)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END
         UVALUE EQ 'YTOLERANCE': BEGIN
               IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, YTOL = 0.04)) $
                  THEN BEGIN    
                  PRINT, 'OK'
                  PRINT, '  REGION = ', REGION
                  PRINT, '  COORDS = ', COORDINATES[0], COORDINATES[1], $
                         COORDINATES[2], COORDINATES[3]   
               ENDIF ELSE BEGIN
                  PRINT, 'Aborted'
                  PRINT, '  REGION = ', REGION
                  HELP, COORDINATES               
               ENDELSE
               END


         ; Multiple selections
         ;
         UVALUE EQ 'XMULTI': BEGIN
               
               doExit = 0
               numSel = 0
               xSelStart = -1
               xSelStop  = -1
               REPEAT BEGIN
               
                   IF (TRACK_MOUSE(DRAW1, REGION, COORDINATES, $
                      /GET_XRANGE, /NOWAIT)) $
                      THEN BEGIN    
                      OPLOT, [1, 1] * COORDINATES[0], !Y.CRANGE
                      OPLOT, [1, 1] * COORDINATES[2], !Y.CRANGE
                      xSelStart = [xSelStart, COORDINATES[0]]
                      xSelStop  = [xSelStop,  COORDINATES[2]]
                   
                      numSel = numSel + 1
                   
                   ENDIF ELSE BEGIN
                   
                      doExit = 1
                   
                   ENDELSE
               
               ENDREP UNTIL (doExit EQ 1) 
    
               PRINT, 'Number of selections: ', numSel
               IF (N_ELEMENTS(xSelStart) NE 1) THEN BEGIN           
                  xSelStart = xSelStart[1:*]
                  xSelStop  = xSelStop[1:*]
               
                  FOR i=0, numSel-1 DO BEGIN
                      OPLOT, [1, 1] * xSelStart[i], !Y.CRANGE, $
                             COLOR =!P.BACKGROUND
                      OPLOT, [1, 1] * xSelStop[i], !Y.CRANGE, $
                             COLOR =!P.BACKGROUND
                      PRINT, '   [', STRTRIM(xSelStart[i], 2), ', ', $
                                     STRTRIM(xSelStop[i], 2), ']'
                  ENDFOR
               ENDIF
               
               END

         ELSE: PRINT, 'ERROR in UVALUE!'

    ENDCASE ; UVALUE
    END

 ; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 ; The draw widget events
 ;
 'WIDGET_DRAW': BEGIN
    ;
    ; YOU MUST HANDLE WIDGET_DRAW EVENTS WHEN USING TRACK_MOUSE !
    ;
    END

ENDCASE ; TYPE

WIDGET_CONTROL, EVENT.TOP, SET_UVALUE = DRAW1, /NO_COPY



END
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
PRO TRACK_MOUSE_EXAMPLE



; Parent
TOP_BASE = WIDGET_BASE(TITLE = ' ', /COLUMN)

; Base for the rest of the menu
SUB_TOP_BASE = WIDGET_BASE(TOP_BASE, /ROW)

BASE1 = WIDGET_BASE(SUB_TOP_BASE, /COLUMN, /FRAME)

SUB_BASE0 = WIDGET_BASE(BASE1, /COLUMN)

w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'QUIT', UVALUE = 'QUIT')

w = WIDGET_LABEL(SUB_BASE0, VALUE = ' ')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Track X-Range', UVALUE = 'x')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Track Y-Range', UVALUE = 'y')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Track Box', UVALUE = 'box')

w = WIDGET_LABEL(SUB_BASE0, VALUE = ' ')
w = WIDGET_LABEL(SUB_BASE0, VALUE = 'Tolerance')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'X Tolerance', UVALUE = 'xtolerance')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Y Tolerance', UVALUE = 'ytolerance')

w = WIDGET_LABEL(SUB_BASE0, VALUE = ' ')
w = WIDGET_LABEL(SUB_BASE0, VALUE = 'No Wait')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Track X-Range', UVALUE = 'xnowait')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Track Y-Range', UVALUE = 'ynowait')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'Track Box', UVALUE = 'boxnowait')

w = WIDGET_LABEL(SUB_BASE0, VALUE = ' ')
w = WIDGET_LABEL(SUB_BASE0, VALUE = 'Multi-Select')
w = WIDGET_BUTTON(SUB_BASE0, VALUE = 'X-Range', UVALUE = 'xmulti')



CURRENT_SCREEN = GET_SCREEN_SIZE()

DRAW_SUB_BASE = WIDGET_BASE(SUB_TOP_BASE, /COLUMN, /FRAME)

w = WIDGET_LABEL(DRAW_SUB_BASE, VALUE = 'TRACK_MOUSE Demo')

; Note: If we don't add BUTTON and MOTION events to the draw widget, they
; will be enabled by TRACK_MOUSE

DRAW1 = WIDGET_DRAW(DRAW_SUB_BASE, $
            XSIZE = CURRENT_SCREEN(0)*0.65, $
            YSIZE = CURRENT_SCREEN(1)*0.60, /FRAME)

WIDGET_CONTROL, GET_VALUE = WINDOW, DRAW1


WIDGET_CONTROL, TOP_BASE, SET_UVALUE = DRAW1, /NO_COPY

WIDGET_CONTROL, TOP_BASE, /REALIZE, SHOW = 1 

WSET, WINDOW
PLOT, /XLOG, FINDGEN(100)+1, FINDGEN(100)

; Register with XMANAGER
XMANAGER, 'TRACK_MOUSE', TOP_BASE




END
