# extract spectra from FOCAS MOS data and combine to a fits file
procedure speccomb( input, sbrfile, output )
#
file	input	{prompt="input image(s)"}
file	sbrfile	{prompt="SBR file"}
file	output	{prompt="output image(s)"}

string	distdata="DistChipDat.HPK.101112.dat"	{prompt="distortion data file in FOCASREDHOME$DATA/"}
real rot=0.0	{prompt="MOS rotation in falcon (degree)"}
real dx=0.0	{prompt="shift for slit positions in the input image (pix)"}

struct *list1
struct *list2

begin
	string	inlist, outlist, inimg, outimg, sbr
	string	distfile,focasred_dir
	string	regfile
	string	tmp1,tmp2,tmp3
	real	delta_x,mask_rot
	int	i=1

# initialize variables
	inlist=input
	outlist=output
	sbr=sbrfile
	focasred_dir = osfn("FOCASREDHOME$")
	distfile = distdata
	delta_x=dx
	mask_rot=rot

# task definition
	task	$c_spec_comb = ("$"//focasred_dir//"/bin/spec_comb")

	tmp1=mktemp("sc_tmp.")
	tmp2=mktemp("sc_tmp.")
	sections(inlist,option='fullname', > tmp1)
	sections(outlist,option='fullname', > tmp2)
	list1=tmp1
	list2=tmp2
	while( fscan(list1,inimg)==1 && fscan(list2,outimg)==1 )
	{
		regfile = inimg//".reg"
		print("spec_comb"," ",focasred_dir," ",distfile," ",inimg," ",sbr," ",outimg," ",mask_rot," ",delta_x)
		c_spec_comb(focasred_dir,distfile,inimg,sbr,outimg,mask_rot,delta_x)
	}

	delete(tmp1,ver-)
	delete(tmp2,ver-)

	bye
end

