# recover WCS information cleared by bigimage.pro

procedure resume_wcs(input)
file	input	{prompt="input image list"}
real	pa_offset=0.0	{prompt="PA offset"}
real	pixelscale=0.1038 {prompt="pixel scale without binning"}
struct *list1

begin
	string	inlist
	string	imname
	string	tmp1,tmp2
	string	yn="y"
	real	cd11,cd12,cd21,cd22
	real	inst_pa,pa
	real	pa_off
	real	offset_pa=0.3
	real	pixscale
	real	radian=57.29577951
	real	crpix1,crpix2
	int	xbin,ybin,chip

	inlist = input
	tmp1=mktemp("rw_tmp")
	pa_off=pa_offset
	pixscale=pixelscale

	sections(inlist,option='fullname', > tmp1)
	list1=tmp1

	while(fscan(list1,imname)==1)
	{
		imgets(imname,'BIN-FCT1')
		xbin=int(imgets.value)
		imgets(imname,'BIN-FCT2')
		ybin=int(imgets.value)
		imgets(imname,'INST-PA')
		inst_pa=real(imgets.value)
		pa=-1.0*inst_pa+offset_pa+pa_off
		imgets(imname,'DET-ID')
		chip=int(imgets.value)

		if(chip==2)
		{
			crpix1=1964.0/xbin
			crpix2=2043.0/ybin
		}
		else
		{
			crpix1=-34.0/xbin
			crpix2=2041.0/xbin
		}

		cd11=-1.0*sin(pa/radian)*pixscale*xbin/3600.0
		cd12=cos(pa/radian)*pixscale*xbin/3600.0
		cd21=-1.0*cos(pa/radian)*pixscale*ybin/3600.0
		cd22=-1.0*sin(pa/radian)*pixscale*ybin/3600.0

		print("delete : PC00*00*")
		print("CD1_1 = ",cd11)
		print("CD1_2 = ",cd12)
		print("CD2_1 = ",cd21)
		print("CD2_2 = ",cd22)
		print("CRPIX1= ",crpix1)
		print("CRPIX2= ",crpix2)

		printf("  OK? ([y]/n):")
		scan(yn);
		if(yn=="n")
		{
			print("skipping ",imname)
		}
		else
		{
			hedit(imname,"PC001001","",add-,del+,ver-,show+,update+)
			hedit(imname,"PC001002","",add-,del+,ver-,show+,update+)
			hedit(imname,"PC002001","",add-,del+,ver-,show+,update+)
			hedit(imname,"PC002002","",add-,del+,ver-,show+,update+)
			hedit(imname,"CD1_1",cd11,add+,del-,ver-,show+,update+)
			hedit(imname,"CD1_2",cd12,add+,del-,ver-,show+,update+)
			hedit(imname,"CD2_1",cd21,add+,del-,ver-,show+,update+)
			hedit(imname,"CD2_2",cd22,add+,del-,ver-,show+,update+)
			hedit(imname,"CRPIX1",crpix1,add+,del-,ver-,show+,update+)
			hedit(imname,"CRPIX2",crpix2,add+,del-,ver-,show+,update+)
		}
	}

	delete(tmp1,ver-)

end
