procedure ovsub_hpk(input,output)
file	input	{prompt="input image list"}
file	output	{prompt="output image list"}
int	ybox=15	{prompt="smoothing along Y-axis"}
struct *list1
struct *list2
struct *list3

begin
	string inlist,outlist
	string inimg,outimg
	string tmp1,tmp2,tmp3
	string tmpimg1,biasimg
	string tbias1,tbias2,tbias3,tbias4
	string tobj1,tobj2,tobj3,tobj4
	string ovscan
	string region1,region2,region3,region4
	string ovregion1,ovregion2,ovregion3,ovregion4
	int npix_img,npix_ov
	int detid,xbin
	real gain1,gain2,gain3,gain4

	inlist=input
	outlist=output
	tmp1=mktemp("ovs_tmp")
	tmp2=mktemp("ovs_tmp")
	detid=0
	xbin=1

	sections(inlist,option='fullname', > tmp1)
	list1=tmp1
	sections(outlist,option='fullname', > tmp2)
	list2=tmp2

	while( fscan(list1,inimg)==1 && fscan(list2,outimg)==1)
	{
		# set regions
		imgets(inimg,'DET-ID')
		detid=int(imgets.value)
		imgets(inimg,'BIN-FCT1')
		xbin=int(imgets.value)
		if(xbin==1||xbin==0)
		{
			if(detid==1)
			{
				region1="[9:520,*]"
				ovregion1="[521:535,*]"
				ovregion2="[538:552,*]"
				region2="[553:1064,*]"
				region3="[1081:1592,*]"
				ovregion3="[1593:1607,*]"
				ovregion4="[1611:1625,*]"
				region4="[1626:2137,*]"

				gain1=2.081
				gain2=2.047
				gain3=2.111
				gain4=2.087
			}
			else
			{
				region1="[9:520,*]"
				ovregion1="[521:535,*]"
				ovregion2="[538:552,*]"
				region2="[553:1064,*]"
				region3="[1081:1592,*]"
				ovregion3="[1593:1607,*]"
				ovregion4="[1610:1624,*]"
				region4="[1625:2136,*]"

				gain1=2.105
				gain2=1.968
				gain3=1.999
				gain4=1.918
			}
			npix_ov=15
			npix_img=512
		}
		else if(xbin==2)
		{
			if(detid==1)
			{
				region1="[5:260,*]"
				ovregion1="[261:275,*]"
				ovregion2="[278:292,*]"
				region2="[293:548,*]"
				region3="[557:812,*]"
				ovregion3="[813:827,*]"
				ovregion4="[831:845,*]"
				region4="[846:1101,*]"

				gain1=2.081
				gain2=2.047
				gain3=2.111
				gain4=2.087
			}
			else
			{
				region1="[5:260,*]"
				ovregion1="[261:275,*]"
				ovregion2="[278:292,*]"
				region2="[293:548,*]"
				region3="[557:812,*]"
				ovregion3="[813:827,*]"
				ovregion4="[830:844,*]"
				region4="[845:1100,*]"

				gain1=2.105
				gain2=1.968
				gain3=1.999
				gain4=1.918
			}
			npix_ov=15
			npix_img=256
		}
		else if(xbin==4)
		{
			if(detid==1)
			{
				region1="[3:130,*]"
				ovregion1="[131:145,*]"
				ovregion2="[148:162,*]"
				region2="[163:290,*]"
				region3="[295:422,*]"
				ovregion3="[423:437,*]"
				ovregion4="[441:455,*]"
				region4="[456:583,*]"

				gain1=2.081
				gain2=2.047
				gain3=2.111
				gain4=2.087
			}
			else
			{
				region1="[3:130,*]"
				ovregion1="[131:145,*]"
				ovregion2="[148:162,*]"
				region2="[163:290,*]"
				region3="[295:422,*]"
				ovregion3="[423:437,*]"
				ovregion4="[440:454,*]"
				region4="[455:582,*]"

				gain1=2.105
				gain2=1.968
				gain3=1.999
				gain4=1.918
			}
			npix_ov=15
			npix_img=128
		}
		else
		{
			printf("invalid binning factor : %d\n",xbin);
			goto bye
		}

		### object
		tobj1=mktemp("ovs_tmp")
		tobj2=mktemp("ovs_tmp")
		tobj3=mktemp("ovs_tmp")
		tobj4=mktemp("ovs_tmp")
		imcopy(inimg//region1,tobj1)
		imcopy(inimg//region2,tobj2)
		imcopy(inimg//region3,tobj3)
		imcopy(inimg//region4,tobj4)

		### bias (overscan)
		biasimg=mktemp("ovs_tmp")
		tmpimg1=mktemp("ovs_tmp")
		tbias1=mktemp("ovs_tmp")
		tbias2=mktemp("ovs_tmp")
		tbias3=mktemp("ovs_tmp")
		tbias4=mktemp("ovs_tmp")

		# 1st
		imcopy(inimg//ovregion1,tmpimg1)
		imarith(tmpimg1,'*',1.0,tmpimg1)
		blkavg(tmpimg1,tbias1,npix_ov,1,option="average")
		if(ybox>1)
		{
			boxcar(tbias1,tbias1,1,ybox,boundary="reflect")
		}
		blkrep(tbias1,tbias1,npix_img,1)
		imdel(tmpimg1,ver-)

		# 2nd
		imcopy(inimg//ovregion2,tmpimg1)
		imarith(tmpimg1,'*',1.0,tmpimg1)
		blkavg(tmpimg1,tbias2,npix_ov,1,option="average")
		if(ybox>1)
		{
			boxcar(tbias2,tbias2,1,ybox,boundary="reflect")
		}
		blkrep(tbias2,tbias2,npix_img,1)
		imdel(tmpimg1,ver-)

		# 3rd
		imcopy(inimg//ovregion3,tmpimg1)
		imarith(tmpimg1,'*',1.0,tmpimg1)
		blkavg(tmpimg1,tbias3,npix_ov,1,option="average")
		if(ybox>1)
		{
			boxcar(tbias3,tbias3,1,ybox,boundary="reflect")
		}
		blkrep(tbias3,tbias3,npix_img,1)
		imdel(tmpimg1,ver-)

		# 4th
		imcopy(inimg//ovregion4,tmpimg1)
		imarith(tmpimg1,'*',1.0,tmpimg1)
		blkavg(tmpimg1,tbias4,npix_ov,1,option="average")
		if(ybox>1)
		{
			boxcar(tbias4,tbias4,1,ybox,boundary="reflect")
		}
		blkrep(tbias4,tbias4,npix_img,1)
		imdel(tmpimg1,ver-)

		tmp3=mktemp("ovs_tmp")
		imarith(tobj1,"-",tbias1,tobj1)
		imarith(tobj2,"-",tbias2,tobj2)
		imarith(tobj3,"-",tbias3,tobj3)
		imarith(tobj4,"-",tbias4,tobj4)
		imarith(tobj1,"*",gain1,tobj1)
		imarith(tobj2,"*",gain2,tobj2)
		imarith(tobj3,"*",gain3,tobj3)
		imarith(tobj4,"*",gain4,tobj4)
		print(tobj1,> tmp3)
		print(tobj2,>> tmp3)
		print(tobj3,>> tmp3)
		print(tobj4,>> tmp3)
		imjoin("@"//tmp3,outimg,1)
		imdel("@"//tmp3,ver-)
		delete(tmp3,ver-)
		imdel(tbias1,ver-)
		imdel(tbias2,ver-)
		imdel(tbias3,ver-)
		imdel(tbias4,ver-)
	}

	delete(tmp1,ver-)
	delete(tmp2,ver-)

	bye

end

