procedure mosident(input)
file	input	{prompt="input image(s)"}
file	linedata="thar.300.dat"	{prompt="file name for the list of wavelength"}
int     order=5 {prompt="fitting order for identify"}

struct *list1
struct *list2

begin
	string	inlist, linelist, datadir
	string	tmp1,tmp2,tmp3,tmp4,tmp5
	string	tmplist
	string	img,prev_img
	string	logf,section
	real	crpix2,cdelt2,crval2
	real	prev_crpix2,dlam
	real	width
	int	ybin,ord

# initialize variables
	logf="mosident.log"
	section="column 6"
	inlist=input
	datadir=osfn("FOCASREDHOME$")
	linelist=datadir//"/IRAF/"//linedata
	cdelt2=0.0
	width=0.0
	if (!deftask("autoidentify")) onedspec
	prev_img=""
	ord=order

	tmp1=mktemp("mi_tmp.")

	sections(inlist,option='fullname', > tmp1)

	list1=tmp1

	while( fscan(list1,img)==1 )
	{
### get wavelength information
		imgets(img,'CRVAL2')
		crval2=real(imgets.value)
		imgets(img,'CRPIX2')
		crpix2=real(imgets.value)
		imgets(img,'CDELT2')
		cdelt2=real(imgets.value)
		imgets(img,'FWIDTH')
		width=real(imgets.value)
		if(cdelt2==0.0)
		{
			print("ERROR: wavelength information not found in "//img)
			goto continue
		}
		if(width==0.0)
		{
			# default slit width = 8pixel
			imgets(img,'BIN-FCT2')
			ybin=int(imgets.value)
			width=8.0/ybin
		}

		printf("autoidentify %s %.2f %.3f coordlist=%s section=%s aidpars.crpix=%.1f aidpars.aidord=5 nsum=5 niter=1 order=%d func=cheb fwidth=%.2f logfile=%s inter- dbwrite=YES\n",img,crval2,cdelt2,linelist,section,crpix2,ord,width,logf)
		autoidentify(img,crval2,cdelt2,coordlist=linelist,section=section,aidpars.crpix=crpix2,aidpars.aidord=5,nsum=5,niter=1,order=ord,func="cheb",fwidth=width,logfile=logf,inter-,dbwrite="YES")

		# check result
		tmp2=mktemp("mi_tmp.")
		tail(logf,nlines=1,> tmp2)
		list2=tmp2
		if(fscan(list2,tmp3,tmp4,tmp5)==3)
		{
			# if "No solution", use the result of the previous slit for reidentify
			if(tmp4=="No"&&tmp5=="solution")
			{
				if(prev_img!="")
				{
					imgets(prev_img,'CRPIX2')
					prev_crpix2=real(imgets.value)
					dlam=(crpix2 - prev_crpix2)*cdelt2
					printf("reidentify %s %s step=0 inter- section=%s logfile=%s shift=%f\n",prev_img,img,section,logf,dlam)
					reidentify(prev_img,img,step=0,inter-,section=section,logfile=logf,shift=dlam)
				}
				else
					printf("autoidentify failed\n")
			}

			# manually check the identification
			identify(img,coordlist=linelist,section=section,nsum=5,niter=1,order=ord,func="cheb",fwidth=width)
		}
		else
		{
			printf("error in reading log-file %s!\n",logf)
		}
		delete(tmp2,ver-)

		# identify the other part of the slit
		reidentify(img,img,section=section,nsum=5,step=5,inter-,ver+,nlost=2)

		prev_img=img

continue:
	}

	delete(tmp1,ver-)

end

