# extract spectra from FOCAS MOS data
procedure mosextract( input, sbrfile )
#
file	input	{prompt="input image(s)"}
file	sbrfile	{prompt="SBR file"}

string	distdata="DistChipDat.HPK.101112.dat"	{prompt="distortion data file in FOCASREDHOME$DATA/"}
real rot=0.0	{prompt="MOS rotation in falcon (degree)"}
real dx=0.0	{prompt="shift for slit positions in the input image (pix)"}
string	mdpfile=""	{prompt="optional mdp file for comments"}

struct *list1

begin
	string	inlist, inimg, sbr
	string	distfile,focasred_dir
	string	clfile,mdp
	string	tmp1,tmp2,tmp3
	real	delta_x, mask_rot
	int	i=1

# initialize variables
	inlist=input
	sbr=sbrfile
	focasred_dir = osfn("FOCASREDHOME$")
	distfile = distdata
	delta_x=dx
	mdp=mdpfile
	mask_rot=rot

# task definition
	task	$c_spec_extract = ("$"//focasred_dir//"/bin/spec_extract")
#	task	$c_spec_extract = ("$"//"prog/spec_extract")

	tmp1=mktemp("me_tmp.")
	sections(inlist,option='fullname', > tmp1)
	list1=tmp1
	while( fscan(list1,inimg)==1 )
	{
		clfile=inimg//".cl"
		delete(clfile,ver+)
		if(mdp=="")
		{
			print("spec_extract"," ",focasred_dir," ",distfile," ",inimg," ",sbr," ",mask_rot," ",delta_x)
			c_spec_extract(focasred_dir,distfile,inimg,sbr,mask_rot,delta_x, > clfile)
		}
		else
		{
			print("spec_extract"," ",focasred_dir," ",distfile," ",inimg," ",sbr," ",mask_rot," ",delta_x," ",mdp)
			c_spec_extract(focasred_dir,distfile,inimg,sbr,mask_rot,delta_x,mdp, > clfile)
		}

		if(i==1)
		{
			task $exec_extract=""//clfile//""
		}
		else
		{
			redef $exec_extract=""//clfile//""
		}

		exec_extract()

		i=i+1
	}

	printf("### the script is saved to %s\n",clfile)

	delete(tmp1,ver-)

	bye
end

