procedure mkcomparison(blue,red,output)
file	blue	{prompt="ThAr image(s) for blue"}
file	red	{prompt="ThAr image(s) for red"}
file	output	{prompt="output image list"}
real	wavelen=6900.0	{prompt="Wavelength to combine the blue and red data"}

struct *list_blue
struct *list_red
struct *list_out

begin
	string	bluelist,redlist,outlist
	int	i,xlen,ylen,txlen,tylen
	int	n_image_blue,n_image_red,n_image_out
	string	tmp1,tmp2,tmp3,tmp4,tmp5
	string	tmplist
	string	blueimg,redimg,outimg
	real	wav
	real	crpix2,cdelt2,crval2
	int	ypix

# initialize variables
	bluelist=blue
	redlist=red
	outlist=output
	wav=wavelen

	sections(bluelist,option='nolist')
	n_image_blue = sections.nimages
	sections(redlist,option='nolist')
	n_image_red = sections.nimages
	sections(outlist,option='nolist')
	n_image_out = sections.nimages

	if(n_image_blue != n_image_red)
	{
		print("ERROR: Number of blue and red images not the same")
		clbye()
	}
	else if(n_image_blue != n_image_out)
	{
		print("ERROR: Number of input and output images not the same")
		clbye()
	}

	tmp1=mktemp("mc_tmp.")
	tmp2=mktemp("mc_tmp.")
	tmp3=mktemp("mc_tmp.")
	tmp4=mktemp("mc_tmp.")
	tmp5=mktemp("mc_tmp.")

	sections(bluelist,option='fullname', > tmp1)
	sections(redlist,option='fullname', > tmp2)
	sections(outlist,option='fullname', > tmp3)
	list_blue=tmp1
	list_red=tmp2
	list_out=tmp3

	while( fscan(list_blue,blueimg)==1 && fscan(list_red,redimg)==1 && fscan(list_out,outimg)==1)
	{
### check image size
		imgets(blueimg,'i_naxis1')
		xlen=int(imgets.value)
		imgets(blueimg,'i_naxis2')
		ylen=int(imgets.value)
		imgets(redimg,'i_naxis1')
		txlen=int(imgets.value)
		imgets(redimg,'i_naxis2')
		tylen=int(imgets.value)

		if(xlen!=txlen || ylen!=tylen)
		{
			print("ERROR: "//blueimg//" and "//redimage//" have different image size. skpping")
			goto continue
		}

### get wavelength information
		imgets(blueimg,'CRVAL2')
		crval2=real(imgets.value)
		imgets(blueimg,'CRPIX2')
		crpix2=real(imgets.value)
		imgets(blueimg,'CDELT2')
		cdelt2=real(imgets.value)
		if(cdelt2==0.0)
		{
			print("ERROR: wavelength information not found in "//blueimg)
			goto continue
		}

		ypix=int(crpix2+(wav-crval2)/cdelt2)
### if CDELT < 0.0,  blue is top and red is bottom
		if(cdelt2<0.0)
		{
			print(redimg//"[*,1:"//ypix//"] + "//blueimg//"[*,"//ypix+1//":"//ylen//"] -> "//outimg)
			imjoin(redimg//"[*,1:"//ypix//"],"//blueimg//"[*,"//ypix+1//":"//ylen//"]",outimg,2,ver-)
		}
		else
		{
			print(blueimg//"[*,1:"//ypix//"] + "//redimg//"[*,"//ypix+1//":"//ylen//"] -> "//outimg)
			imjoin(blueimg//"[*,1:"//ypix//"],"//redimg//"[*,"//ypix+1//":"//ylen//"]",outimg,2,ver-)
		}

continue:
	}


	delete(tmp1,ver-)
	delete(tmp2,ver-)
	delete(tmp3,ver-)

end

