## #http://iraf.net/phpBB2/viewtopic.php?t=82086

# Bo Milvang-Jensen <milvang@mpe.mpg.de> 
# 05-Sep-2003 

# Task to carry out the inverse transformation of that done by TRANSFORM. 
# In both cases the transformation has been established using FITCOORDS. 

# This task was made possible by the new task FCEVAL and its help page 
# written by Frank Valdes <valdes@noao.edu> . 

# Note: the task has not been optimised in terms of speed and memory usage. 


# The main parameters for this task are: 
# origim : input untransformed image (only the dimensions are used) 
# transim : input transformed image (to be inverse-transformed) 
# fitname : input name of FITCOORDS fit defining the transformatio 
# invimage: output inverse-transformed image 

# Notation: 
# origim : logical coordinates are x_logical , y_logical 
# transim : logical coordinates are x'_logical, y'_logical 
# world coordinates are x'_WCS , y'_WCS 

procedure invtransform (origim,transim,fitname,invimage) 

char origim {"", prompt="Untransformed image (only the dims. are used)"} 
char transim {"", prompt="Transformed image (to be inverse-transformed)"} 
char fitname {"", prompt="Name of FITCOORDS map(s) defining the transf."} 
char invimage {"", prompt="Output inverse-transformed image"} 

int step1 {1, prompt="Step in x_logical for FCEVAL input grid"} 
int step2 {1, prompt="Step in y_logical for FCEVAL input grid"} 

char database {"database", prompt="Database/dir containing the coordinate maps"} 

char function {"chebyshev", prompt="geomap: Surface type"} 
int xxorder {10, prompt="geomap: Order of x fit in x"} 
int xyorder {10, prompt="geomap: Order of x fit in y"} 
char xxterms {"half", prompt="geomap: X fit cross terms type"} 
int yxorder {10, prompt="geomap: Order of y fit in x"} 
int yyorder {10, prompt="geomap: Order of y fit in y"} 
char yxterms {"half", prompt="geomap: Y fit cross terms type"} 
char calctype {"double", prompt="geomap: Computation type"} 
bool gverbose {yes, prompt="geomap: verbose?"} 
bool interactive {no, prompt="geomap: interactive?"} 

char interpol {"poly3", prompt="geotran: Interpolant"} 

begin 

char tmp1, tmp2, tmp3, tmp4 
int orig_n1, orig_n2, i1, i2 

tmp1 = mktemp("tmp1_") 
tmp2 = mktemp("tmp2_") 
tmp3 = mktemp("tmp3_") 
tmp4 = mktemp("tmp4_") 


# Get x and y dimensions (i.e. size) of original image 
imgets (origim, "i_naxis1") ; orig_n1 = int(imgets.value) 
imgets (origim, "i_naxis2") ; orig_n2 = int(imgets.value) 

# Create a grid of x_logical, y_logical values 
for (i2 = 1; i2 <= orig_n2; i2 += step2) 
for (i1 = 1; i1 <= orig_n1; i1 += step1) 
print (i1, i2, >> tmp1) 
# 
# Note: the listpix trick used in the (draft) help page of FCEVAL is not used 
# since it would fail where linear operations had been done on the image 
# (e.g. copying out a section from a bigger image), i.e. where the 
# LTV1 and/or LTV2 keywords are defined and non-zero. 


# Calculate the x'_WCS, y'_WCS coordinates defined by the transformation 
fceval (tmp1, tmp2, fitname, database=database) 
delete (tmp1, go_ahead=yes, verify=no) 
# 
# Note: output file tmp2 contains the following 4 columns: 
# x_logical, y_logical, x'_WCS, y'_WCS 


# Using the WCS of 'transim', transform x'_WCS, y'_WCS to x'_logical, y'_logical 
wcsctran (tmp2, tmp3, transim, "world", "logical", columns="3 4", units="", 
format="", min_sigdigit=7, verbose=yes) 
delete (tmp2, go_ahead=yes, verify=no) 
# 
# Note: output file tmp3 contains the following 4 columns: 
# x_logical, y_logical, x'_logical, y'_logical 


# Fit (x_logical, y_logical) as function of (x'_logical, y'_logical) 
geomap (tmp3, tmp4, 1, orig_n1, 1, orig_n2, transforms="", results="", 
fitgeometry="general", function=function, 
xxorder=xxorder, xyorder=xyorder, xxterms=xxterms, 
yxorder=yxorder, yyorder=yyorder, yxterms=yxterms, 
maxiter=0, reject=3, calctype=calctype, verbose=gverbose, 
interactive=interactive, graphics="stdgraph", cursor="") 
delete (tmp3, go_ahead=yes, verify=no) 
# 
# Note: the output database file is tmp4, and within this the name of the fit 
# is tmp3 


# Carry out the inverse transformation 
geotran (transim, invimage, tmp4, tmp3, 
xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, 
xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, 
xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1., yscale=1., 
ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., 
interpolant=interpol, boundary="nearest", constant=0., fluxconserve=yes, 
nxblock=512, nyblock=512, verbose=yes) 
delete (tmp4, go_ahead=yes, verify=no) 
# 
# Note: we are not saving the file specifying the inverse transformation (tmp4) 

end
