#------------------------------------------------------------
#	FOCAS CL software
#
#	Convert HSC images into FOCAS pre-image for mask design
#
#	2015/12/29	C.-H. Lee
#------------------------------------------------------------
procedure hsc2focas(inlist,outlist)
#
file	inlist		{prompt= "Input image "}
file	outlist		{prompt= "Output image "}
int     xc=1251          {prompt= "Center X coordinate "}
int     yc=1251          {prompt= "Center Y coordinate "} 
#


begin

	string 	linlist, loutlist
	string	range,allin 
	int	xi,xe,yi,ye

#---- Initialize parameters.
	linlist = inlist
	loutlist = outlist
	xi = xc - 1250
	xe = xc + 1250
	yi = yc - 1250
	ye = yc + 1250
        range = "[" + xi + ":" + xe + "," + yi + ":" + ye + "]" 
        allin = linlist + range 
	print("cutting imag ",linlist, " ",range)
	imcopy(allin,'tmp_cut.fits')
	magnify('tmp_cut.fits','tmp_mag.fits',1.6192,1.6192,interp='linear')
	imcopy('tmp_mag.fits[-*,*]','tmp_flip.fits')
	rotate('tmp_flip.fits',outlist,90)
	#rotate('tmp_flip.fits','tmp_rot.fits',89.89246)
	#imshift('tmp_rot.fits',outlist,-1216.96,-1165.71) 
	delete('tmp_cut.fits',ver-)
	delete('tmp_mag.fits',ver-)
	delete('tmp_flip.fits',ver-)
	#delete('tmp_rot.fits',ver-)

#bye
end
