#------------------------------------------------------------
#	FOCAS CL software
#
#	Wavelength Calibration by OH+ lines
#
#	2001/03/12	Y. Ohyama
#------------------------------------------------------------

procedure fwavecalib_sky( inlist,outlist)
#
file	inlist		{prompt= "Input image list / no fits extention "}
file	outlist		{prompt= "Output image list / no fits extention "}
#

begin

string 	linlist, loutlist
string 	obj

#---- Initialize parameters.
linlist = inlist
loutlist = outlist

print,'5579(strongest),6300,6364,7316.29,7794.12,8399.17,8885.83,9439.66'

	identify(linlist//'.fits',section='middle column',databas='database',\
		coordli='linelists$skylines.dat',nsum=10,match=-3.,\
		maxfeat=30,fwidth=4.,cradius=4.,functio='legendre',\
		order=3,niterate=5,low_rej=3.,high_rej=3.,grow=1.,\
		ftype='emission',thresh=500,autowrite+,mode=mode )

	reidentify(linlist,linlist//'.fits',section='middle column',interac-,\
	        newaps-,overrid+,refit+,trace+,addfeat-,\
 		step=10,nsum=15,shift=0.,nlost=100,cradius=4.,\
 		thresho=0.,match=20.,maxfeat=25,\
 	#	minsep=2.,coordli='linelists$thar.dat',\
 		minsep=2.,\
 		databas='database',ver+,answer=no,\
 		logfile="", mode=mode )

	fitcoords(linlist,fitname='fit_cal_blue_2',databas='database',interac+,\
		functio='legendre',xorder=3,yorder=3,combine+,mode=mode )

	transform(linlist//'.fits',loutlist//'.fits','fit',databas='database',\
                interpt='linear',y1=5945,dy=1.227,x1=1,\
                y2=8399,ny=2000,\
                x2=69,dx=1,nx=69,mode=mode )

bye
end
