#------------------------------------------------------------
#	FOCAS CL software
#
#	Wavelength Calibration by CAL
#
#	2001/03/12	Y. Ohyama
#------------------------------------------------------------

procedure fwavecalib( inlist,complist,outlist)
#
file	inlist		{prompt= "Input image list / no fits extention "}
file	complist	{prompt= "Input comparison image list / no fits extention "}
file	outlist		{prompt= "Output image list / no fits extention "}
#

begin

string 	linlist, lcomplist,loutlist
string 	obj

#---- Initialize parameters.
linlist = inlist
lcomplist=complist
loutlist = outlist

print,'5153 (weak),5579(strongest),5890,6300,6364'

	identify(lcomplist//'.fits',section='middle column',databas='database',\
		coordli='linelists$skylines.dat',nsum=20,match=-3.,\
		maxfeat=130,fwidth=4.,cradius=4.,functio='legendre',\
		order=4,niterate=5,low_rej=3.,high_rej=3.,grow=0.,\
		ftype='emission',thresh=50,autowrite+,mode=mode )

        reidentify(lcomplist,lcomplist//'.fits',section='middle column',interac-,\
	        newaps-,overrid+,refit+,trace+,addfeat-,\
 		step=10,nsum=20,shift=0.,nlost=10,cradius=4.,\
 		thresho=0.,match=20.,maxfeat=25,\
 		minsep=2.,coordli='mysnghome$myfene.dat',\
 		databas='database',ver+,answer=no,\
 		logfile="", mode=mode )

	fitcoords(lcomplist,fitname='fit',databas='database',interac+,\
		functio='legendre',xorder=3,yorder=3,combine+,mode=mode )

	transform(linlist//'.fits',loutlist//'.fits','fit',databas='database',\
		interpt='linear',y1=INDEF,dy=INDEF,x1=INDEF,\
		y2=INDEF,ny=INDEF,\
		x2=INDEF,dx=INDEF,nx=INDEF,mode=mode )

bye
end
