#------------------------------------------------------------
#	FOCAS CL software
#
#	Sensitivity Calibration
#
#	2001/03/12	Y. Ohyama
#------------------------------------------------------------
procedure fsenscalib( inlist,outlist,stdlist)
#
file	inlist		{prompt= "Input image list / no fits extention "}
file	outlist		{prompt= "Output image list / no fits extention "}
file	stdlist		{prompt= "2D Standard image list / no fits extention "}
file	extdata='mkoextinct.dat'		{prompt= "extinction data "}

#
begin

string 	linlist, loutlist,lstdlist
string 	obj,extfile,onedspec
int ysize,stcol,endcol,haba

#---- Initialize parameters.
linlist = inlist
loutlist = outlist
lstdlist=stdlist

if(access('std2.imh')) imdelete('std2.imh')
if(access('std')) delete('std')

#extfile='/home/ohyama/IDL/mkoextinct.dat'
extfile="FOCASREDHOME$"//'IRAF/'//extdata
#print(extfile)

imgets(lstdlist//'.fits','i_naxis2')
ysize=int(imgets.value)

prow(lstdlist//'.fits',ysize/2)

print('Input Object Region (start column, end column)')
while(scan(stcol,endcol) !=2) {}
haba = endcol - stcol + 1
onedspec=mktemp('onedspec.tmp.')
blkavg(lstdlist//'.fits['//stcol//':'//endcol//',*]',onedspec,option="sum", b1=haba, b2=1, mode=mode )
imcopy(onedspec//"[1,*]", onedspec ,ver-)

standard(onedspec,'std',extinct=extfile,interac+)

sensfunc('std','std2',extinct=extfile,graphs="isr",order=10,function='chebyshev')
fluxcalib(linlist//'.fits',linlist//'.fc.fits',"std2",exposur="EXPTIME")
extinction(linlist//'.fc.fits',loutlist//'.fits',extinct=extfile)

imdel(onedspec)

bye
end

