procedure flatnorm(input,output)
file	input	{prompt="input image list"}
file	output	{prompt="output image list"}
int	axis=2	{prompt="direction to normalize"}
string	reject="pclip"	{prompt="Type of rejection for imcombine",enum="default|none|minmax|ccdclip|crreject|sigclip|avsigclip|pclip"}
int	x1=INDEF	{prompt="minimum x to calculate normalization spectrum"}
int	x2=INDEF	{prompt="maximum x to calculate normalization spectrum"}

struct *list_in
struct *list_out

begin
	string	inlist,outlist
	int	norm_axis
	int	i,xlen,ylen
	string	rejtype
	int	n_image_in,n_image_out
	string	tmp1,tmp2,tmp3,tmp4,tmp5
	string	tmplist
	string	inimg,outimg
	int	xmin,xmax
	int	imin,imax

# initialize variables
	inlist=input
	outlist=output
	norm_axis=axis
	rejtype=reject
	xmin=x1
	xmax=x2

	sections(inlist,option='nolist')
	n_image_in = sections.nimages
	sections(outlist,option='nolist')
	n_image_out = sections.nimages

	if(n_image_in != n_image_out)
	{
		print("ERROR: Number of input and output images not the same")
		clbye()
	}

	tmp1=mktemp("fn_tmp.")
	tmp2=mktemp("fn_tmp.")
	tmp3=mktemp("fn_tmp.")
	tmp4=mktemp("fn_tmp.")
	tmp5=mktemp("fn_tmp.")

	sections(inlist,option='fullname', > tmp1)
	sections(outlist,option='fullname', > tmp2)
	list_in=tmp1
	list_out=tmp2

	while( fscan(list_in,inimg)==1 && fscan(list_out,outimg)==1)
	{
		imgets(inimg,'i_naxis1')
		xlen=int(imgets.value)
		imgets(inimg,'i_naxis2')
		ylen=int(imgets.value)

		if(xmin == INDEF)
		{
			imin=1
		}
		else
		{
			imin=xmin
		}
		if(xmax == INDEF)
		{
			if(norm_axis==1)
			{
				imax=ylen
			}
			else
			{
				imax=xlen
			}
		}
		else
		{
			imax=xmax
		}

# make averaged 1D slice
		i=imin
		if(norm_axis==1)
		{
			while(i<=imax)
			{
				print(inimg//"[*,"//i//"]",>> tmp3)
				i=i+1
			}
		} else {
			while(i<=imax)
			{
				print(inimg//"["//i//",*]",>> tmp3)
				i=i+1
			}
		}

		tmplist="@"//tmp3
		imcombine(tmplist,tmp4,combine="average",reject=rejtype)
		delete(tmp3,ver-)

# generate 2D image
		i=1
		if(norm_axis==1)
		{
			while(i<=ylen)
			{
				print(tmp4,>> tmp3)
				i=i+1
			}
		} else {
			while(i<=xlen)
			{
				print(tmp4,>> tmp3)
				i=i+1
			}
		}
		tmplist="@"//tmp3
		print("imstack "//tmp4//" -> "//tmp5)
		imstack(tmplist,tmp5)

		if(norm_axis!=1)
		{
			print("imtran "//tmp5)
			imtranspose(tmp5,tmp5)
		}

# normalize
		print("imarith "//inimg//" / "//tmp5//" -> "//outimg)
		imarith(inimg,"/",tmp5,outimg)

		delete(tmp3,ver-)
		imdelete(tmp4,ver-)
		imdelete(tmp5,ver-)
	}

	delete(tmp1,ver-)
	delete(tmp2,ver-)

end
