# FOCAS distortion correction with cfitsio
procedure distcalib( input, output)
#
file	input	{prompt="input images"}
file	output	{prompt="output images"}

string	obsmode="imaging"	{prompt="spectroscopy/imaging",enum="spectroscopy|imaging"}
string	distdata="DistChipDat.HPK.101112.dat"	{prompt="distortion data file in FOCASREDHOME$DATA/"}
struct *list1
struct *list2

bool verbose=yes

begin
	string	inlist,outlist
	string	distfile,focasred_dir
	string	inimg,outimg
	string	tmp1,tmp2
	string	obs_mode
	int	n_image_in,n_image_out
	bool	verb

# initialize variables
	inlist=input
	outlist=output
	focasred_dir = osfn("FOCASREDHOME$")
	distfile = focasred_dir//"/DATA/"//distdata
	if(obsmode=="spectroscopy")
		obs_mode="-s"
	else if(obsmode=="imaging")
		obs_mode="-i"
	else
	{
		print("invalid observation mode :",obsmode)
		goto bye
	}
	verb=verbose

	sections(inlist,option='nolist')
	n_image_in = sections.nimages
	sections(outlist,option='nolist')
	n_image_out = sections.nimages

	if(n_image_in != n_image_out)
	{
		print("ERROR: Number of input and output images not the same")
		clbye()
	}

# task definition
	task	$cdistcalib = ("$"//focasred_dir//"/bin/distcalib")

# prepare for main loop
	tmp1=mktemp("dc_tmp.")
	tmp2=mktemp("dc_tmp.")
	sections(inlist,option='fullname', > tmp1)
	sections(outlist,option='fullname', > tmp2)
	list1=tmp1
	list2=tmp2

#
	while( fscan(list1,inimg)==1 && fscan(list2,outimg)==1)
	{
		print("distcalib"," ",obs_mode," ",distfile," ",inimg," ",outimg)
		if(verb==yes)
			cdistcalib(obs_mode,distfile,inimg,outimg)
		else
			cdistcalib(obs_mode,distfile,inimg,outimg,>&"dev$null")
	}

	delete(tmp1,ver-)
	delete(tmp2,ver-)

	bye
end

