PRO write_sbr_wcs,pixscale,X1,Y1,X2,Y2,xFOVCenter,yFOVCenter,width_pix,diameter_pix,type,delid,slitangle,FilenameInput=filenameinput
;
; No transformation, just scaling
;
; pixscale: arcsec/pix
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

if keyword_set(filenameinput) EQ 0 then begin
	filename=DIALOG_PICKFILE(filter='*.sbr',path=getenv("FOCASRED_FITS_IN")+'/',title="Input SBR file name")
	IF(STRLEN(filename) EQ 0) THEN return
end else begin
	filename=filenameinput
endelse


if size(delid,/n_dimension) NE 0 then begin
	x1[delid]=0; & x2[delid]=0 & y1[delid]=0 & y2[delid]=0
endif
;
; [X,Y]_distcenter must be your interest FOV center pos for previously distcalibed data
;

params=dialog_input(prompt=["X FOV Center","Y FOV Center"],nfields=2,initial=[xFOVCenter,yFOVCenter],title='Input FOV Center')
if n_elements(params) NE 2 then goto,do_nothing
xFOVcenter=float(params[0])
yFOVcenter=float(params[1])

x1_offset = x1 - xFOVCenter
x2_offset = x2 - xFOVCenter
y1_offset = y1 - yFOVCenter
y2_offset = y2 - yFOVCenter

r1 = sqrt(x1_offset^2+y1_offset^2)*0.015/beta/0.1038*pixscale
r2 = sqrt(x2_offset^2+y2_offset^2)*0.015/beta/0.1038*pixscale

; No transformation, just scaling
r1_trans = r1
r2_trans = r2

theta1 = atan(y1_offset,x1_offset)
theta2 = atan(y2_offset,x2_offset)

mos_rot_offset=mos_rot;-0.7
offset=mos_rot_offset*!PI/180; MOS theta offset in radian
x1_focus=r1_trans*cos(theta1+offset)
x2_focus=r2_trans*cos(theta2+offset)
y1_focus=r1_trans*sin(theta1+offset)
y2_focus=r2_trans*sin(theta2+offset)

;width=width_pix; width is in array
width=width_pix*cos(slitangle*!PI/180.)*0.015/beta-0.086; 0.086; laser beam width

radius=diameter_pix/2*0.015/beta/0.1038*pixscale

GET_LUN,U
on_ioerror, fopen_err
openw,U,filename

for i=0,n_elements(x1)-1 do begin; i=0 is assigned for del slit
	if x1[i] EQ 0 then goto,skip_loop
;
; FOV check
;
	r1=sqrt((x1_focus[i]^2)+(y1_focus[i])^2)
	r2=sqrt((x1_focus[i]^2)+(y2_focus[i])^2)
	r3=sqrt((x2_focus[i]^2)+(y1_focus[i])^2)
	r4=sqrt((x2_focus[i]^2)+(y2_focus[i])^2)
	if (r1 GT 90) or (r2 GT 90) or (r3 GT 90) or (r4 GT 90) then result=dialog_message(string(i)+'th slit is out of FOV.')

	; CCD gap
	ccd_xsize=2048.0
	gap_x1=ccd_xsize+0.5+(xFOVCenter-XMaskCenter)
	gap_x2=gap_x1+gapsize
	if x1[i] GT gap_x1 and x1[i] LT gap_x2 then result=dialog_message(string(i)+'th slit is on CCD gap.')
	if x2[i] GT gap_x1 and x2[i] LT gap_x2 then result=dialog_message(string(i)+'th slit is on CCD gap.')
	if x1[i] LT gap_x1 and x2[i] GT gap_x2 then result=dialog_message(string(i)+'th slit is on CCD gap.')

;	print,i,r1,r2,r3,r4,x1[i],x2[i]
;
; Write
;
	if type[i] EQ 0 then begin
;			printF, U, x1_focus[i],(y1_focus+y2_focus)[i]/2,x2_focus[i],(y1_focus+y2_focus)[i]/2,width[i],format='("B,",F9.4,",",F9.4,",",F9.4,",",F9.4,",",F9.4)'
			printF, U, x1_focus[i],y1_focus[i],x2_focus[i],y2_focus[i],width[i],format='("B,",F9.4,",",F9.4,",",F9.4,",",F9.4,",",F9.4)'
		endif else begin
			printF, U, (x1_focus[i]+x2_focus[i])/2,(y1_focus[i]+y2_focus[i])/2,(x2_focus[i]-x1_focus[i])/2,format='("C,",F9.4,",",F9.4,",",F9.4)'

	endelse
skip_loop:
ENDFOR

close,U
FREE_LUN,U

goto, done
                                                                                
fopen_err:
result=dialog_message(!error_state.msg,/Error)
                                                                                
done:

do_nothing:

;message,'FINISH'
END
