PRO write_sbr_trans,X1,Y1,X2,Y2,width_pix,diameter_pix,type,delid,FilenameInput=filenameinput

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

if keyword_set(filenameinput) EQ 0 then begin
	filename=DIALOG_PICKFILE(PATH='/home/ohyama/IDL/',filter='*.sbr')
	IF(STRLEN(filename) EQ 0) THEN return
end else begin
	filename=filenameinput
endelse

if size(delid,/n_dimension) NE 0 then begin
	x1[delid]=0; & x2[delid]=0 & y1[delid]=0 & y2[delid]=0
endif

;
; Ohyama transform
;
;read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

; beta=beta/0.997*0.998; beta should be enlarged. This value is based on our experience.
; Use modified DistChipDat file containing new beta info.

x1_offset = x1 - XDistCenter
x2_offset = x2 - XDistCenter
y1_offset = y1 - YDistCenter
y2_offset = y2 - YDistCenter

r1 = sqrt(x1_offset^2+y1_offset^2)*0.015/beta
r2 = sqrt(x2_offset^2+y2_offset^2)*0.015/beta

r1_trans = r1*(coef[0] + coef[1]*r1 + coef[2]*r1^2 + coef[3]*r1^3)
r2_trans = r2*(coef[0] + coef[1]*r2 + coef[2]*r2^2 + coef[3]*r2^3)

theta1 = atan(y1_offset,x1_offset)
theta2 = atan(y2_offset,x2_offset)

mos_rot_offset=mos_rot;-0.7
offset=mos_rot_offset*3.141592/180; MOS theta offset in radian
x1_focus=r1_trans*cos(theta1+offset)
x2_focus=r2_trans*cos(theta2+offset)
y1_focus=r1_trans*sin(theta1+offset)
y2_focus=r2_trans*sin(theta2+offset)

;width=width_pix; width is in array
width=width_pix*0.015/beta-0.086; 0.086; laser beam width
radius=diameter_pix/2*0.015/beta

GET_LUN,U
on_ioerror, fopen_err
openw,U,filename

for i=0,n_elements(x1)-1 do begin; i=0 is assigned for del slit
	if x1[i] EQ 0 then goto,skip_loop
	if type[i] EQ 0 then begin
		printF, U, x1_focus[i],(y2_focus+y1_focus)[i]/2,x2_focus[i],(y1_focus+y2_focus)[i]/2,width[i],format='("B,",F9.4,",",F9.4,",",F9.4,",",F9.4,",",F9.4)'
	endif	else begin
		printF, U, (x1_focus[i]+x2_focus[i])/2,(y1_focus[i]+y2_focus[i])/2,(x2_focus[i]-x1_focus[i])/2,format='("C,",F9.4,",",F9.4,",",F9.4)'
	endelse
skip_loop:
ENDFOR

close,U
FREE_LUN,U

goto, done
                                                                                
fopen_err:
result=dialog_message(!error_state.msg,/Error)
                                                                                
done:

;message,'FINISH'
END
