PRO write_sbr_moircs,pixscale,X1,Y1,X2,Y2,xFOVCenter,yFOVCenter,width_pix,diameter_pix,type,delid,slitangle,FilenameInput=filenameinput
; pixscale: arcsec/pix

beta=0.29898169 ; FOCAS default magnification

if keyword_set(filenameinput) EQ 0 then begin
	dir=getenv("FOCASRED_FITS_IN")+'/'
	if dir EQ '/' then dir=getenv('PWD')+'/'
	filename=DIALOG_PICKFILE(filter='*.sbr',path=dir,title="Input SBR file name")
	IF(STRLEN(filename) EQ 0) THEN return
end else begin
	filename=filenameinput
endelse


if size(delid,/n_dimension) NE 0 then begin
	x1[delid]=0; & x2[delid]=0 & y1[delid]=0 & y2[delid]=0
endif

params=dialog_input(prompt=["X FOV Center","Y FOV Center"],nfields=2,initial=[xFOVCenter,yFOVCenter],title='Input FOV Center')
if n_elements(params) NE 2 then goto,do_nothing
xFOVcenter=float(params[0])
yFOVcenter=float(params[1])

x1_offset = x1 - xFOVCenter
x2_offset = x2 - xFOVCenter
y1_offset = y1 - yFOVCenter
y2_offset = y2 - yFOVCenter
;
x1_focus=-x1_offset*0.015/beta/0.1038*pixscale
x2_focus=-x2_offset*0.015/beta/0.1038*pixscale
y1_focus=y1_offset*0.015/beta/0.1038*pixscale
y2_focus=y2_offset*0.015/beta/0.1038*pixscale
;
x1_laser=x1_focus*1.006
x2_laser=x2_focus*1.006
y1_laser=y1_focus*1.006
y2_laser=y2_focus*1.006

;width=width_pix; width is in array
width=(width_pix*pixscale/2.06218*1.006)*1.08826 - 0.126902

radius=diameter_pix/2*0.015/beta/0.1038*pixscale

GET_LUN,U
on_ioerror, fopen_err
openw,U,filename

for i=0,n_elements(x1)-1 do begin; i=0 is assigned for del slit
	if x1[i] EQ 0 then goto,skip_loop
;
; FOV check
;
	; laser cutter (<180")
	r1=sqrt((x1_focus[i]^2)+(y1_focus[i])^2)
	r2=sqrt((x1_focus[i]^2)+(y2_focus[i])^2)
	r3=sqrt((x2_focus[i]^2)+(y1_focus[i])^2)
	r4=sqrt((x2_focus[i]^2)+(y2_focus[i])^2)
	if (r1 GT 90) or (r2 GT 90) or (r3 GT 90) or (r4 GT 90) then result=dialog_message(string(i)+'th slit is out of FOV.')
	; MOIRCS (|x|<120")
	if (abs(x1_focus[i]) GT 60) or (abs(x2_focus[i]) GT 60) then result=dialog_message(string(i)+'th slit is out of FOV.')

;
; Write
;
	if type[i] EQ 0 then begin
		printF,U,x1_laser[i],y1_laser[i],x2_laser[i],y2_laser[i],width[i],format='("B,",F9.4,",",F9.4,",",F9.4,",",F9.4,",",F9.4)'
	endif else begin
		printF,U,(x1_laser[i]+x2_laser[i])/2,(y1_laser[i]+y2_laser[i])/2,abs((x2_laser[i]-x1_laser[i])/2),format='("C,",F9.4,",",F9.4,",",F9.4)'
	endelse
skip_loop:
ENDFOR

close,U
FREE_LUN,U

goto, done
                                                                                
fopen_err:
result=dialog_message(!error_state.msg,/Error)
                                                                                
done:

do_nothing:

END
