PRO write_aext,X1,Y1,X2,Y2,type,object,delid,header,FilenameInput=filenameinput

;if checkfocana() then outdir='~' else outdir='/work/o99004/'
outdir=getenv("FOCASRED_DATA_OUT")+'/'
if outdir EQ '/' then outdir='./'

;if keyword_set(filenameinput) EQ 0 then begin
filename=DIALOG_PICKFILE(PATH=outdir,filter='*.dat',title='BarcodeID.dat')
IF(STRLEN(filename) EQ 0) THEN return

bin= SXPAR( header,'BIN-FCT*')
n_array=n_elements(x1)

read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

if size(delid,/n_dimension) NE 0 then begin
	x1[delid]=0; & x2[delid]=0 & y1[delid]=0 & y2[delid]=0
endif

xdim=2047/bin[0]

x_cen2=(x1+x2)/2; pixel in chip 2
y_cen2=(y1+y2)/2; pixel in chip 2
x1_1=x1-xdim-gapsize; pixel in chip 1
x2_1=x2-xdim-gapsize; pixel in chip 1
y1_1=y1+Y_shift
y2_1=y2+Y_shift

x_cen=(x1_1+x2_1)/2; pixel in chip 1
y_cen=(y1_1+y2_1)/2; pixel in chip 1

xyad,header,x_cen,y_cen,alpha,delta; xy to RA-DEC (degree)
ra_dec_string=adstring(alpha,delta,2)
alpha_s=strmid(ra_dec_string,0,13)
delta_s=strmid(ra_dec_string,14,13)
alpha_ss=alpha_s & delta_ss=delta_s

for i=0,n_array-1 do begin
	alpha_ss[i]=strjoin(strsplit(alpha_s[i],' ',/extract),':')
	delta_ss[i]=strjoin(strsplit(delta_s[i],' ',/extract),':')
endfor

length=(x2-x1)*0.1; arcsec
width=(y2-y1)*0.1; arcsec
PA=fltarr(n_array); degree
SLT_OPEN=strarr(n_array)
SLT_OPEN[*]='T'
SLT_SHP=strarr(n_array)
SLT_SHP[*]='RECTANGLE'

for i=0,n_array-1 do begin
	if type[i] EQ 1 then begin
		SLT_SHP[i]='ELLIPSE'
		width[*]=(y2-y1)/2*0.1; arcsec
		length[*]=(x2-x1)/2*0.1; arcsec
	endif
ENDFOR

GET_LUN,U
openw,U,filename

printf,U,"# Format: Slit_ID C1_X(pixel) C1_Y(pixel) C2_X(pixel) C2_Y(pixel) Alpha(hh:mm:ss.sss) Delta(+/-dd:mm:ss.ss) Width(arcsec) Length(arcsec) PA(degree) Slit_Shape Slit_Open Objects"
for i=0,n_array-1 do if x1[i] NE 0 then printf,U, i, x_cen[i],y_cen[i],x_cen2[i],y_cen2[i],alpha_ss[i],delta_ss[i],width[i],length[i],pa[i],SLT_SHP[i],SLT_OPEN[i],object[i],format='(I4, 4F9.2, 2A14, 3F6.3, A10, A2, A30)'

close,U
FREE_LUN,U

;message,'FINISH'
END
