;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO display_slit_id,x1,x2,y1,y2,goodid
COMMON common_info,samplefac,bin,grism_info

	xyouts,(x2/samplefac/bin[0])[goodid],(y1/samplefac/bin[1])[goodid],(strtrim(string(indgen(n_elements(x1))),2))[goodid],/device,charsize=1.5
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,$
	xoffset,yoffset,slitangle
COMMON common_info,samplefac,bin,grism_info

	length=(x2-x1)/bin[0]/samplefac/cos(slitangle*!PI/180.)

        ;; add -1 on 3/1/2006
	xcen=((x1+x2)/2-xoffset)/bin[0]/samplefac-1
	;dx>0 when the direction is chip1->chip2
	xcen2=((x1+x2)/2-xoffset-grism_info.dx)/bin[0]/samplefac-1
	ycen=((y1+y2)/2-yoffset)/bin[1]/samplefac-1; slit Y center
	; dispersion=-dl/dy (follows the table in FOCAS HP)
	ycen2=ycen+grism_info.waveoffset-1;
	ycen3=((ycen*SAMPLEFAC*bin[1]-2000)+grism_info.zero_offset)/bin[1]/samplefac-1; zero-oder Y center
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,$
	xoffset,yoffset,slitangle,win,printout=printout,forminfo=forminfo
COMMON common_info,samplefac,bin,grism_info
COMMON share3,red,blue,green

	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xoffset,yoffset,slitangle
	if N_elements(printout) EQ 0 then wset,win
	width_zero=width[goodid]/2
	width_zero_default=2.5
	width_zero=width_zero_default/bin[1]/samplefac
	;;set the constant slit width in dispersion direction for tilted slits.
	width_tilt=width*cos(slitangle*!PI/180.)
	if N_elements(forminfo) EQ 0 then BEGIN	
		tvbox3,length[goodid]/2,width_tilt[goodid]/2,xcen[goodid],ycen[goodid],angle=slitangle[goodid]
		tvbox3,length[goodid]/2*cos(slitangle*!PI/180.),grism_info.wavecoverage/2,xcen2[goodid],ycen2[goodid],red
		tvbox3,length[goodid]/2,width_zero[goodid],xcen2[goodid],ycen3[goodid],red,angle=slitangle[goodid]
	ENDIF ELSE BEGIN; for printing only
		tvbox3,length[goodid]/2,width_tilt[goodid]/2,xcen[goodid],ycen[goodid],color,_extra=forminfo
		tvbox3,length[goodid]/2,grism_info.wavecoverage/2,xcen2[goodid],ycen2[goodid],color,_extra=forminfo
		tvbox3,length[goodid]/2,width_zero[goodid],xcen2[goodid],ycen3[goodid],color
	ENDELSE
END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO draw_slit_id,length,width,xcen,ycen,id
	R=256 & G=128 & B=128 & color=R+(G+256L)*(B+256L)
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO draw_fov,xFOVcen,yFOVcen,r,r2,naxiS
COMMON common_info,samplefac,bin,grism_info
COMMON focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter,$
	XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,$
	YRotatorCenter,mos_rot,coef,coef_inv,overscan
COMMON share3,red,blue,green
COMMON badcolumnlist,xbad1,xbad2,ybad1,ybad2
COMMON x_dim,y_dim

	x_dim=4096
	y_dim=4096

	draw_ellipse,xFOVcen/samplefac,yFOVcen/samplefac,r/samplefac,r/samplefac,resolution=100,/device
	draw_ellipse,xFOVcen/samplefac,yFOVcen/samplefac,r2/samplefac,r2/samplefac,resolution=100,/device
; CCD Gap
;	tvbox3,gapsize/samplefac/2,y_dim/samplefac/2,(xFOVcen+1+gapsize/2)/samplefac,y_dim/2/samplefac; was XMaskCenter
;	tvbox3,gapsize/samplefac/2,y_dim/samplefac/2,(xFOVcen+1+gapsize/2)/samplefac,yFOVCen/samplefac,COLOR=blue
;	tvbox3,gapsize/samplefac/2,y_dim/samplefac/2,(xFOVcen+1)/samplefac,yFOVCen/samplefac,COLOR=green
;  x=[1990:2040] in the distortion corrected 1x1 image
	tvbox3,gapsize/samplefac/2,y_dim/samplefac/2,(2015+xFOVcen-xMASKCenter+1)/samplefac,yFOVCen/samplefac,COLOR=blue,thick=2
; CCD BadColumns
	tvbox3,(xbad2-xbad1+1)/samplefac/2,(ybad2-ybad1+1)/samplefac/2,((xFOVcen-XMaskCenter)+(xbad1+xbad2)/2)/samplefac,((yFOVcen-yMASKCenter)+(ybad1+ybad2)/2)/samplefac,COLOR=green
; CCD region

	x1_chip=xFOVcen-XMaskCenter; > 0
	x2_chip=(x_dim-XMaskCenter)+xFOVcen; < (x_dim-1)
	y1_chip=yFOVcen-YMaskCenter; > 0
	y2_chip=(y_dim-YMaskCenter)+YFOVCen; < (y_dim-1)
	tvbox3,x_dim/samplefac/2,y_dim/samplefac/2,(x1_chip+x2_chip)/2/samplefac,(y1_chip+y2_chip)/2/samplefac
END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO get_nearest_slit,xcen,ycen,id,win

	wset,win
	click=fltarr(2)
	CURSOR,tmp_x,tmp_y,/device
	click[0]=tmp_x & click[1]=tmp_y
	r=sqrt((xcen-click[0])^2+(ycen-click[1])^2)
	id=where(r EQ min(r))
	if n_elements(id) NE 1 then id=id[0]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO make_id,delid,goodid,x1

	if n_elements(x1) EQ 0 then result=dialog_message(['You can not remove this slit/hole.','Number of slits/holes should be 1 or more.'],/Error)
	goodid=indgen(n_elements(x1))
	if (size(delid,/n_dimensions) NE 0) then remove,delid,goodid
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO add_delid,delid,id

	if size(delid,/n_dimensions) EQ 0 then delid=[id] else delid=[delid,id]
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO pro_overlap,j,i,length,width,xcen,ycen,priority,delid,slitangle
COMMON share3,red,blue,green

	print,'Overlap',j, i
	R=256 & G=256 & B=0 & color=R+(G+256L)*(B+256L)
	tvbox3,length[j]/2,width[j]/2*cos(slitangle[j]*!PI/180.),xcen[j],ycen[j],angle=slitangle[j]
	tvbox3,length[i]/2,width[i]/2*cos(slitangle[i]*!PI/180.),xcen[i],ycen[i],angle=slitangle[i]

	if priority[j] LT priority[i] then begin
		add_delid,delid,i
		dummy=dialog_message('Slits '+strtrim(string(i),2)+' and '+strtrim(string(j),2)+' are overlapping. Slit '+strtrim(string(i),2)+' was removed according to the priority.',/information)
		print,'Deleted ',i
	end
	if priority[i] LT priority[j] then begin
		add_delid,delid,j
		dummy=dialog_message('Slits '+strtrim(string(i),2)+' and '+strtrim(string(j),2)+' are overlapping. Slit '+strtrim(string(j),2)+' was removed according to the priority.',/information)
		print,'Deleted ',j
	end
	if priority[i] EQ priority[j] then begin
		dummy=dialog_message('Slits '+strtrim(string(i),2)+' and '+strtrim(string(j),2)+' are overlapping. No slits were removed due to same priorities.',/information)
	end
	
END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO set_params,pickupbox_size,holediameter,slit_space,xoffset,yoffset,num,$
	yohaku,width_text,aperture_text,length_text
COMMON common_info,samplefac,bin,grism_info

;	params=dialog_input(prompt=	["Pickup Box Size","Alignment Hole Size (diameter) (arcsec)",'Space between slits (in Pix: for Autoexpanding slits)','Xoffset','Yoffset','Yohaku','Default Slit Length (arcsec)','Default Slit Width (arcsec)'],$
	params=dialog_input(prompt=	["DO NOT CHANGE","Aperture Size (diameter) (arcsec)",'# of pixels between slits in autoexpanding slit width','DO NOT CHANGE','DO NOT CHANGE','DO NOT CHANGE','Default Slit Length (arcsec)','Default Slit Width (arcsec)'],$
		nfields=8,$
				initial=[pickupbox_size,holediameter*samplefac*bin[1]/10.,slit_space,xoffset,yoffset,yohaku,grism_info.length_default*samplefac*bin[0]/10.,grism_info.width_default*samplefac*bin[1]/10.],$
		title='Parameter Setting',dialog_parent=base)
	IF(n_elements(params) NE 8) THEN return
	pickupbox_size=fix(params[0])
	holediameter=float(params[1])/float(samplefac)/float(bin[1])*10.
	slit_space=float(params[2])
	xoffset=float(params[3])
	yoffset=float(params[4])
	yohaku=fix(params[5])
	grism_info.length_default=float(params[6])/float(samplefac)/float(bin[0])*10.
	grism_info.width_default=float(params[7])/float(samplefac)/float(bin[1])*10.
;	window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2,title='Pickup Box'

	widget_control,width_text,set_value='Slit W: '+strtrim(string(grism_info.width_default*samplefac*bin[1]/10.),2)+'(arcsec)'
	widget_control,length_text,set_value='Slit L: '+strtrim(string(grism_info.length_default*samplefac*bin[0]/10.),2)+'(arcsec)'
	widget_control,aperture_text,set_value='Hole D: '+strtrim(string(holediameter*samplefac*bin[1]/10.),2)+'(arcsec)'

END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO set_grism,base,grismselect
COMMON common_info,samplefac,bin,grism_info

	params=dialog_menu(['75-Y47','150-Y47','300B-L600','300B-Y47',$
		'300B-O58','300R-Y47','300R-O58','300R-L600','300R-I',$
		'Echelle-I','Echelle-z','VPH450','VPH520','VPH650','VPH680',$
		'VPH800','VPH950-O58',$
		'cancel'],$
		title='Grism Selection',dialog_parent=base,XPOSITION=500,$
		YPOSITION=1000)
	IF(n_elements(params) EQ 0) THEN return

	CASE params OF

	'75-Y47': begin
	grism_info.directwave=6483; was 6500
	grism_info.wavestart=4700;
	grism_info.waveend=9500;
	grism_info.dispersion=11.8/2; was 5.46
	widget_control,grismselect,set_value='Grism: 75'
	grism_info.zero_offset=4000-1000
	grism_info.dx=0.0
	END

	'150-Y47': begin
	grism_info.directwave=6768; was 6500
	grism_info.wavestart=4700;
	grism_info.waveend=9500;
	grism_info.dispersion=5.67/2; was 2.72
	widget_control,grismselect,set_value='Grism: 150'
	grism_info.zero_offset=4000+120
	grism_info.dx=0.0
	END

	'300B-Y47': begin
	grism_info.directwave=5540; was 5500
	grism_info.wavestart=4700;
	grism_info.waveend=9500;
	grism_info.dispersion=2.79/2; was 1.34
	widget_control,grismselect,set_value='Grism: 300B'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END	

	'300B-O58': begin
	grism_info.directwave=5540; was 5500
	grism_info.wavestart=5800;
	grism_info.waveend=10000;
	grism_info.dispersion=2.79/2; was 1.34
	widget_control,grismselect,set_value='Grism: 300B'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END	

	'300R-Y47': begin
	grism_info.directwave=7550; was 7500
	grism_info.wavestart=4700
	grism_info.waveend=9500	
	grism_info.dispersion=2.68/2; was 1.34
	widget_control,grismselect,set_value='Grism: 300R-Y47'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END

        '300B-L600': begin
        grism_info.directwave=5540; was 5500
        grism_info.wavestart=3500
	grism_info.waveend=6000
	grism_info.dispersion=2.79/2; was 1.34
        widget_control,grismselect,set_value='Grism: 300B+L600'
        grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
        END

	'300R-O58': begin
	grism_info.directwave=7550; was 7500
	grism_info.wavestart=5800
	grism_info.waveend=10000
	grism_info.dispersion=2.68/2; was 1.34
	widget_control,grismselect,set_value='Grism: 300R-O58'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END

	'300R-L600': begin
	grism_info.directwave=3900;
	grism_info.wavestart=3650
	grism_info.waveend=6000
	grism_info.dispersion=0.67;
	widget_control,grismselect,set_value='Grism: 300R-L600'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END

	'300R-I': begin
	grism_info.directwave=7550; was 7500
	grism_info.wavestart=7320
	grism_info.waveend=8780
	grism_info.dispersion=2.68/2; was 1.34
	widget_control,grismselect,set_value='Grism: 300R-I'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END

	'Echelle-I': begin
	grism_info.directwave=9720; was 7500
	grism_info.wavestart=7320
	grism_info.waveend=8780
	grism_info.dispersion=-0.92; dispersion is negative for Echelle
	widget_control,grismselect,set_value='Grism: Echelle+I'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END

	'Echelle-z': begin
	grism_info.directwave=9720; was 7500
	grism_info.wavestart=8300
	grism_info.waveend=10000
	grism_info.dispersion=-0.92; dispersion is negative for Echelle
	widget_control,grismselect,set_value='Grism: Echelle+z'
	grism_info.zero_offset=4000+4000
	grism_info.dx=0.0
	END

	'VPH650': begin
	grism_info.directwave=6500
	grism_info.wavestart=5300
	grism_info.waveend=8350
	grism_info.dispersion=0.61
	widget_control,grismselect,set_value='Grism: VPH650-Y47'
	grism_info.zero_offset=4000+4000
	grism_info.dx=222.0
	END

	'VPH450': begin
	grism_info.directwave=4500
	grism_info.wavestart=3800
	grism_info.waveend=5650
	grism_info.dispersion=0.376
	widget_control,grismselect,set_value='Grism: VPH450'
	grism_info.zero_offset=4000+4000
	grism_info.dx=16.0
	END

	'VPH950-O58': begin
	grism_info.directwave=9500
	grism_info.wavestart=5800
	grism_info.waveend=10500
	grism_info.dispersion=0.352
	widget_control,grismselect,set_value='Grism: VPH950'
	grism_info.zero_offset=4000+4000
	grism_info.dx=-190
	END

	'VPH520': begin
	grism_info.directwave=5250
	grism_info.wavestart=4450
	grism_info.waveend=6050
	grism_info.dispersion=0.394
	widget_control,grismselect,set_value='Grism: VPH520'
	grism_info.zero_offset=4000+4000
	grism_info.dx=-47
	END

	'VPH680': begin
	grism_info.directwave=6900
	grism_info.wavestart=6450
	grism_info.waveend=7350
	grism_info.dispersion=0.223
	widget_control,grismselect,set_value='Grism: VPH680'
	grism_info.zero_offset=4000+4000
	grism_info.dx=+41
	END

	'VPH800': begin
	grism_info.directwave=8000
	grism_info.wavestart=7500
	grism_info.waveend=8600
	grism_info.dispersion=0.282
	widget_control,grismselect,set_value='Grism: VPH800'
	grism_info.zero_offset=4000+4000
	grism_info.dx=-27
	END

	'cancel':

	ENDCASE
	grism_info.wavecoverage=(grism_info.waveend-grism_info.wavestart)/grism_info.dispersion/bin[1]/samplefac
	grism_info.waveoffset=(grism_info.directwave-(grism_info.waveend+grism_info.wavestart)/2)/grism_info.dispersion/bin[1]/samplefac
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO set_grism_pars
COMMON common_info,samplefac,bin,grism_info

	params=dialog_input(prompt=['straight-through wavelength',$
		'minimum wavelength (A)','maximum wavelength (A)',$
		'dispersion (A/pix)','displacement along X-axis',$
		'zeroth order offset'],nfields=6,$
		initial=[grism_info.directwave,grism_info.wavestart,$
		grism_info.waveend,grism_info.dispersion,$
		grism_info.dx,grism_info.zero_offset],$
		title='Grism Parameter Setting',dialog_parent=base)

	IF(n_elements(params) NE 6) THEN return
	grism_info.directwave=float(params[0])
	grism_info.wavestart=float(params[1])
	grism_info.waveend=float(params[2])
	grism_info.dispersion=float(params[3])
	grism_info.dx=float(params[4])
	grism_info.zero_offset=float(params[5])

	grism_info.wavecoverage=(grism_info.waveend-grism_info.wavestart)/grism_info.dispersion/bin[1]/samplefac
	grism_info.waveoffset=(grism_info.directwave-(grism_info.waveend+grism_info.wavestart)/2)/grism_info.dispersion/bin[1]/samplefac
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO input_mdp,x1,y1,x2,y2,length,width,slitangle,priority,object,naxis,type,dir;
COMMON common_info,samplefac,bin,grism_info

	read_mdp2,x1,y1,x2,y2,length,width,slitangle,priority,object,naxis,type,dir=dir
	width[*]=width[*]/bin[1]/samplefac; width in reduced coordinage
	slitonly=where(type NE 1)
	grism_info.width_default=min(width[slitonly])
	length[*]=length[*]/bin[0]/samplefac
	grism_info.length_default=min(length[slitonly])
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO input_mdp_radec,wcsinfo,x1,y1,x2,y2,length,width,priority,object,naxis,$
	type,dir;
COMMON common_info,samplefac,bin,grism_info

	read_mdp_radec,wcsinfo,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir=dir
	width[*]=width[*]/bin[1]/samplefac
	grism_info.width_default=width[0]
	length[*]=length[*]/bin[0]/samplefac
	grism_info.length_default=length[0]
END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO readfits,image,image2,objectname,naxis,bin,exptime,header,samplefac,wcsinfo,pixscale,path

	fitsdir=getenv("FOCASRED_FITS_IN")+'/'
	if fitsdir EQ '/' then fitsdir=getenv('PWD')
	read_fits,image,header,dir=fitsdir,myfilter='*fits',mytitle='Input BigImage',MYGETPATH=path
	if n_elements(header) EQ 0 then goto,END_READFITS
	bin=SXPAR(header,'BIN-FCT*')
		if n_elements(bin) EQ 1 then bin=[1,1]; in case of header from other instruments
	objectname=SXPAR(header,'OBJECT')
	exptime=SXPAR(header,'EXPTIME')
	naxis=SXPAR(header,'NAXIS*')
	samplefac=get_samplefac(naxis[1])
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2
	extast,header,wcsinfo,nparms
	print, wcsinfo

;	IF (wcsinfo.cd[0,1] EQ 0) or (wcsinfo.cd[1,0] EQ 0) then begin
	IF (nparms EQ -1) then begin
		wcsinfo.cd[0,0]=0.
		wcsinfo.cd[1,1]=0.
		wcsinfo.cd[0,1]=0.1038/3600.
		wcsinfo.cd[1,0]=-0.1038/3600.
	ENDIF

	pixscale=(sqrt((wcsinfo.cd[0,0]^2)+(wcsinfo.cd[0,1]^2))+sqrt((wcsinfo.cd[1,0]^2)+(wcsinfo.cd[1,1]^2)))/2.0*3600.0;

	IF(pixscale LT 0.1048 and pixscale GT 0.1028) THEN BEGIN
		dummy=dialog_message([["pixel scale is set to the default value of 0.1038 arcsec/pixel"],$
		["(it was"+string(pixscale,/print)+" arcsec/pixel according to the WCS information)"]],$
		/information)
		pixscale=0.1038
	ENDIF ELSE BEGIN
		dummy=dialog_message([["!!! WARNING !!!"],$
		["unexpectedly small/large pixel scale : "+string(pixscale)]])
	ENDELSE

END_READFITS:
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO create_gui,xsize,ysize,holediameter,win,win2
COMMON widgetcom, base,pickobject,clickpoint,width_text,length_text,$
	aperture_text,grismselect,curpos_label,draw_fov_button
COMMON common_info, samplefac,bin,grism_info

base = WIDGET_BASE (mbar=bar,TITLE = 'MDP', /row, MAP = 0)
base2 = WIDGET_BASE(base,/column,map=0,group_leader=base,/scroll,x_scroll_size=210)
;base3 = WIDGET_BASE(base,/column,map=0,group_leader=base,/frame)
;grismbase = WIDGET_BASE(base2,/column,map=0,group_leader=base,/exclusive,/frame)
drawoptionbase = WIDGET_BASE(base2,/column,map=0,group_leader=base,/nonexclusive,/frame)
pickupmodebase = WIDGET_BASE(base2,/column,map=0,group_leader=base,/exclusive,/frame)

menu1=widget_button(bar, value='File',/menu)
button0=widget_button(menu1,value='Read FITS Image')
button1=widget_button(menu1,value='Read MDP file')
button2=widget_button(menu1,value='Save SBR')
;button3=widget_button(menu1,value='Save SBR (For Distortion UN-Corrected Image)')
button4=widget_button(menu1,value='Save SBR (CCD)')
;button5=widget_button(menu1,value='Save Ascii Extension')
button6=widget_button(menu1,value='Save MDP')
button7=widget_button(menu1,value='Quit')

menu2=widget_button(bar, value='Option',/menu)
button0=widget_button(menu2,value='Grism Select')
button1=widget_button(menu2,value='Grism Setting ...')
button2=widget_button(menu2,value='Change Default Slit Params')
button3=widget_button(menu2,value='Automatic Slit Width Expansion')
button4=widget_button(menu2,value='Preferences')

menu3=widget_button(bar, value='WCS',/menu)
;button1=widget_button(menu3,value='Mark RA DEC')
;button1=widget_button(menu3,value='Mark RA DEC List')
button1=widget_button(menu3,value='FOV Center (RA DEC)')
button1=widget_button(menu3,value='Show WCS Info')
;button1=widget_button(menu3,value='Read MDP (RAD-EC) file')

;menu5=widget_button(bar, value='Print',/menu)
;button1=widget_button(menu5,value='Print')

winSave = !D.WINDOW
;w1 = WIDGET_DRAW (base, XSIZE = FIX((xend-0)/samplefac), YSIZE = FIX((yend-0)/samplefac), /FRAME,/button_events,/motion_event)
w1 = WIDGET_DRAW (base, XSIZE = FIX(xsize/samplefac), YSIZE = FIX(ysize/samplefac), /FRAME,/button_events,/motion_event)
w2 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200, /FRAME); was 200; was base2

button1 = widget_button(base2, VALUE = 'Redraw',/frame)
button4 = widget_button(base2, VALUE = 'Draw Slit',/frame)
button2 = widget_label(base2,value='')
button2 = widget_button(base2, VALUE = 'Auto Intensity Scale',/frame)
button3 = widget_button(base2, VALUE = 'Change Intensity Scale',/frame)
button2 = widget_label(base2,value='')
button6 = widget_button(base2, VALUE = 'Show Nearest Slit',/frame)
button7 = widget_button(base2, VALUE = 'Show Slit(ID)',/frame)
button2 = widget_label(base2,value='')
button7 = widget_button(base2, VALUE = 'Add Slit by Click',/frame)
button7 = widget_button(base2, VALUE = 'Add Alignment Hole',/frame)
button7 = widget_button(base2, VALUE = 'Del Nearest Slit',/frame)
button2 = widget_label(base2,value='')
button7 = widget_button(base2, VALUE = 'Change Slit Params',/frame)
button7 = widget_button(base2, VALUE = 'Slit Overlap Check',/frame)
button7 = widget_button(base2, VALUE = 'Show Slit List',/frame)
;button2 = widget_label(base2,value='Slit (arcsec)')

label = widget_label(base2,value='Default Params.')
width_text = widget_label(base2,value=   'Slit W: ########## (arcs)')
length_text= widget_label(base2,value=   'Slit L: ########## (arcs)')
aperture_text = widget_label(base2,value='Hole D: ########## (arcs)')
grismselect = widget_label(base2,value=  'Grism : ##########       ')
curpos_label = widget_label(base2,value='('+strtrim(string(4000),2)+', '+strtrim(string(4000),2)+')')

pickobject=widget_button(pickupmodebase,value='Pickup Object')
clickpoint=widget_button(pickupmodebase,value='Click Point')
widget_control,pickobject,set_button=1

display_slit_id_button=widget_button(drawoptionbase,value='Display Slit ID')
widget_control,display_slit_id_button,set_button=1
draw_fov_button=widget_button(drawoptionbase,value='Draw FOV')
widget_control,draw_fov_button,set_button=1

; Map to screen
WIDGET_CONTROL, base, /REALIZE,/UPDATE
WIDGET_CONTROL, w1, GET_VALUE = win
WIDGET_CONTROL, w2, GET_VALUE = win2
WIDGET_CONTROL, base, /REALIZE,/UPDATE

; Place the dialog: window manager dependent

;   CURRENT_SCREEN = GET_SCREEN_SIZE()
;   WIDGET_CONTROL, base, TLB_GET_SIZE = DIALOG_SIZE

;   DIALOG_PT = [(CURRENT_SCREEN[0] / 2.0) - (DIALOG_SIZE[0] / 2.0), $ 
;                (CURRENT_SCREEN[1] / 2.0) - (DIALOG_SIZE[1] / 2.0)] 

   WIDGET_CONTROL, base, MAP = 1
   WIDGET_CONTROL, base2, MAP = 1
   WIDGET_CONTROL, drawoptionbase, MAP = 1
   WIDGET_CONTROL, pickupmodebase, MAP = 1

END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; MAIN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO wmdp4
COMMON common_info, samplefac,bin,grism_info
COMMON share3, red,blue,green
COMMON widgetcom, base,pickobject,clickpoint,width_text,length_text,$
	aperture_text,grismselect,curpos_label,draw_fov_button

;structure
grism_info=CREATE_STRUCT('name','','directwave',0.0,'wavestart',0.0,'waveend',$
	0.0,'dispersion',0.0,'waveoffset',0.0,'zero_offset',8000.0,'dx',0.0,$
	'wavecoverage',0.0,'length_default',0.0,'width_default',0.0)

;red=255L
;green=65535L
;blue=16711679L
red='0000FF'x
green='00FF00'x
blue='FF0000'x

set_plot,'X'

;;;;;;;;;;;;;;;;;;;;;;;;
; Creating Dummy Image ;
;;;;;;;;;;;;;;;;;;;;;;;;

bin=[1,1]
objectname='Dummy';SXPAR(header,'OBJECT')
exptime=60;exptime=SXPAR(header,'EXPTIME')
naxis=[4029,4095]; naxis=SXPAR(header,'NAXIS*')
samplefac=get_samplefac(naxis[1])

maxx=naxis[0] & maxy=naxis[1]
xoffset=0 & xend=maxx & yoffset=0 & yend=maxy

image = make_array( dimen = naxis, /FLOAT )
expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2

;
; Read Dummy Header Information
;
wcsinfo=create_struct("cd",[[0.,-0.1038/3600.],[0.1038/3600.,0.]],$
        "cdelt",[1.,1.],"crpix",[1d,1d],"crval",[0d,0d],$
        "ctype",["RA---TAN","DEC--TAN"],"LONGPOLE",180.000,$
        "LATPOLE",0.,"PV2",[0.,1.])
pixscale=0.1038

;
; setting of slit parameters
;

grism_info.length_default=100
grism_info.width_default=8


;;;;;;;;;;;;;;;;
; GUI Building ;
;;;;;;;;;;;;;;;;

create_gui,xend,yend,holediameter,win,win2

;
; Paramter Initialize
;

num=1; Dummy

delid=-1
goodid=indgen(num)

color_table=0

slit_space=0
pickupbox_size=100
yohaku=5
holediameter=20./bin[1]/samplefac; default 2 arcsec in diameter

COMMON focaspars, Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter,$
	XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,$
	YRotatorCenter,mos_rot,coef,coef_inv,overscan

read_focaspar, Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter,$
	XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,$
	YRotatorCenter,mos_rot,coef,coef_inv,overscan

COMMON badcolumnlist,xbad1,xbad2,ybad1,ybad2

read_ccdpar, xbad1,xbad2,ybad1,ybad2
r=3.*60./pixscale; 3 arcmin FOV in pix (default for FOCAS)
r2=r;90/(0.015/beta)

xFOVcen=XMaskCenter; XRotatorCenter
yFOVcen=YMaskCenter; YRotatorCenter

pSave = !P
xSave = !X
ySave = !Y

wset,win
range=[0,100]

;
; FLAGS
;
flag_draw_fov=1
flag_display_slit_id=1
flag_pickupmode=1
flag_readmdp=0
flag_grismselect=0

;
; Get the event, without using XMANAGER
;
NEXT:

;win=win0 & win2=win02
event = WIDGET_EVENT (base)
WIDGET_CONTROL, event.id, GET_VALUE = value

;
; Mouse (X, Y), Zoom around clicked pos.
;
IF tag_names(event,/structure_name) EQ 'WIDGET_DRAW' then begin
	widget_control,curpos_label,set_value='('+strtrim(string(event.x*samplefac),2)+', '+strtrim(string(event.y*samplefac),2)+')'
	if event.press EQ 1 then begin
		wset,win2
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,event.x*samplefac-pickupbox_size,event.y*samplefac-pickupbox_size,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		print,event.x,event.y
;		print,event.x*samplefac*bin[0]-pickupbox_size+xoffset,event.y*samplefac*bin[1]-pickupbox_size+yoffset

		samplefac_old=samplefac
		samplefac=1

		IF (flag_readmdp NE 0 and flag_grismselect NE 0) then begin
			calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,event.x*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,event.y*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset,slitangle
			width_zero=width[goodid]/2
			width_zero=20/bin[1]/samplefac

			tvbox3,length[goodid]/2,width[goodid]/2*samplefac_old*cos(slitangle*!PI/180.),xcen[goodid],ycen[goodid],angle=slitangle[goodid]
			tvbox3,length[goodid]/2*cos(slitangle*!PI/180.),grism_info.wavecoverage/2*samplefac_old,xcen2[goodid],ycen2[goodid],red
			tvbox3,length[goodid]/2,width_zero[goodid],xcen2[goodid],ycen3[goodid],red,angle=slitangle[goodid]

			if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2,naxis

			samplefac=samplefac_old
			calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xoffset,yoffset,slitangle
		ENDIF

		samplefac=samplefac_old

	wset,win
	ENDIF
	goto,next
endif

IF (value EQ 'Pickup Object') THEN begin
	IF event.select EQ 1 then begin
		flag_pickupmode=1
;		print,flag_pickupmode
	endif

	GOTO,NEXT
END

IF (value EQ 'Click Point') THEN begin
	IF event.select EQ 1 then begin
		flag_pickupmode=0
;		print,flag_pickupmode
	endif
	GOTO,NEXT
END

IF value EQ 'Draw FOV' then begin
	IF event.select EQ 1 then begin
		xyr=dialog_input(prompt=["Xcen (pix)","Ycen (pix)","r (arcmin)"],nfields=3,initial=[xFOVcen,yFOVcen,r/60.*pixscale],dialog_parent=base,title=" ")
		IF n_elements(xyr) NE 3 THEN GOTO,NEXT
		xFOVcen=float(xyr[0])
		yFOVcen=float(xyr[1])
		r=float(xyr[2])*60./pixscale
		wset,win
		draw_fov,xFOVcen,yFOVcen,r,r2,naxis
		flag_draw_fov=1
	ENDIF ELSE BEGIN
		flag_draw_fov=0
	ENDELSE
	goto,NEXT
END

IF value EQ 'Display Slit ID' then begin
	IF (flag_readmdp EQ 0 OR flag_grismselect NE 0) then GOTO,NEXT
	IF event.select EQ 1 then begin
		display_slit_id,x1,x2,y1,y2,goodid
;		xyouts,(x2/samplefac/bin[0])[goodid],(y1/samplefac/bin[1])[goodid],(strtrim(string(indgen(n_elements(x1))),2))[goodid],/device,charsize=1.5
		flag_display_slit_id=1
	ENDIF ELSE BEGIN
		flag_display_slit_id=0
	ENDELSE
	GOTO,NEXT
END


IF (value EQ 'Redraw') THEN begin
	wset,win
	widget_control,hourglass=1
	tv,bytscl(image2,min=range[0],max=range[1])
	IF (flag_readmdp NE 0 and flag_grismselect NE 0) then begin
 		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
	END
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2,naxis
	widget_control,hourglass=0
	goto,NEXT
END

IF value EQ 'Draw Slit' then begin
	IF (flag_readmdp NE 0 and flag_grismselect NE 0) then begin
		widget_control,hourglass=1
		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
		widget_control,hourglass=0
	END
	goto,NEXT
END

IF (value EQ 'Print') THEN begin
	PRINT,'Print IS SELECTED'
;	wset,win


	fileName = DIALOG_PICKFILE (/WRITE, FILTER = '*.ps', DIALOG_PARENT = base)
	IF (fileName NE '') THEN BEGIN

	d = FINDFILE (fileName, COUNT = fileExists)
	IF (fileExists) THEN BEGIN
         IF (DIALOG_MESSAGE (/QUESTION, ['File ' + fileName + ' exists.', $
	     'Overwrite?'], DIALOG_PARENT = event.top) EQ 'No') THEN $
            GOTO, NEXT
	ENDIF

	temp=!D
	temp.name='PS'

	plot,[0],[0],xrange=[0,temp.x_size],yrange=[0,temp.y_size],xmargin=[0,0],ymargin=[0,0]

	deviceSave = !D.NAME
	SET_PLOT, 'PS';,x_size=temp.x_size,y_size=temp.y_size,x_vsize=temp.x_vsize,y_vsize=temp.y_vsize
	DEVICE, FILE = fileName

;	formInfo = cmps_form(Cancel=canceled, Create=create)
	thisDevice = !D.Name
;	Set_Plot, "PS"
;	Device, _Extra=formInfo

;	imdisp,bytscl(image2,min=range[0],max=range[1]),margin=0
	tv,bytscl(image2,min=range[0],max=range[1])
	tvbox3,length[goodid]/2,width[goodid]/2*cos(slitangle*!PI/180.),xcen[goodid],ycen[goodid],/data,angle=slitangle[goodid]
	tvbox3,length[goodid]/2*cos(slitangle*!PI/180.),grism_info.wavecoverage/2,xcen[goodid],ycen2[goodid],red,/data
; 	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,win,/printout,/data
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2,naxis,/printout
	if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid,/printout

	device,/close
	SET_PLOT, deviceSave
	ENDIF
 	goto,NEXT
END

IF (value EQ 'Change Intensity Scale') then begin
	wset,win
	range=dialog_input(prompt=["MIN","MAX"],nfields=2,initial=range,dialog_parent=base,title="MAX/MIN intensity")
	IF(n_elements(range) NE 2) THEN GOTO,NEXT
	widget_control,hourglass=1
	imdisp,bytscl(image2,min=range[0],max=range[1]),margin=0
	IF (flag_readmdp NE 0 and flag_grismselect NE 0) then begin
		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
	END
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2,naxis
	widget_control,hourglass=0
	goto,NEXT
END

IF (value EQ 'Auto Intensity Scale') then begin
	wset,win
	widget_control,hourglass=1
	imdisp,sigrange(image2,fraction=0.95,range=range),margin=0
	IF (flag_readmdp NE 0 and flag_grismselect NE 0) then begin
		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
	END
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2,naxis
	widget_control,hourglass=0
	goto,NEXT
END


IF value EQ 'Show Nearest Slit' then BEGIN
	IF (flag_readmdp EQ 0 OR flag_grismselect EQ 0) then GOTO,NEXT
	wset,win
	get_nearest_slit,xcen,ycen,id,win
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	draw_slit_id,length,width,xcen,ycen,id
	xnear=xcen[id] & ynear=ycen[id]
	wset,win2

	start_x=xnear[0]*samplefac-pickupbox_size & start_y=ynear[0]*samplefac-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[xnear[0]*samplefac-pickupbox_size > 0:xnear[0]*samplefac+pickupbox_size,ynear[0]*samplefac-pickupbox_size > 0:ynear[0]*samplefac+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1

	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset,slitangle
	width_zero=width[goodid]/2
	width_zero=20/bin[1]/samplefac

	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win

;	tvbox3,length[goodid]/2,width[goodid]/2*samplefac_old*cos(slitangle*!PI/180.),xcen[goodid],ycen[goodid],angle=slitangle[goodid]
;	tvbox3,length[goodid]/2*cos(slitangle*!PI/180.),grism_info.wavecoverage/2,xcen2[goodid],ycen2[goodid],red
;	tvbox3,length[goodid]/2,width_zero[goodid],xcen2[goodid],ycen3[goodid],red,angle=slitangle[goodid]
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xoffset,yoffset,slitangle
	wset,win
	print,id,x1[id],x2[id],format='("ID, Left, Right=",D,2F10.2)'

	xy2ad, (x1+y1)[id]/2, (y1+y2)[id]/2, wcsinfo, a, d
;	print,adstring(a,d,1)
	dummy=dialog_message([["Slit ID="+strtrim(string(id),2)],["[Left:Right]= ["+strtrim(string(x1[id]),2)+":"+strtrim(string(x2[id]),2)+"]"],["Slit width (pix)= "+strtrim(string(width[id]*bin[1]*samplefac),2)+" Slit angle= "+strtrim(string(slitangle[id]),2)+" deg"]],/information)
	goto,NEXT
END

IF value EQ 'Show Slit(ID)' then BEGIN
	IF (flag_readmdp EQ 0 and flag_grismselect NE 0) then GOTO,NEXT
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input',dialog_parent=base))
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	xnear=xcen[id] & ynear=ycen[id]
;	print,'Slit ID= ',id
	wset,win2
	start_x=xnear[0]*samplefac-pickupbox_size & start_y=ynear[0]*samplefac-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[xnear[0]*samplefac-pickupbox_size:xnear[0]*samplefac+pickupbox_size,ynear[0]*samplefac-pickupbox_size:ynear[0]*samplefac+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset,slitangle
	samplefac=samplefac_old
	width_zero=width[goodid]/2
	width_zero=20/bin[1]/samplefac
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win

;	tvbox3,length[goodid]/2,width[goodid]/2*samplefac_old*cos(slitangle*!PI/180.),xcen[goodid],ycen[goodid],angle=slitangle[goodid]
;	tvbox3,length[goodid]/2*cos(slitangle*!PI/180.),grism_info.wavecoverage/2,xcen2[goodid],ycen2[goodid],red
;	tvbox3,length[goodid]/2,width_zero[goodid],xcen2[goodid],ycen3[goodid],red,angle=slitangle[goodid]

	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xoffset,yoffset,slitangle
	wset,win
	print,x1[id],x2[id],format='("ID, Left, Right=",D,2F10.2)'
	dummy=dialog_message([["Slit ID="+strtrim(string(id),2)],["[Left:Right]= ["+strtrim(string(x1[id]),2)+":"+strtrim(string(x2[id]),2)+"]"],["Slit width (pix)= "+strtrim(string(width[id]*bin[1]*samplefac),2)+" Slit angle= "+strtrim(string(slitangle[id]),2)+" deg"]],/information)

	xy2ad, (x1+y1)[id]/2, (y1+y2)[id]/2, wcsinfo,a, d
;	print,adstring(a,d,1)
	goto,NEXT
END

IF value EQ 'Del Nearest Slit' then BEGIN
	IF (flag_readmdp EQ 0 and flag_grismselect NE 0) then GOTO,NEXT
	wset,win
	get_nearest_slit,xcen,ycen,id,win
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	draw_slit_id,length,width,xcen,ycen,id
	add_delid,delid,id
	make_id,delid,goodid,x1
	goto,NEXT
END

IF value EQ 'Add Slit by Click' then BEGIN
	IF (flag_grismselect EQ 0) then begin
		result=dialog_message(['Select grism first'],/Error)
		GOTO,NEXT
	END
	wset,win
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	wset,win2
	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

	IF flag_pickupmode EQ 0 then begin
		CURSOR,tmp_x,tmp_y,/device
		click3=fltarr(2)
		click3[0]=tmp_x & click3[1]=tmp_y
		click3[0]=click3[0]-pickupbox_size+click2[0]
		click3[1]=click3[1]-pickupbox_size+click2[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	ENDIF ELSE BEGIN
		CURSOR,tmp_x,tmp_y,/device
		click3=fltarr(2)
		click3[0]=tmp_x-pickupbox_size+click2[0] & click3[1]=tmp_y-pickupbox_size+click2[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

		pickupbox_size_org=pickupbox_size
		pickupbox_size=10
		result=gauss2dfit(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],a)
		if (a[4] LT 0) or (a[4] GT pickupbox_size*2+1) OR (a[5] LT 0) or (a[5] GT pickupbox_size*2+1) then begin
			print,'Fit ERROR'
			result=dialog_message('The Gauss fit went wrong. Set the slit pos. to the clicked pos.',/Error)
			a[4]=pickupbox_size & a[5]=pickupbox_size; force the gaussfit value to the original pos.
		ENDIF
		click3[0]=a[4]-pickupbox_size+click3[0]+1 & click3[1]=a[5]-pickupbox_size+click3[1]+1
		pickupbox_size=pickupbox_size_org


		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

	ENDELSE

	tvbox3,grism_info.length_default*samplefac/2,grism_info.width_default*samplefac/2,pickupbox_size,pickupbox_size
	ycen3=click3[1]+grism_info.waveoffset
	tvbox3,grism_info.length_default/2*samplefac,grism_info.wavecoverage*samplefac/2,pickupbox_size,pickupbox_size,red

	wset,win


	width=[width,grism_info.width_default]
	length=[length,grism_info.length_default]
	priority=[priority,3]
	type=[type,0]; 0 mean slit
	object=[object,'Newly Added Slit']
	slitangle=[slitangle,0]

	x1=[x1,click3[0]*bin[0]-grism_info.length_default/2*bin[0]*samplefac]
	x2=[x2,click3[0]*bin[0]+grism_info.length_default/2*bin[0]*samplefac]
	y1=[y1,click3[1]*bin[1]]
	y2=[y2,click3[1]*bin[1]]

	make_id,delid,goodid,x1
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	flag_readmdp=1
	goto,NEXT
END

IF value EQ 'Add Alignment Hole' then BEGIN
	IF (flag_grismselect EQ 0) then begin
		result=dialog_message(['Select grism first'],/Error)
		GOTO,NEXT
	END
	wset,win
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	wset,win2

	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

	CURSOR,tmp_x,tmp_y,/device
	click3=fltarr(2)
	click3[0]=tmp_x-pickupbox_size+click2[0] & click3[1]=tmp_y-pickupbox_size+click2[1]

	start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	pickupbox_size_org=pickupbox_size
	pickupbox_size=10
	result=gauss2dfit(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],a)
	if (a[4] LT 0) or (a[4] GT pickupbox_size*2+1) OR (a[5] LT 0) or (a[5] GT pickupbox_size*2+1) then begin
		print,'Fit ERROR'
		result=dialog_message('The Gauss fit went wrong. Set the slit pos. to the clicked pos.',/Error)
		a[4]=pickupbox_size & a[5]=pickupbox_size; force the gaussfit value to the original pos.
	ENDIF
	click3[0]=a[4]-pickupbox_size+click3[0]+1 & click3[1]=a[5]-pickupbox_size+click3[1]+1
	pickupbox_size=pickupbox_size_org

	print,'Exposure Time',exptime
	print,'Sky Level, Sky Count Rate',a[0],a[0]/exptime
	print,'Peak Count, Peak Count Rate',a[1],a[1]/exptime
	print,'Seeing (arcsec in FWHM for X & Y)',a[2]*2.355,a[3]*2.355

	tvbox3,holediameter*samplefac/2,holediameter*samplefac/2,pickupbox_size,pickupbox_size;
	ycen3=click3[1]+grism_info.waveoffset*samplefac
	tvbox3,holediameter*samplefac/2,grism_info.wavecoverage*samplefac/2,pickupbox_size,pickupbox_size,red

	wset,win

	x1=[x1,click3[0]*bin[0]-holediameter*samplefac/2*bin[0]]
	x2=[x2,click3[0]*bin[0]+holediameter*samplefac/2*bin[0]]
;	y1=[y1,click3[1]*bin[1]-holediameter*samplefac/2*bin[0]]
;	y2=[y2,click3[1]*bin[1]+holediameter*samplefac/2*bin[0]]
	y1=[y1,click3[1]*bin[1]]
	y2=[y2,click3[1]*bin[1]]

	width=[width,grism_info.width_default]
	length=[length,grism_info.length_default]
	priority=[priority,0]
	make_id,delid,goodid,x1
	id=n_elements(x1)-1
	length[id]=holediameter
	width[id]=length[id]
	type=[type,1]; 1 means hole
	object=[object,'Alignment Hole']
	slitangle=[slitangle,0]
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	flag_readmdp=1

goto,NEXT
END


IF value EQ 'Change Slit Params' then begin
	IF (flag_readmdp EQ 0 and flag_grismselect NE 0) then GOTO,NEXT
	get_nearest_slit,xcen,ycen,id,win
	wset,win
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	draw_slit_id,length,width,xcen,ycen,id
;	newx12=dialog_input(prompt=["Left","Right"],nfields=2,initial=[x1[id],x2[id]],dialog_parent=base,title='Set Slit Params of #'+strtrim(string(id[0]),2),xsize=300)
	newx12_s=dialog_input(nfields=4,prompt=["Left","Right","Width (PIX)","Angle (DEG)"],initial=[x1[id],x2[id],width[id]*bin[1]*samplefac,slitangle[id]],dialog_parent=base,title='Set Slit Edge X-Coordinate of #'+strtrim(string(id[0]),2),xsize=300)
	newx12=float(newx12_s)
	if n_elements(newx12) NE 4 then	GOTO,NEXT
	xcen=(x2[id]+x1[id])/2.
	ycen=(y2[id]+y1[id])/2.
	y2[id]=ycen+(newx12[1]-xcen)*tan(slitangle[id]*!PI/180.)
	y1[id]=ycen+(newx12[0]-xcen)*tan(slitangle[id]*!PI/180.)
	x1[id]=newx12[0] & x2[id]=newx12[1]
	
	width[id]=newx12[2]/bin[1]/samplefac
	slitangle[id]=newx12[3]

	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	goto,NEXT
END

IF value EQ 'Slit Overlap Check' then begin
	IF (flag_readmdp EQ 0 and flag_grismselect NE 0) then GOTO,NEXT
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,xcen2,ycen,ycen2,ycen3,xoffset,yoffset,slitangle
	flag3=0
	for j=0,n_elements(x1)-1 do begin
		if max(delid EQ j) EQ 1 then goto,skiploop_j
		for i=j+1,n_elements(x1)-1 do begin
			if max(delid EQ i) EQ 1 then goto,skiploop_i
			if (x1[j] GT x1[i]) and (x1[j] LT x2[i]) and ((ycen2[j]-grism_info.wavecoverage/2) GT (ycen2[i]-grism_info.wavecoverage/2)) and ((ycen2[j]-grism_info.wavecoverage/2) LT (ycen2[i]+grism_info.wavecoverage/2)) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid,slitangle & flag3=1 & end
			if (x2[j] GT x1[i]) and (x2[j] LT x2[i]) and ((ycen2[j]-grism_info.wavecoverage/2) GT (ycen2[i]-grism_info.wavecoverage/2)) and ((ycen2[j]-grism_info.wavecoverage/2) LT (ycen2[i]+grism_info.wavecoverage/2)) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid,slitangle & flag3=1 & end
			if (x1[j] GT x1[i]) and (x1[j] LT x2[i]) and ((ycen2[j]+grism_info.wavecoverage/2) GT (ycen2[i]-grism_info.wavecoverage/2)) and ((ycen2[j]+grism_info.wavecoverage/2) LT (ycen2[i]+grism_info.wavecoverage/2)) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid,slitangle & flag3=1 & end
			if (x2[j] GT x1[i]) and (x2[j] LT x2[i]) and ((ycen2[j]+grism_info.wavecoverage/2) GT (ycen2[i]-grism_info.wavecoverage/2)) and ((ycen2[j]+grism_info.wavecoverage/2) LT (ycen2[i]+grism_info.wavecoverage/2)) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid,slitangle & flag3=1 & end
			skiploop_i:
		endfor
		skiploop_j:
	endfor
	make_id,delid,goodid,x1
	if flag3 EQ 0 then result=dialog_message('No Overlapping Slits Detected.',/Information)
	goto,NEXT
END

IF value EQ 'Show Slit List' then begin
	IF (flag_readmdp EQ 0 and flag_grismselect NE 0) then GOTO,NEXT
	make_id,delid,goodid,x1
	num=n_elements(x1)
	list=string(indgen(num))
	types=strarr(num)
	types[*]='Slit'
	holeid=where(type EQ 1)
	if size(holeid,/n_dimensions) NE 0 then types[holeid]='Hole'
;	list2=strtrim(list,2) + ' ' + types+' at ('+strtrim(string((x1+x2)/2),2)+','+strtrim(string((y1+y2)/2),2)+') '+ strtrim(string(width*bin[1]*samplefac) + ' ' + strtrim(string(slitangle),2) + ' ' + object)
	list2=strtrim(list,2) + ' ' + types+' at ('+strtrim(string((x1+x2)/2),2)+','+strtrim(string((y1+y2)/2),2)+') width: '+ strtrim(string(width*bin[1]*samplefac) + ' angle: ' + strtrim(string(slitangle),2) + ' comments: ' + object)
	result=dialog_checklist(list2,/nonexclusive,initial=goodid,/scroll,y_scroll_size=maxy/samplefac*0.7,x_scroll_size=500,xposition=100,yposition=maxy/samplefac*0.7,dialog_parent=base,title='Slit List (use check box for enable/disable any slits/holes)')
	if total(result) EQ 0 then goto,jump_cancel
	delid=where(fix(result) EQ 0)
	make_id,delid,goodid,x1
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	jump_cancel:
	goto,NEXT
END

IF value EQ 'Read FITS Image' then begin
	widget_control,hourglass=1
	readfits,image,image2,objectname,naxis,bin,exptime,header,samplefac,wcsinfo,pixscale,mygetpath
	holediameter=20./bin[1]/samplefac;
	WIDGET_CONTROL, base, /DESTROY
	create_gui,naxis[0],naxis[1],holediameter,win,win2
	widget_control,hourglass=0
	goto,NEXT
END

IF value EQ 'Read MDP file' then begin
	input_mdp,x1,y1,x2,y2,length,width,slitangle,priority,object,naxis,type;
	
	; Reset mask information
	num=n_elements(x1)
	delid=-1
	goodid=indgen(num)
	make_id,delid,goodid,x1
	flag_readmdp=1
        widget_control,width_text,set_value='Slit W: '+strtrim(string(grism_info.width_default*samplefac*bin[1]/10.),2)+'(arcs)'
        widget_control,length_text,set_value='Slit L: '+strtrim(string(grism_info.length_default*samplefac*bin[0]/10.),2)+'(arcs)'
        widget_control,aperture_text,set_value='Hole D: '+strtrim(string(holediameter*samplefac*bin[1]/10.),2)+'(arcs)'
	goto,NEXT
END

IF value EQ 'Save SBR' then begin
	write_sbr_wcs,pixscale,x1,y1,x2,y2,xFOVcen,yFOVcen,width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid,slitangle
	goto,NEXT
END

IF value EQ 'Save SBR (CCD)' then begin
        write_sbr_ccd_trans,x1,y1,x2,y2,xFOVcen,yFOVcen, width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid
        goto,NEXT
END

IF value EQ 'Save MDP' then begin
	write_mdp2,x1,y1,x2,y2,xFOVcen,yFOVcen, width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid,priority,object,slitangle
	goto,NEXT
END

IF value EQ 'Automatic Slit Width Expansion' then begin
	IF (flag_readmdp EQ 0 and flag_grismselect NE 0) then GOTO,NEXT
	x2_good=x2[goodid]
	x1_good=x1[goodid]
	y1_good=y1[goodid]
	y2_good=y2[goodid]
	slitangle_good=slitangle[goodid]
	newx2=x2_good
	newy2=y2_good

	for j=0,n_elements(x1[goodid])-1 do begin
		newid=where(x1_good GT x2_good[j])

;		x1_new_temp=min(x1_good[newid])
;		x1_good_sort=sort(x1_good_sort)
;		newid_tmp=where(x1_good EQ x1_new_temp)
;		newid_tmp2=min(where(x1_good_sort GT x1_new_temp)_
;		if (y2[newid_tmp] LT y1[newid_tmp2]) OR (y1[newid_tmp] GT y1[newid_tmp2]) then newid=newid_tmp2 else newid=newid_tmp
		
		if min(newid) NE -1 then begin
			newx2[j]=min(x1_good[newid])
			nextid=where(newx2[j] eq x1_good)
			ycen=(y1_good[j]+y2_good[j])/2
			newy2[j]=ycen+(x1_good[nextid]-(x1_good[j]+x2_good[j])/2)*tan(slitangle_good[j]*!PI/180.)
		endif else begin ; case of no expansion
			newx2[j]=x2_good[j]
		endelse

		if type[j] EQ 1 then newx2[j]=x2_good[j]
	endfor

	x2[goodid]=newx2-(slit_space+1)
	y2[goodid]=newy2
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	goto,NEXT
END


IF value EQ 'Change Default Slit Params' then begin
	set_params,pickupbox_size,holediameter,slit_space,xoffset,yoffset,n_elements(x1),yohaku,width_text,aperture_text,length_text
	goto,NEXT
END

IF value EQ 'Grism Select' then begin
	IF flag_readmdp EQ 0 then begin
		result=dialog_message(['No MDP file selected.','Select MDP file first'],/Error)
		GOTO,NEXT
	END

	set_grism,base,grismselect
	flag_grismselect=1

	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,xcen2,ycen,ycen2,xoffset,yoffset,slitangle,win
	goto,NEXT
END

IF value EQ 'Grism Setting ...' then begin
	IF flag_grismselect EQ 0 then begin
		result=dialog_message(['No Grism was selected.'],/Error)
		GOTO,NEXT
	END

	set_grism_pars
	flag_grismselect=1
	goto,NEXT
END

IF value EQ 'Preferences' then begin
	table=fix(dialog_input($
		prompt=['Color table number (1-40)','Demagnification factor'],$
		nfields=2,initial=[color_table,samplefac],dialog_parent=base))
	if n_elements(table) NE 2 then GOTO,NEXT

	if table[0] NE color_table then begin
		color_table=table[0]
		loadct,table[0]
	end

	if table[1] NE samplefac then begin
		samplefac=table[1]
		expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2
		WIDGET_CONTROL, base, /DESTROY
		create_gui,naxis[0],naxis[1],holediameter,win,win2
	end

	goto,NEXT
END


IF VALUE EQ 'Quit' THEN BEGIN
	result=dialog_message('Do you really want to quit?',/question)
	if result EQ 'Yes' then begin
		WIDGET_CONTROL, base, /DESTROY
		goto,ending
	endif else begin	
		goto,NEXT
	ENDELSE
END

IF value EQ 'Read MDP (RAD-EC) file' then begin
	input_mdp_radec,wcsinfo,x1,y1,x2,y2,length,width,priority,object,naxis,type;
	; Reset mask information
	num=n_elements(x1)
	delid=-1
	goodid=indgen(num)
	make_id,delid,goodid,x1
	flag_readmdp=1
	goto,NEXT
END

if value EQ 'Mark RA DEC' then begin
	result=dialog_input(prompt=["Hour",'Min','Sec','Deg','Min','Sec'],nfield=6,dialog_parent=base)
	if n_elements(result) NE 6 then GOTO,NEXT
	hh=float(result[0])
	mm=float(result[1])
	ss=float(result[2])
	dhh=float(result[3])
	dmm=float(result[4])
	dss=float(result[5])

	dec=ten(dhh,dmm,dss)
	ra=ten(hh,mm,ss)*15.

	ad2xy,ra,dec,wcsinfo,x,y
	print,x,y
	draw_ellipse,x/samplefac,y/samplefac,100/samplefac,100/samplefac,resolution=10,/device
	goto,NEXT
END


if value EQ 'FOV Center (RA DEC)' then begin

	xy2ad,XFOVCEN,YFOVCEN,wcsinfo,a,d
	s=strsplit(adstring(a,d,1),/extract)
	hhc=float(s[0]) & mmc=float(s[1]) & ssc=float(s[2]) & dhhc=float(s[3]) & dmmc=float(s[4]) & dssc=float(s[5])
;	print,hhc,mmc,ssc,dhhc,dmmc,dssc
	result=dialog_input(prompt=["Hour",'Min','Sec','Deg','Min','Sec','arcsec/pix'],initial=[hhc,mmc,ssc,dhhc,dmmc,dssc,pixscale],nfield=7,dialog_parent=base,title='FOV Center Coordinate')
        if n_elements(result) NE 7 then goto,NEXT
	wcsinfo.crval[0]=ten(float(result[0]),float(result[1]),float(result[2]))*15.
	wcsinfo.crval[1]=ten(float(result[3]),float(result[4]),float(result[5]))
	wcsinfo.crpix[0]=XFOVCEN
	wcsinfo.crpix[1]=YFOVCEN
	wcsinfo.cdelt[0]=wcsinfo.cdelt[0]/pixscale*double(result[6]);
	wcsinfo.cdelt[1]=wcsinfo.cdelt[1]/pixscale*double(result[6]);
	wcsinfo.cd[0,0]=wcsinfo.cd[0,0]/pixscale*double(result[6]);
	wcsinfo.cd[0,1]=wcsinfo.cd[0,1]/pixscale*double(result[6]);
	wcsinfo.cd[1,0]=wcsinfo.cd[1,0]/pixscale*double(result[6]);
	wcsinfo.cd[1,1]=wcsinfo.cd[1,1]/pixscale*double(result[6]);
	pixscale=double(result[6]);

	xy2ad,XFOVCEN,YFOVCEN,wcsinfo,a,d
	PRINT,adstring(a,d,1)

	goto,NEXT
END

if value EQ 'Show WCS Info' then begin
	xy2ad,XFOVCEN,YFOVCEN,wcsinfo,a,d
	s=strsplit(adstring(a,d,1),/extract)
	hhc=float(s[0]) & mmc=float(s[1]) & ssc=float(s[2]) & dhhc=float(s[3]) & dmmc=float(s[4]) & dssc=float(s[5])
	print,'FOV Center Ra Dec (CRVAL)',hhc,mmc,ssc
        print,dhhc,dmmc,dssc
	print,'FOV Center X Y (CRPIX)',XFOVCen,YFOVCen
	print,'arcsec/pix (CDELT)',pixscale
	goto,NEXT
END


if value EQ 'Mark RA DEC List' then begin
	
	read_radec,ra,dec
	if n_elements(ra) EQ 0 then GOTO,NEXT
	ad2xy,ra,dec,wcsinfo,x,y

	for j=0,n_elements(ra)-1 do draw_ellipse,x[j]/samplefac,y[j]/samplefac,20/samplefac,20/samplefac,resolution=10,/device
	for j=0,n_elements(ra)-1 do xyouts,x[j]/samplefac,y[j]/samplefac,strtrim(string(j),2),/device,charsize=1.5
	goto,NEXT
END


;'Change Window Size': begin
;	pickupbox_size=float(dialog_input(prompt='Pickup Box Size',nfields=1,initial=pickupbox_size),dialog_parent=base)
;	window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2
;END


ERROR:

!P = pSave & !X = xSave & !Y = ySave

WSET, winSave

;
; End
;

ENDING:

END
