PRO display_slit_id,x1,x2,y1,y2,goodid
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default,waveoffset_default,length_default,width_default,zero_offset
		xyouts,(x2/samplefac/bin[0])[goodid],(y1/samplefac/bin[1])[goodid],(strtrim(string(indgen(n_elements(x1))),2))[goodid],/device,charsize=1.5
END


PRO calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default,waveoffset_default,length_default,width_default,zero_offset

	length=(x2-x1)/bin[0]/samplefac
;	length=(y2-y1)/bin[0]/samplefac; for trans image
	width=(y2-y1)/bin[1]/samplefac
;	width=(x2-x1)/bin[1]/samplefac; for trans image

	xcen=((x1+x2)/2-xoffset)/bin[0]/samplefac
	ycen=((y1+y2)/2-yoffset)/bin[1]/samplefac
	waveoffset=waveoffset_default/bin[1]/samplefac
	ycen2=ycen+waveoffset
	ycen3=((ycen*SAMPLEFAC*bin[1]-2000)+zero_offset)/bin[1]/samplefac
	wavecoveradge[*]=wavecoveradge_default/bin[1]/samplefac
end

PRO draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win,printout=printout,forminfo=forminfo
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset
COMMON share3,red,blue,green
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	if N_elements(printout) EQ 0 then wset,win
;	R=256 & G=0 & B=0 & color=R+(G+256L)*(B+256L)
;	R=256 & G=256 & B=256 & color=R+(G+256L)*(B+256L)
;	R=0 & G=0 & B=0 & color=R+(G+256L)*(B+256L)
	width_zero=width[goodid]/2
	width_zero_default=2.5
	width_zero=width_zero_default/bin[1]/samplefac
	if N_elements(forminfo) EQ 0 then BEGIN	
		tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid]
		tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],red
		tvbox2,length[goodid]/2,width_zero[goodid],xcen[goodid],ycen3[goodid],green
	ENDIF ELSE BEGIN
		tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid],color,_extra=forminfo
		tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],color,_extra=forminfo
		tvbox2,length[goodid]/2,width_zero[goodid],xcen[goodid],ycen3[goodid],color
	ENDELSE
end

PRO show_spectrum,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,id,range
;
; Display a spectrum for a slit
; This task is for the specturm image
;
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	window,2,xsize=length[id],ysize=wavecoveradge[id]
	wset,2
;	image3=image[xcen[id]-length[id]/2:xcen[id]+length[id]/2,ycen2[id]-wavecoveradge[id]/2:ycen2[id]+wavecoveradge[id]/2)]
	image3=extrac(image,xcen[id]-length[id]/2,ycen2[id]-wavecoveradge[id]/2,length[id],wavecoveradge[id])

	tv,bytscl(image3,min=range[0],max=range[1])
	print,length[id],wavecoveradge[id]
end

PRO reduce_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,id,range,naxis,yohaku
;
;
;
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	window,2,xsize=length[id]*samplefac,ysize=wavecoveradge[id]*samplefac
	wset,2
;	image3=image[xcen[id]-length[id]/2:xcen[id]+length[id]/2,ycen2[id]-wavecoveradge[id]/2:ycen2[id]+wavecoveradge[id]/2)]
	image3=extrac(image,(xcen[id]-length[id]/2)*samplefac,(ycen2[id]-wavecoveradge[id]/2)*samplefac,length[id]*samplefac,wavecoveradge[id]*samplefac)
	tv,bytscl(image3,min=range[0],max=range[1])
	fspecred_engine,image,header,2,(xcen[id]-length[id]/2)*samplefac+yohaku,(xcen[id]+length[id]/2)*samplefac-yohaku,(ycen2[id]-wavecoveradge[id]/2)*samplefac+yohaku > 0,(ycen2[id]+wavecoveradge[id]/2)*samplefac-yohaku < naxis[1]-1, image_ff,compimage_ff,grismrotflag=0; chip=2 for bigimage
	write_fits,image_ff,header,dir=workdir
	write_fits,compimage_ff,header,dir=workdir
end


PRO show_spectra_all,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,range
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset

	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	x_size=0
	newimage=fltarr(1,wavecoveradge[0]*samplefac)
	for id=0,n_elements(x1)-2 do begin
	;	image3=image[xcen[id]-length[id]/2:xcen[id]+length[id]/2,ycen2[id]-wavecoveradge[id]/2:ycen2[id]+wavecoveradge[id]/2)]
		image3=extrac(image,(xcen[id]-length[id]/2)*samplefac,(ycen2[id]-wavecoveradge[id]/2)*samplefac,length[id]*samplefac,wavecoveradge[id]*samplefac)
		newimage=[newimage,image3]
		x_size=x_size+length[id]*samplefac
	end
	window,2,xsize=x_size,ysize=wavecoveradge[id]
	imdisp,bytscl(newimage,min=range[0],max=range[1]),margin=0
	write_fits,newimage,header
	wset,win
end

PRO draw_slit_id,length,width,xcen,ycen,id
	R=256 & G=128 & B=128 & color=R+(G+256L)*(B+256L)
end

PRO draw_fov,xFOVcen,yFOVcen,r,r2
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
COMMON share3,red,blue,green

	draw_ellipse,xFOVcen/samplefac,yFOVcen/samplefac,r/samplefac,r/samplefac,resolution=100,/device
	draw_ellipse,xFOVcen/samplefac,yFOVcen/samplefac,r2/samplefac,r2/samplefac,resolution=100,/device
	tvbox2,gapsize/samplefac/2,4095/samplefac/2,(xFOVcen+1+gapsize/2)/samplefac,4095/2/samplefac; was XMaskCenter
	;print,XRotatorCenter+1+gapsize/2,Xrotatorcenter,gapsize
end


PRO get_nearest_slit,xcen,ycen,id,win
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset
	wset,win
	click=fltarr(2)
	CURSOR,tmp_x,tmp_y,/device
	click[0]=tmp_x & click[1]=tmp_y
	r=sqrt((xcen-click[0])^2+(ycen-click[1])^2)
	id=where(r EQ min(r))
	if n_elements(id) NE 1 then id=id[0]
end

PRO make_id,delid,goodid,x1
	if n_elements(x1) EQ 0 then result=dialog_message(['You can not remove this slit/hole.','Number of slits/holes should be 1 or more.'],/Error)
	goodid=indgen(n_elements(x1))
	if (size(delid,/n_dimensions) NE 0) then remove,delid,goodid
end

PRO add_delid,delid,id
	if size(delid,/n_dimensions) EQ 0 then delid=[id] else delid=[delid,id]
END

PRO pro_overlap,j,i,length,width,xcen,ycen,priority,delid
COMMON share3,red,blue,green

	print,'Overlap',j, i
	R=256 & G=256 & B=0 & color=R+(G+256L)*(B+256L)
	tvbox2,length[j]/2,width[j]/2,xcen[j],ycen[j]
	tvbox2,length[i]/2,width[i]/2,xcen[i],ycen[i]
	if priority[j] LT priority[i] then begin
		add_delid,delid,i
		print,'Deleted ',i
		end
	if priority[i] LT priority[j] then begin
		add_delid,delid,j
		print,'Deleted ',j
	end
end


PRO set_params,pickupbox_size,holediameter,slit_space,xoffset,yoffset,num,yohaku,width_text,aperture_text,length_text
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset

;	params=dialog_input(prompt=	["Pickup Box Size","Aperture Size (diameter) (arcsec)",'Space between slits (in Pix: for Autoexpanding slits)','Xoffset','Yoffset','Yohaku','Default Slit Length (arcsec)','Default Slit Width (arcsec)'],$
	params=dialog_input(prompt=	["DO NOT CHANGE","Aperture Size (diameter) (arcsec)",'# of pixels between slits in autoexpanding slit width','DO NOT CHANGE','DO NOT CHANGE','DO NOT CHANGE','Default Slit Length (arcsec)','Default Slit Width (arcsec)'],$
		nfields=8,$
				initial=[pickupbox_size,holediameter*samplefac*bin[1]/10.,slit_space,xoffset,yoffset,yohaku,length_default*samplefac*bin[0]/10.,width_default*samplefac*bin[1]/10.],$
		title='Parameter Setting',dialog_parent=base)
	IF(n_elements(params) NE 8) THEN return
	pickupbox_size=fix(params[0])
	holediameter=float(params[1])/float(samplefac)/float(bin[1])*10.
	slit_space=float(params[2])
	xoffset=float(params[3])
	yoffset=float(params[4])
	yohaku=fix(params[5])
	length_default=float(params[6])/float(samplefac)/float(bin[0])*10.
	width_default=float(params[7])/float(samplefac)/float(bin[1])*10.
;	window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2,title='Pickup Box'

	widget_control,width_text,set_value='Slit Width: '+strtrim(string(width_default*samplefac*bin[1]/10.),2)+'(arcsec)'
	widget_control,length_text,set_value='Slit Length: '+strtrim(string(length_default*samplefac*bin[0]/10.),2)+'(arcsec)'
	widget_control,aperture_text,set_value='Aperture Diameter: '+strtrim(string(holediameter*samplefac*bin[1]/10.),2)+'(arcsec)'

END


;PRO set_grism,num,grism75,grism150,grism300B,grism300RY47,grism300RO58,base,grismselect
PRO set_grism,num,base,grismselect

COMMON share8,samplefac,bin, wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset

	params=dialog_menu(['75-Y47','150-Y47','300B-L600','300B-Y47','300R-Y47','300R-O58'],title='Grism Selection',dialog_parent=base)
	IF(n_elements(params) EQ 0) THEN return

	CASE params OF

	'75-Y47': begin
	directwave=6483; was 6500
	wavestart=4700 & waveend=9500 & disp=11.8/2; was 5.46
;	widget_control,grism75,set_button=1
	widget_control,grismselect,set_value='Grism: 75'
	zero_offset=4000-1000
	END

	'150-Y47': begin
	directwave=6768; was 6500
	wavestart=4700 & waveend=9500 & disp=5.67/2; was 2.72
;	widget_control,grism150,set_button=1
	widget_control,grismselect,set_value='Grism: 150'
	zero_offset=4000+120
	END

	'300B-Y47': begin
	directwave=5540; was 5500
	wavestart=4700 & waveend=9500 & disp=2.79/2; was 1.34
;	widget_control,grism300B,set_button=1
	widget_control,grismselect,set_value='Grism: 300B'
	zero_offset=4000+4000
	END	

	'300R-Y47': begin
	directwave=7550; was 7500
	wavestart=4700 & waveend=9500 & disp=2.68/2; was 1.34
	widget_control,grismselect,set_value='Grism: 300R-Y47'
;	widget_control,grism300RY47,set_button=1
	zero_offset=4000+4000
	END

        '300B-L600': begin
        directwave=5540; was 5500
        wavestart=3500 & waveend=6000 & disp=2.79/2; was 1.34
;       widget_control,grism300B,set_button=1
        widget_control,grismselect,set_value='Grism: 300B+L600'
        zero_offset=4000+4000
        END

	'300R-O58': begin
	directwave=7550; was 7500
	wavestart=5800 & waveend=10000 & disp=2.68/2; was 1.34
;	widget_control,grism300RO58,set_button=1
	widget_control,grismselect,set_value='Grism: 300R-O58'
	zero_offset=4000+4000
	END
	ENDCASE

	wavecoveradge_default=(waveend-wavestart)/disp
	waveoffset_default=(directwave-(waveend+wavestart)/2)/disp

	wavecoveradge=fltarr(num)
	wavecoveradge[*]=wavecoveradge_default/bin[1]/samplefac
	waveoffset=waveoffset_default/bin[1]/samplefac
END


PRO input_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir;,width_default,length_default
COMMON share8,samplefac,bin, wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset

	read_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir=dir
	width[*]=width[*]/bin[1]/samplefac
	width_default=width[0]
	length[*]=length[*]/bin[0]/samplefac
	length_default=length[0]
END

PRO input_mdp_radec,wcsinfo,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir;,width_default,length_default
COMMON share8,samplefac,bin, wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default,zero_offset

	read_mdp_radec,wcsinfo,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir=dir
	width[*]=width[*]/bin[1]/samplefac
	width_default=width[0]
	length[*]=length[*]/bin[0]/samplefac
	length_default=length[0]
END


PRO readfits,image,image2,objectname,naxis,bin,exptime,header,samplefac,wcsinfo,path
	fitsdir=getenv("FOCASRED_FITS_IN")+'/'
	if fitsdir EQ '/' then fitsdir=getenv('PWD')
	read_fits,image,header,dir=fitsdir,myfilter='*fits',mytitle='Input BigImage',MYGETPATH=path
	bin=SXPAR(header,'BIN-FCT*')
		if n_elements(bin) EQ 1 then bin=[1,1]; in case of header from other instruments
	objectname=SXPAR(header,'OBJECT')
	exptime=SXPAR(header,'EXPTIME')
	naxis=SXPAR(header,'NAXIS*')
	samplefac=get_samplefac(naxis[1])
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2
	extast,header,wcsinfo,nparms
END







PRO create_gui,xsize,ysize,holediameter,win,win2

common widgetcom,base,pickobject,clickpoint,width_text,length_text,aperture_text,grismselect,curpos_label,draw_fov_button
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default,waveoffset_default,length_default,width_default,zero_offset

base = WIDGET_BASE (mbar=bar,TITLE = 'MDP', /row, MAP = 0)
base2 = WIDGET_BASE(base,/column,map=0,group_leader=base)
;base3 = WIDGET_BASE(base,/column,map=0,group_leader=base,/frame)
;grismbase = WIDGET_BASE(base2,/column,map=0,group_leader=base,/exclusive,/frame)
drawoptionbase = WIDGET_BASE(base2,/column,map=0,group_leader=base,/nonexclusive,/frame)
pickupmodebase = WIDGET_BASE(base2,/column,map=0,group_leader=base,/exclusive,/frame)

menu1=widget_button(bar, value='File',/menu)
button0=widget_button(menu1,value='Read FITS Image')
button1=widget_button(menu1,value='Read MDP file')
button2=widget_button(menu1,value='Save SBR (For Distortion Corrected Image)')
button3=widget_button(menu1,value='Save SBR (For Distortion UN-Corrected Image)')
button4=widget_button(menu1,value='Save SBR (CCD)')
button5=widget_button(menu1,value='Save Ascii Extension')
button6=widget_button(menu1,value='Save MDP')
button7=widget_button(menu1,value='Quit')

menu2=widget_button(bar, value='Option',/menu)
button0=widget_button(menu2,value='Grism Select')
button1=widget_button(menu2,value='Change Default Parameters')
button2=widget_button(menu2,value='Change Color Table')
button3=widget_button(menu2,value='Automatic Slit Width Expantion')

menu3=widget_button(bar, value='WCS',/menu)
button1=widget_button(menu3,value='Mark RA DEC')
;button1=widget_button(menu3,value='Mark RA DEC List')
button1=widget_button(menu3,value='Set FOV Center (RA DEC)')
button1=widget_button(menu3,value='Show WCS Info')
button1=widget_button(menu3,value='Read MDP (RAD-EC) file')

menu4=widget_button(bar, value='Spec menu',/menu)
button1=widget_button(menu4,value='Show Spectrum')
button1=widget_button(menu4,value='Show All Spectra')
button1=widget_button(menu4,value='Reduce Spectrum(ID)')

;menu5=widget_button(bar, value='Print',/menu)
;button1=widget_button(menu5,value='Print')

winSave = !D.WINDOW
;w1 = WIDGET_DRAW (base, XSIZE = FIX((xend-0)/samplefac), YSIZE = FIX((yend-0)/samplefac), /FRAME,/button_events,/motion_event)
w1 = WIDGET_DRAW (base, XSIZE = FIX(xsize/samplefac), YSIZE = FIX(ysize/samplefac), /FRAME,/button_events,/motion_event)

w2 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200, /FRAME); was 200; was base2

button1 = widget_button(base2, VALUE = 'Redraw',/frame)
button4 = widget_button(base2, VALUE = 'Draw Slit',/frame)
button2 = widget_label(base2,value='')
button2 = widget_button(base2, VALUE = 'Auto Intensity Scale',/frame)
button3 = widget_button(base2, VALUE = 'Change Intensity Scale',/frame)
button2 = widget_label(base2,value='')
button6 = widget_button(base2, VALUE = 'Show Nearest Slit',/frame)
button7 = widget_button(base2, VALUE = 'Show Slit(ID)',/frame)
button2 = widget_label(base2,value='')
button7 = widget_button(base2, VALUE = 'Add Slit by Click',/frame)
button7 = widget_button(base2, VALUE = 'Add Alignment Hole',/frame)
button7 = widget_button(base2, VALUE = 'Del Nearest Slit',/frame)
button2 = widget_label(base2,value='')
button7 = widget_button(base2, VALUE = 'Change Slit Length',/frame)
button7 = widget_button(base2, VALUE = 'Zoom Around Mouse',/frame)
button7 = widget_button(base2, VALUE = 'Slit Overlap Check',/frame)
button7 = widget_button(base2, VALUE = 'Show Slit List',/frame)
;button2 = widget_label(base2,value='Slit (arcsec)')

width_text = widget_label(base2,value='Slit Width: '+strtrim(string(width_default*samplefac*bin[1]/10.),2))+'(arcsec)'
length_text= widget_label(base2,value='Slit Length: '+strtrim(string(length_default*samplefac*bin[0]/10.),2))+'(arcsec)'
aperture_text = widget_label(base2,value='Aperture Diameter: '+strtrim(string(holediameter*samplefac*bin[1]/10.),2))+'(arcsec)'
grismselect = widget_label(base2,value='Grism: dummy')
curpos_label = widget_label(base2,value='('+strtrim(string(4000),2)+', '+strtrim(string(4000),2)+')')



pickobject=widget_button(pickupmodebase,value='Pickup Object')
clickpoint=widget_button(pickupmodebase,value='Click Point')
widget_control,pickobject,set_button=1

label3=widget_button(drawoptionbase,value='Display Slit ID')
draw_fov_button=widget_button(drawoptionbase,value='Draw FOV')

;grism75=0;widget_button(grismbase,value='75')
;grism150=0;widget_button(grismbase,value='150')
;grism300B=0;widget_button(grismbase,value='300B')
;grism300RY47=0;widget_button(grismbase,value='300R-Y47')
;grism300RO58=0;widget_button(grismbase,value='300R-O58')

;widget_control,base4,set_button=1

; Map to screen
WIDGET_CONTROL, base, /REALIZE,/UPDATE
WIDGET_CONTROL, w1, GET_VALUE = win;0
WIDGET_CONTROL, w2, GET_VALUE = win2;02
;win=win0 & win2=win02
WIDGET_CONTROL, base, /REALIZE,/UPDATE

; Place the dialog: window manager dependent

;   CURRENT_SCREEN = GET_SCREEN_SIZE()
;   WIDGET_CONTROL, base, TLB_GET_SIZE = DIALOG_SIZE

;   DIALOG_PT = [(CURRENT_SCREEN[0] / 2.0) - (DIALOG_SIZE[0] / 2.0), $ 
;                (CURRENT_SCREEN[1] / 2.0) - (DIALOG_SIZE[1] / 2.0)] 

;   WIDGET_CONTROL, base, $
;                   TLB_SET_XOFFSET = DIALOG_PT[0], $
;                   TLB_SET_YOFFSET = DIALOG_PT[1]
   WIDGET_CONTROL, base, MAP = 1
   WIDGET_CONTROL, base2, MAP = 1
;   WIDGET_CONTROL, base3, MAP = 1
;   WIDGET_CONTROL, grismbase, MAP = 1;,sensitive=0
   WIDGET_CONTROL, drawoptionbase, MAP = 1
   WIDGET_CONTROL, pickupmodebase, MAP = 1


;widget_control,hourglass=1
;input_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type,mygetpath;idth_default,length_default
;widget_control,hourglass=0


END






;;;;;;;;
; MAIN ;
;;;;;;;;

PRO wmdp2
COMMON share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default,waveoffset_default,length_default,width_default,zero_offset
COMMON share3,red,blue,green
common widgetcom,base,pickobject,clickpoint,width_text,length_text,aperture_text,grismselect,curpos_label,draw_fov_button


R=256 & G=0 & B=0 & RED=R+(G+256L)*(B+256L)
RED=[255,255,255]
R=0 & G=256 & B=0 & GREEN=R+(G+256L)*(B+256L)
green=[128,255,128]
R=0 & G=0 & B=256 & BLUE=R+(G+256L)*(B+256L)

set_plot,'X'

;;;;;;;;;;;;;;;;;;;;;;;;
; Creating Dummy Image ;
;;;;;;;;;;;;;;;;;;;;;;;;

bin=[1,1]
objectname='Dummy';SXPAR(header,'OBJECT')
exptime=60;exptime=SXPAR(header,'EXPTIME')
naxis=[4029,4095]; naxis=SXPAR(header,'NAXIS*')
samplefac=get_samplefac(naxis[1])

maxx=naxis[0] & maxy=naxis[1]
xoffset=0 & xend=maxx & yoffset=0 & yend=maxy

image = make_array( dimen = naxis, /FLOAT )
expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2

;
; Read Dummy Header Information
;
GET_LUN,U
openr,U,'/home/ohyama/FOCASRED/DATA/DUMMY.FITS'
mrd_hread,U,header,status
CLOSE,U & FREE_LUN,U
extast,header,wcsinfo,nparms
wcsinfo.crval[0]=0d
wcsinfo.crval[1]=0d
wcsinfo.crpix[0]=1d
wcsinfo.crpix[1]=1d
wcsinfo.cdelt[0]=1.
wcsinfo.cdelt[1]=1.
wcsinfo.cd[0,0]=0.
wcsinfo.cd[1,1]=0.
wcsinfo.cd[0,1]=0.1038/3600.
wcsinfo.cd[1,0]=-0.1038/3600.
;
; Dummy setting of slit parameters
;
width_default=0
length_default=0
holediameter=0

length_default=100
width_default=10
holediamter=20


;;;;;;;;;;;;;;;;
; GUI Building ;
;;;;;;;;;;;;;;;;

create_gui,xend,yend,holediameter,win,win2

;
; Paramter Initialize
;

num=1; Dummy

delid=-1
goodid=indgen(num)

slit_space=0
pickupbox_size=100
yohaku=5
holediameter=2.0*10./bin[1]/samplefac; default 2 arcsec in diameter

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan


r=3.*60/abs(wcsinfo.cd[0,1]*3600.); 3 arcmin FOV in pix (default for FOCAS)
r2=90/(0.015/beta)

xFOVcen=XMaskCenter; XRotatorCenter
yFOVcen=YMaskCenter; YRotatorCenter

pSave = !P
xSave = !X
ySave = !Y

;
; GRISM INITIALIZE (DEFAULT=150)
;
set_grism,num,base,grismselect


wset,win
;imdisp,sigrange(image2,fraction=0.95,range=range),margin=0
range=[0,1]
; Do not show slit at first
;draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win

;catch,error_status
;if error_status NE 0 then begin
;	print,'The following error happened, and recovered.'
;	print,!ERR_STRING
;endif


;
; FLAGS
;
flag_draw_fov=1
flag_display_slit_id=1
flag_pickupmode=1
flag_readmdp=0

;
; Get the event, without using XMANAGER
;
NEXT:

;win=win0 & win2=win02
event = WIDGET_EVENT (base)
WIDGET_CONTROL, event.id, GET_VALUE = value

;
; Mouse (X, Y), Zoom around clicked pos.
;
IF tag_names(event,/structure_name) EQ 'WIDGET_DRAW' then begin
	widget_control,curpos_label,set_value='('+strtrim(string(event.x*samplefac),2)+', '+strtrim(string(event.y*samplefac),2)+')'
	if event.press EQ 1 then begin
		wset,win2
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,event.x*samplefac-pickupbox_size,event.y*samplefac-pickupbox_size,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

		print,event.x,event.y
		print,event.x*samplefac*bin[0]-pickupbox_size+xoffset,event.y*samplefac*bin[1]-pickupbox_size+yoffset

		samplefac_old=samplefac
		samplefac=1

		IF flag_readmdp NE 0 then begin
			calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,event.x*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,event.y*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
			width_zero=width[goodid]/2
			width_zero=20/bin[1]/samplefac
			tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid]
			tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],red
			tvbox2,length[goodid]/2,width_zero[goodid],xcen[goodid],ycen3[goodid],green
			if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2

			samplefac=samplefac_old
			calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
		ENDIF

		samplefac=samplefac_old

	wset,win
	ENDIF
	goto,next
endif

IF (value EQ 'Pickup Object') THEN begin
	IF event.select EQ 1 then begin
		flag_pickupmode=1
		print,flag_pickupmode
	endif

	GOTO,NEXT
END

IF (value EQ 'Click Point') THEN begin
	IF event.select EQ 1 then begin
		flag_pickupmode=0
		print,flag_pickupmode
	endif
	GOTO,NEXT
END


IF (value EQ 'Redraw') THEN begin
	wset,win
	widget_control,hourglass=1
	tv,bytscl(image2,min=range[0],max=range[1])
	IF flag_readmdp NE 0 then begin
 		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
	END
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2
	widget_control,hourglass=0
	goto,NEXT
END

IF (value EQ 'Print') THEN begin
	PRINT,'Print IS SELECTED'
;	wset,win


	fileName = DIALOG_PICKFILE (/WRITE, FILTER = '*.ps', DIALOG_PARENT = base)
	IF (fileName NE '') THEN BEGIN

	d = FINDFILE (fileName, COUNT = fileExists)
	IF (fileExists) THEN BEGIN
         IF (DIALOG_MESSAGE (/QUESTION, ['File ' + fileName + ' exists.', $
	     'Overwrite?'], DIALOG_PARENT = event.top) EQ 'No') THEN $
            GOTO, NEXT
	ENDIF

	temp=!D
	temp.name='PS'

	plot,[0],[0],xrange=[0,temp.x_size],yrange=[0,temp.y_size],xmargin=[0,0],ymargin=[0,0]

	deviceSave = !D.NAME
	SET_PLOT, 'PS';,x_size=temp.x_size,y_size=temp.y_size,x_vsize=temp.x_vsize,y_vsize=temp.y_vsize
	DEVICE, FILE = fileName

;	formInfo = cmps_form(Cancel=canceled, Create=create)
	thisDevice = !D.Name
;	Set_Plot, "PS"
;	Device, _Extra=formInfo

;	imdisp,bytscl(image2,min=range[0],max=range[1]),margin=0
	tv,bytscl(image2,min=range[0],max=range[1])
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid],/data
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],red,/data
; 	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win,/printout,/data
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2,/printout
	if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid,/printout

	device,/close
	SET_PLOT, deviceSave
	ENDIF
 	goto,NEXT
END

IF (value EQ 'Change Intensity Scale') then begin
	wset,win
	range=dialog_input(prompt=["MIN","MAX"],nfields=2,initial=range,dialog_parent=base)
	IF(n_elements(range) NE 2) THEN GOTO,NEXT
	widget_control,hourglass=1
	imdisp,bytscl(image2,min=range[0],max=range[1]),margin=0
	IF flag_readmdp NE 0 then begin
		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
	END
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2
	widget_control,hourglass=0
	goto,NEXT
END

if (value EQ 'Auto Intensity Scale') then begin
	wset,win
	widget_control,hourglass=1
	imdisp,sigrange(image2,fraction=0.95,range=range),margin=0
	IF flag_readmdp NE 0 then begin
		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
		if flag_display_slit_id THEN display_slit_id,x1,x2,y1,y2,goodid
	END
	if flag_draw_fov then draw_fov,xFOVcen,yFOVcen,r,r2
	widget_control,hourglass=0
	goto,NEXT
END

IF value EQ 'Draw Slit' then begin
	IF flag_readmdp NE 0 then begin
		widget_control,hourglass=1
		draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
		widget_control,hourglass=0
	END
	goto,NEXT
END


if value EQ 'Show Nearest Slit' then BEGIN
	IF flag_readmdp NE 0 then GOTO,NEXT
	wset,win
	get_nearest_slit,xcen,ycen,id,win
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	draw_slit_id,length,width,xcen,ycen,id
	xnear=xcen[id] & ynear=ycen[id]
	print,'Slit ID= ',id
	wset,win2

	start_x=xnear[0]*samplefac-pickupbox_size & start_y=ynear[0]*samplefac-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[xnear[0]*samplefac-pickupbox_size > 0:xnear[0]*samplefac+pickupbox_size,ynear[0]*samplefac-pickupbox_size > 0:ynear[0]*samplefac+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1

	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
	width_zero=width[goodid]/2
	width_zero=20/bin[1]/samplefac
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],red
	tvbox2,length[goodid]/2,width_zero[goodid],xcen[goodid],ycen3[goodid],green
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	wset,win
	print,x1[id],x2[id],format='("Left, Right=",2F10.2)'

	xy2ad, (x1+y1)[id]/2, (y1+y2)[id]/2, wcsinfo, a, d
	print,adstring(a,d,1)
	goto,NEXT
END

if value EQ 'Show Slit(ID)' then BEGIN
	IF flag_readmdp EQ 0 then GOTO,NEXT
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input',dialog_parent=base))
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	xnear=xcen[id] & ynear=ycen[id]
	print,'Slit ID= ',id
	wset,win2
	start_x=xnear[0]*samplefac-pickupbox_size & start_y=ynear[0]*samplefac-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[xnear[0]*samplefac-pickupbox_size:xnear[0]*samplefac+pickupbox_size,ynear[0]*samplefac-pickupbox_size:ynear[0]*samplefac+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
	samplefac=samplefac_old
	width_zero=width[goodid]/2
	width_zero=20/bin[1]/samplefac
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],red
	tvbox2,length[goodid]/2,width_zero[goodid],xcen[goodid],ycen3[goodid],green
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	wset,win
	print,x1[id],x2[id],format='("Left, Right=",2F10.2)'
	dummy=dialog_message("Slit ID="+strtrim(string(id),2)+" : ["+strtrim(string(x1[id]),2)+":"+strtrim(string(x2[id]),2)+"] | [Left:Right]",/information)

	xy2ad, (x1+y1)[id]/2, (y1+y2)[id]/2, wcsinfo,a, d
	print,adstring(a,d,1)
	goto,NEXT
END

if value EQ 'Del Nearest Slit' then BEGIN
	IF flag_readmdp EQ 0 then GOTO,NEXT
	wset,win
	get_nearest_slit,xcen,ycen,id,win
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	draw_slit_id,length,width,xcen,ycen,id
	add_delid,delid,id
	make_id,delid,goodid,x1
	goto,NEXT
END

IF value EQ 'Add Slit by Click' then BEGIN
	wset,win
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	wset,win2
	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

;	flag2=dialog_menu(['Pick Object','Click Point'],title='How to select the object?',dialog_parent=base)
	IF flag_pickupmode EQ 0 then begin
;	case flag2 of
;		'Click Point': begin
		CURSOR,tmp_x,tmp_y,/device
		click3=fltarr(2)
		click3[0]=tmp_x & click3[1]=tmp_y
		click3[0]=click3[0]-pickupbox_size+click2[0]
		click3[1]=click3[1]-pickupbox_size+click2[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	ENDIF ELSE BEGIN
;		'Pick Object': begin
		CURSOR,tmp_x,tmp_y,/device
		click3=fltarr(2)
		click3[0]=tmp_x-pickupbox_size+click2[0] & click3[1]=tmp_y-pickupbox_size+click2[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
		result=gauss2dfit(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],a)
		click3[0]=a[4]-pickupbox_size+click3[0] & click3[1]=a[5]-pickupbox_size+click3[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

		ENDELSE
;	endcase

	tvbox2,length_default*samplefac/2,width_default*samplefac/2,pickupbox_size,pickupbox_size
	ycen3=click3[1]+waveoffset
	tvbox2,length_default/2*samplefac,wavecoveradge*samplefac/2,pickupbox_size,pickupbox_size,[255,255,255]

	wset,win

	x1=[x1,click3[0]*bin[0]-length_default/2*bin[0]*samplefac]
	x2=[x2,click3[0]*bin[0]+length_default/2*bin[0]*samplefac]
	y1=[y1,click3[1]*bin[1]-width_default/2*bin[1]*samplefac]
	y2=[y2,click3[1]*bin[1]+width_default/2*bin[1]*samplefac]
	width=[width,width_default]
	length=[length,length_default]
	wavecoveradge=[wavecoveradge,wavecoveradge_default]
	priority=[priority,3]
	type=[type,0]; 0 mean slit
	object=[object,'Newly Added Slit']
	make_id,delid,goodid,x1
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	flag_readmdp=1
	goto,NEXT
END

if value EQ 'Zoom Around Mouse' then BEGIN
	wset,win
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	xnear=click2[0] & ynear=click2[1]
	wset,win2

	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
	samplefac=samplefac_old
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],red
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	wset,win
	goto,NEXT
END

IF value EQ 'Add Alignment Hole' then BEGIN
	wset,win
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	wset,win2

	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

	CURSOR,tmp_x,tmp_y,/device
	click3=fltarr(2)
	click3[0]=tmp_x-pickupbox_size+click2[0] & click3[1]=tmp_y-pickupbox_size+click2[1]

	start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	result=gauss2dfit(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],a)
	click3[0]=a[4]-pickupbox_size+click3[0] & click3[1]=a[5]-pickupbox_size+click3[1]

	print,'Exposure Time',exptime
	print,'Sky Level, Sky Count Rate',a[0],a[0]/exptime
	print,'Peak Count, Peak Count Rate',a[1],a[1]/exptime
	print,'Seeing (arcsec in FWHM for X & Y)',a[2]*2.355,a[3]*2.355

	tvbox2,holediameter*samplefac/2,holediameter*samplefac/2,pickupbox_size,pickupbox_size
	ycen3=click3[1]+waveoffset*samplefac
	tvbox2,holediameter*samplefac/2,wavecoveradge*samplefac/2,pickupbox_size,pickupbox_size,red

	wset,win

	x1=[x1,click3[0]*bin[0]-holediameter*samplefac/2*bin[0]]
	x2=[x2,click3[0]*bin[0]+holediameter*samplefac/2*bin[0]]
	y1=[y1,click3[1]*bin[1]-holediameter*samplefac/2*bin[0]]
	y2=[y2,click3[1]*bin[1]+holediameter*samplefac/2*bin[0]]
	width=[width,width_default]
	length=[length,length_default]
	wavecoveradge=[wavecoveradge,wavecoveradge_default]
	priority=[priority,0]
	make_id,delid,goodid,x1
	id=n_elements(x1)-1
	length[id]=holediameter
	width[id]=length[id]
	type=[type,1]; 1 means hole
	object=[object,'Alignment Hole']
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	flag_readmdp=1

goto,NEXT
END

if value EQ 'Change Slit Length' then begin
	IF flag_readmdp EQ 0 then GOTO,NEXT
	get_nearest_slit,xcen,ycen,id,win
	wset,win
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	draw_slit_id,length,width,xcen,ycen,id
	newx12=dialog_input(prompt=["Left","Right"],nfields=2,initial=[x1[id],x2[id]],dialog_parent=base,title='Set Slit Pos.')
	if n_elements(newx12) NE 2 then	GOTO,NEXT
	x1[id]=newx12[0] & x2[id]=newx12[1]
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	goto,NEXT
END

if value EQ 'Save SBR (For Distortion Corrected Image)' then begin
	write_sbr_wcs,      abs(wcsinfo.cd[0,1]*3600.),x1,y1,x2,y2,xFOVcen,yFOVcen,width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid
	goto,NEXT
END

if value EQ 'Save SBR (CCD)' then begin
	write_sbr_ccd,x1,y1,x2,y2,xFOVcen,yFOVcen, width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid
	goto,NEXT
END

if value EQ 'Save MDP' then begin
	write_mdp,x1,y1,x2,y2,xFOVcen,yFOVcen, width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid,priority,object
	goto,NEXT
END

if value EQ 'Save SBR (For Distortion UN-Corrected Image)' then begin
	write_sbr_trans,x1,y1,x2,y2, width*bin[1]*samplefac,holediameter*bin[1]*samplefac,type,delid
	goto,NEXT
END

if value EQ 'Save Ascii Extension' then begin
	write_aext,x1,y1,x2,y2,type,object,delid,header
	goto,NEXT
END


if value EQ 'Read FITS Image' then begin
	widget_control,hourglass=1
	readfits,image,image2,objectname,naxis,bin,exptime,header,samplefac,wcsinfo,mygetpath
	WIDGET_CONTROL, base, /DESTROY
	create_gui,naxis[0],naxis[1],holediameter,win,win2
	widget_control,hourglass=0
	goto,NEXT
END


;'Change Window Size': begin
;	pickupbox_size=float(dialog_input(prompt='Pickup Box Size',nfields=1,initial=pickupbox_size),dialog_parent=base)
;	window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2
;END

if value EQ 'Automatic Slit Width Expantion' then begin
	IF flag_readmdp EQ 0 then GOTO,NEXT
	x2_good=x2[goodid]
	x1_good=x1[goodid]
	newx2=x2_good

	for j=0,n_elements(x1[goodid])-1 do begin
		newid=where(x1_good GT x2_good[j])

;		x1_new_temp=min(x1_good[newid])
;		x1_good_sort=sort(x1_good_sort)
;		newid_tmp=where(x1_good EQ x1_new_temp)
;		newid_tmp2=min(where(x1_good_sort GT x1_new_temp)_
;		if (y2[newid_tmp] LT y1[newid_tmp2]) OR (y1[newid_tmp] GT y1[newid_tmp2]) then newid=newid_tmp2 else newid=newid_tmp
		
		if min(newid) NE -1 then newx2[j]=min(x1_good[newid]) else newx2[j]=x2_good[j]
		if type[j] EQ 1 then newx2[j]=x2_good[j]
	endfor
	x2[goodid]=newx2-(slit_space+1)
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	goto,NEXT
END

if value EQ 'Slit Overlap Check' then begin
	IF flag_readmdp NE 0 then GOTO,NEXT
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,ycen3,xoffset,yoffset
	flag3=0
	for j=0,n_elements(x1)-1 do begin
		if max(delid EQ j) EQ 1 then goto,skiploop_j
		for i=0,n_elements(x1)-1 do begin
			if max(delid EQ i) EQ 1 then goto,skiploop_i
			if (x1[j] GT x1[i]) and (x1[j] LT x2[i]) and ((ycen2-wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2-wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
			if (x2[j] GT x1[i]) and (x2[j] LT x2[i]) and ((ycen2-wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2-wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
			if (x1[j] GT x1[i]) and (x1[j] LT x2[i]) and ((ycen2+wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2+wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
			if (x2[j] GT x1[i]) and (x2[j] LT x2[i]) and ((ycen2+wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2+wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
				pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
			skiploop_i:
		endfor
		skiploop_j:
	endfor
	make_id,delid,goodid,x1
	if flag3 EQ 0 then print,'OK'
	goto,NEXT
END

if value EQ 'Show Slit List' then begin
	IF flag_readmdp EQ 0 then GOTO,NEXT
	make_id,delid,goodid,x1
	num=n_elements(x1)
	list=string(indgen(num))
	types=strarr(num)
	types[*]='S'
	holeid=where(type EQ 1)
	if size(holeid,/n_dimensions) NE 0 then types[holeid]='H'
	list2=strtrim(list,2) + ' ' + types+'('+strtrim(string((x1+x2)/2),2)+','+strtrim(string((y1+y2)/2),2)+')'+' ' + object
	result=dialog_checklist(list2,/nonexclusive,initial=goodid,/scroll,y_scroll_size=800,x_scroll_size=500,xposition=100,yposition=100,dialog_parent=base)
	if total(result) EQ 0 then goto,jump_cancel
	delid=where(fix(result) EQ 0)
	make_id,delid,goodid,x1
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	jump_cancel:
	goto,NEXT
END


if value EQ 'Draw FOV' then begin
	IF event.select EQ 1 then begin
		xyr=dialog_input(prompt=["Xcen (pix)","Ycen (pix)","r (arcmin)"],nfields=3,initial=[xFOVcen,yFOVcen,r/60.*abs(wcsinfo.cd[0,1]*3600.)],dialog_parent=base)
		IF n_elements(xyr) NE 3 THEN GOTO,NEXT
		xFOVcen=float(xyr[0])
		yFOVcen=float(xyr[1])
		r=float(xyr[2])*60./abs(wcsinfo.cd[0,1]*3600.)
		wset,win
		draw_fov,xFOVcen,yFOVcen,r,r2
		flag_draw_fov=1
	ENDIF ELSE BEGIN
		flag_draw_fov=0
	ENDELSE
	goto,NEXT
END

if value EQ 'Change Default Parameters' then begin
	set_params,pickupbox_size,holediameter,slit_space,xoffset,yoffset,n_elements(x1),yohaku,width_text,aperture_text,length_text
	goto,NEXT
END

if value EQ 'Grism Select' then begin
	set_grism,n_elements(x1),base,grismselect

	IF flag_readmdp EQ 0 then GOTO,NEXT
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,win
	goto,NEXT
END

if value EQ 'Read MDP file' then begin
	input_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type;,width_default,length_default
	; Reset mask information
	num=n_elements(x1)
	delid=-1
	goodid=indgen(num)
	make_id,delid,goodid,x1
	flag_readmdp=1
	goto,NEXT
END

if value EQ 'Read MDP (RAD-EC) file' then begin
	input_mdp_radec,wcsinfo,x1,y1,x2,y2,length,width,priority,object,naxis,type;,width_default,length_default
	; Reset mask information
	num=n_elements(x1)
	delid=-1
	goodid=indgen(num)
	make_id,delid,goodid,x1
	flag_readmdp=1
	goto,NEXT
END

if value EQ 'Mark RA DEC' then begin
	result=dialog_input(prompt=["Hour",'Min','Sec','Deg','Min','Sec'],nfield=6,dialog_parent=base)
	if n_elements(result) NE 6 then GOTO,NEXT
	hh=float(result[0])
	mm=float(result[1])
	ss=float(result[2])
	dhh=float(result[3])
	dmm=float(result[4])
	dss=float(result[5])

	dec=ten(dhh,dmm,dss)
	ra=ten(hh,mm,ss)*15.

	ad2xy,ra,dec,wcsinfo,x,y
	print,x,y
	draw_ellipse,x/samplefac,y/samplefac,100/samplefac,100/samplefac,resolution=10,/device
	goto,NEXT
END


if value EQ 'Set FOV Center (RA DEC)' then begin

	xy2ad,XFOVCEN,YFOVCEN,wcsinfo,a,d
	s=strsplit(adstring(a,d,1),/extract)
	hhc=float(s[0]) & mmc=float(s[1]) & ssc=float(s[2]) & dhhc=float(s[3]) & dmmc=float(s[4]) & dssc=float(s[5])
;	print,hhc,mmc,ssc,dhhc,dmmc,dssc
	result=dialog_input(prompt=["Hour",'Min','Sec','Deg','Min','Sec','arcsec/pix'],initial=[hhc,mmc,ssc,dhhc,dmmc,dssc,wcsinfo.cd[0,1]*3600],nfield=7,dialog_parent=base,title='FOV Center Coordinate')
        if n_elements(result) NE 7 then goto,NEXT
	wcsinfo.crval[0]=ten(float(result[0]),float(result[1]),float(result[2]))*15.
	wcsinfo.crval[1]=ten(float(result[3]),float(result[4]),float(result[5]))
	wcsinfo.crpix[0]=XFOVCEN
	wcsinfo.crpix[1]=YFOVCEN
	wcsinfo.cdelt[0]=1.;double(result[6])/3600.
	wcsinfo.cdelt[1]=1.;double(result[6])/3600.
	wcsinfo.cd[0,0]=0;
	wcsinfo.cd[1,1]=0;double(result[6])/3600.
	wcsinfo.cd[0,1]=double(result[6])/3600.
	wcsinfo.cd[1,0]=-double(result[6])/3600.

xy2ad,XFOVCEN,YFOVCEN,wcsinfo,a,d
PRINT,adstring(a,d,1)

        ; This wcs is valid only for PA=0
	goto,NEXT
END

if value EQ 'Show WCS Info' then begin
	xy2ad,XFOVCEN,YFOVCEN,wcsinfo,a,d
	s=strsplit(adstring(a,d,1),/extract)
	hhc=float(s[0]) & mmc=float(s[1]) & ssc=float(s[2]) & dhhc=float(s[3]) & dmmc=float(s[4]) & dssc=float(s[5])
	print,'FOV Center Ra Dec (CRVAL)',hhc,mmc,ssc
        print,dhhc,dmmc,dssc
	print,'FOV Center X Y (CRPIX)',XFOVCen,YFOVCen
	print,'arcsec/pix (CDELT)',wcsinfo.cd[0,1]*3600.
	goto,NEXT
END


if value EQ 'Mark RA DEC List' then begin
	
	read_radec,ra,dec
	if n_elements(ra) EQ 0 then GOTO,NEXT
	ad2xy,ra,dec,wcsinfo,x,y

	for j=0,n_elements(ra)-1 do draw_ellipse,x[j]/samplefac,y[j]/samplefac,20/samplefac,20/samplefac,resolution=10,/device
	for j=0,n_elements(ra)-1 do xyouts,x[j]/samplefac,y[j]/samplefac,strtrim(string(j),2),/device,charsize=1.5
	goto,NEXT
END


if value EQ 'Change Color Table' then begin
	table=fix(dialog_input(prompt=["Color table number (1-40)"],dialog_parent=base))
	if n_elements(table) NE 1 then GOOT,NEXT
	loadct,table
	goto,NEXT
END


if value EQ 'Display Slit ID' then begin
	IF flag_readmdp EQ 0 then GOTO,NEXT
	IF event.select EQ 1 then begin
		display_slit_id,x1,x2,y1,y2,goodid
;		xyouts,(x2/samplefac/bin[0])[goodid],(y1/samplefac/bin[1])[goodid],(strtrim(string(indgen(n_elements(x1))),2))[goodid],/device,charsize=1.5
		flag_display_slit_id=1
	ENDIF ELSE BEGIN
		flag_display_slit_id=0
	ENDELSE
	GOTO,NEXT
END



if value EQ 'Show Spectrum' then begin
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input'),dialog_parent=base)
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	show_spectrum,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image2,id,range
	goto,NEXT
END

if value EQ 'Show All Spectra' then begin
		show_spectra_all,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,range
END

if value EQ 'Reduce Spectrum(ID)' then begin
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input'),dialog_parent=base)
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	reduce_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,id,range,naxis,yohaku
	goto,NEXT
END


IF (value EQ '75') THEN begin
	GOTO,NEXT
END

IF (value EQ '150') THEN begin
	GOTO,NEXT
END

IF (value EQ '300B') THEN begin
	GOTO,NEXT
END

IF (value EQ '300R-Y47') THEN begin
	GOTO,NEXT
END

IF (value EQ '300R-O58') THEN begin
	GOTO,NEXT
END


IF VALUE EQ 'Quit' THEN BEGIN
	result=dialog_message('Do you really want to quit?',/question)
	if result EQ 'Yes' then begin
		WIDGET_CONTROL, base, /DESTROY
		goto,ending
	endif else begin	
		goto,NEXT
	ENDELSE
END


ERROR:

!P = pSave & !X = xSave & !Y = ySave

WSET, winSave

;
; End
;

ENDING:
message,'Finish'

END
