pro suboverscan_hpk,inarr,outarr,chip,XBIN=xbin

if not keyword_set(xbin) then xbin=1
s = size(inarr)

if s[0] EQ 2 then begin                    ; Input array size.    
	if (xbin EQ 1) THEN ncol=2048 $
	else if (xbin EQ 2) THEN ncol=1024 $
	else begin
		print,'unknown binning factor! :',xbin
		message,'Error!'
	end
	nrow = s[2]
	outarr = make_array(dimen = [ncol,nrow], /NOZERO, TYPE = float )

	if chip EQ 1 then begin
		if xbin EQ 1 then begin
			data_region=[[9,520],[553,1064],[1081,1592],[1626,2137]]
			ovs_region=[[521,535],[538,552],[1593,1607],[1611,1625]]
			output_region=[[1,512],[513,1024],[1025,1536],[1537,2048]]
		endif else begin
			data_region=[[5,260],[293,548],[557,812],[846,1101]]
			ovs_region=[[261,275],[278,292],[813,827],[830,844]]
			output_region=[[1,256],[257,512],[513,768],[769,1024]]
		endelse
		gain=[2.081,2.047,2.111,2.087]
	endif else begin
		if xbin EQ 1 then begin
			data_region=[[9,520],[553,1064],[1081,1592],[1626,2137]]
			ovs_region=[[521,535],[538,552],[1593,1607],[1610,1624]]
			output_region=[[1,512],[513,1024],[1025,1536],[1537,2048]]
		endif else begin
			data_region=[[5,260],[293,548],[557,812],[846,1101]]
			ovs_region=[[261,275],[278,292],[813,827],[830,844]]
			output_region=[[1,256],[257,512],[513,768],[769,1024]]
		endelse
		gain=[2.105,1.968,1.999,1.918]
	endelse

	; change image origin to 0
	data_region=data_region-1
	ovs_region=ovs_region-1
	output_region=output_region-1

	for j=0,nrow-1 do begin
		for ch=0,3 do begin
			;outarr[*,j]=inarr[*,j]-median(inarr[ncol-FIX((overscan-5)/xbin):FIX(ncol-5/xbin),j-5 > 0:j+5 < nrow-1])
			mval = mean(inarr[ovs_region[0,ch]:ovs_region[1,ch],j-9 > 0:j+9 < nrow-1], /DOUBLE )
			outarr[output_region[0,ch]:output_region[1,ch],j] = $
				( inarr[data_region[0,ch]:data_region[1,ch],j] - mval ) * gain[ch]
		endfor
	endfor

endif

end

