pro stat_timeseries

filename='/wa51a/ohyamayi/M82/*.fits'
filename='/home/ohyama/grpscr/FLATS/D*.fits'
filename='/home/falcon/FITS/FCSA0*[1,3,5,7,9].fits'
filename='/data2/yoshida/FCSA0*[1,3,5,7,9].fits'
fil = findfile( filename, COUNT = nfiles)

if nfiles EQ 0 then message,'No files found'
name=strarr(nfiles)
data_typ=strarr(nfiles)
dom_tmp=fltarr(nfiles)
mjd=fltarr(nfiles)
overscan=fltarr(nfiles)
fil02=strarr(nfiles)
pa=fltarr(nfiles)
al=fltarr(nfiles)
exp=fltarr(nfiles)
insrot=fltarr(nfiles)
overscanrms=fltarr(nfiles)
meancount=fltarr(nfiles)

for nf = 0, nfiles-1, 1 do begin
	header=headfits(fil[nf])
	data_typ[nf] = SXPAR( header ,'DATA-TYP')
	name[nf]=SXPAR( header ,'OBJECT')
	dom_tmp[nf]=float(SXPAR( header ,'DOM-TMP'))
	mjd[nf]=float(SXPAR( header ,'MJD'))
	fil02[nf]=SXPAR( header ,'FILTER02')
	pa[nf]=SXPAR(header,'INST-PA')
	al[nf]=SXPAR(header,'ALTITUDE')
	exp[nf]=SXPAR(header,'EXPTIME')
	insrot[nf]=SXPAR(header,'INST-PA')
	image=mrdfits(fil[nf],0,/fscale,/silent)
	overscan[nf]=mean(image[2000:2040,50:3950])
	overscanrms[nf]=sigma(image[2000:2040,50:3950])
	meancount[nf]=mean(image[100:800,50:3950])
	print,fil[nf],' ',data_typ[nf],' ',exp[nf],' ',meancount[nf],' ',overscan[nf],' ',overscanrms[nf]
endfor
;print,fil[sort(name)],name[sort(name)],data_typ[sort(name)]

bias_list=fil(where(DATA_TYP EQ   'BIAS    '))

flat_list=fil(where(DATA_TYP EQ   'FLAT    '))
flat_namelist=name(where(DATA_TYP EQ   'FLAT    '))

object_list=fil(where(DATA_TYP EQ 'OBJECT  '))
object_namelist=name(where(DATA_TYP EQ   'OBJECT  '))

hartmann_list=fil(where(NAME EQ   'HARTMANNTEST'))

domeflat_list=fil(where(flat_namelist EQ 'DOMEFLAT'))



comp_list=fil(where(DATA_TYP EQ   'COMP    '))

message,'Finish!'
end
