pro specflat_engine,image,imagewhole,refimage,refimagewhole,chip,ptpimage,slitpattern,image_ptp,$
	startx,endx,starty,endy,startx_tr,endx_tr,starty_tr,endy_tr,xbin,ybin,X_CEN,Y_CEN,maxx,maxy, $
	GRISMROTFLAG=grismrotflag,AFTERCCDFORMATCHANGE=afterccdformatchange

;IF not keyword_set(grismrotflag) THEN grismrotflag=0
;IF not keyword_set(afterccdformatchange) THEN afterccdformatchange = 1

s=size(image)
naxis=intarr(2)
naxis[0]=s(1)
naxis[1]=s(2)

sr=size(refimage)
naxis_ref=fltarr(2)
naxis_ref[0]=sr(1)
naxis_ref[1]=sr(2)

sf=size(imagewhole)
naxis_whole=fltarr(2)
naxis_whole[0]=sf(1)
naxis_whole[1]=sf(2)
;
; Lamp spec pattern
;
spec1d=fltarr(naxis[1])
for i=0,naxis[1]-1 do begin
	meanclip,image[*,i],meanvalue,3
	spec1d[i]=meanvalue > 1.
endfor

spec1d_whole=fltarr(naxis_whole[1])
for i=0,naxis_whole[1]-1 do begin
	meanclip,imagewhole[startx:endx,i],meanvalue,3
	spec1d_whole[i]=meanvalue > 1.
endfor

specnorm=image
for j=0,naxis[0]-1 do specnorm[j,*]=image[j,*]/spec1d[*]

specnormwhole=imagewhole
for j=0,naxis_whole[0]-1 do specnormwhole[j,*]=imagewhole[j,*]/spec1d_whole[*]

refspecnorm=refimage
for j=0,naxis_ref[0]-1 do refspecnorm[j,*]=refimage[j,*]/spec1d[*]

refspecnormwhole=refimagewhole
for j=0,naxis_whole[0]-1 do refspecnormwhole[j,*]=refimagewhole[j,*]/spec1d_whole[*]
;
; Get PTP pattern
;
;window,11,xsize=1000,title='Slit pattern plots'
ptpimage_min=specnorm
ptpimage=specnormwhole
maxsubregion=1; was 5
for k=0,maxsubregion-1 do begin
	regstart=FIX(naxis[1]*k/maxsubregion) & regend=FIX(naxis[1]*(k+1)/maxsubregion-1)
	localslitpattern=fltarr(naxis[0])
	for j=0,naxis[0]-1 do localslitpattern[j]=meanclip_func(specnormwhole[startx+j,regstart+starty:regend+starty],3)

	lowfreqslit=fltarr(naxis[0])
	length= min([100,naxis[0]-1])
	lowfreqslit=lowess(findgen(naxis[0]),localslitpattern,length,1)
;	lowfreqslit=medsmooth(slitpattern,20)
;	plot,lowfreqslit,yrange=[0.90,1.10] & oplot,localslitpattern,psym=10

	truelocalslitpattern=localslitpattern/lowfreqslit; slit pattern, shift while flexture
;	oplot,truelocalslitpattern;,yrange=[0.95,1.01]

	for i=regstart,regend do ptpimage_min[*,i]=specnorm[*,i]/truelocalslitpattern; ptp pattern, fixed to CCD
endfor; for k loop
;
; Avoid bad pixels
;
;ptpimage_min[where(ptpimage_min GT 1.3 or ptpimage_min LT 0.7)]=1.

window,/free,xsize=naxis[0],ysize=naxis_whole[1],title='PTP flat image'
imdisp,sigrange(ptpimage_min,fraction=0.99),margin=0
winid_ptp=!D.WINDOW

for k=0,endx-startx do ptpimage[k+startx,starty:endy]=ptpimage_min[k,*]
;imdisp,sigrange(ptpimage),margin=0

specnormwholeptp=specnormwhole/ptpimage

distcalib_engine_spec,   specnormwholeptp,   specnormdist,chip,0.,0.,startx_tr,endx_tr,starty_tr,endy_tr,xbin,ybin,$; was startx_tr,endx_tr,starty_tr,endy_tr
	SUBOVERSCANFLAG=0,FLUXCONSERVEFLAG=0,CONVOLVEFLAG=0,AFTERCCDFORMATCHANGE=afterccdformatchange

if GRISMROTFLAG then begin
	if afterccdformatchange then gap=414*3/xbin else gap=206*3/xbin; was 255
	startx_gap=gap-40
	endx_gap=gap+40
	distcalib_engine_spec,refspecnormwhole,refspecnormdist,chip,0.,0.,startx_gap,endx_gap,starty_tr,endy_tr,xbin,ybin,$
		SUBOVERSCANFLAG=0,FLUXCONSERVEFLAG=0,CONVOLVEFLAG=0,AFTERCCDFORMATCHANGE=afterccdformatchange
	grismrot,specnormwholeptp,refspecnormdist,specnormdistrot,[xbin,ybin],chip,startx_tr,endx_tr,starty_tr,endy_tr,startx_gap,endx_gap,X_CEN,Y_CEN,maxx,maxy,$; was startx_tr,endx_tr,starty_tr,endy_tr
		AFTERCCDFORMATCHANGE=afterccdformatchange
endif else begin
	specnormdistrot=specnormdist
endelse

get_slitpattern,specnormdistrot[*,naxis[1]*1/5:naxis[1]*4/5],slitpattern,medianmod=0
window,/free,title='Slit Pattern Plot'
winid_slitpattern=!D.WINDOW
plot,slitpattern,yrange=[0.90,1.10],title='Slitpattern plot'

goto,finish

specnormslitcor=specnorm
for i=ystart,yend do specnormslitcor[*,i]=specnorm[*,i]/trueslitpattern[*]
;
; Get Slit Illumination
;
minarray=frebin(specnormslitcor,FIX(1701/30),FIX(3201/60))
fit=rob_mapfit(minarray,5)
largefit=frebin(fit,1701,3201)
largefitsmooth=smooth(largefit,120)

finish:
;wdelete,11
wdelete,winid_ptp
wdelete,winid_slitpattern
end
