pro specflat

read_fits,image,header,dir='/data2/ohyama/IRAS/';,dir='/export/scr/home/falcon/FITS'
naxis= SXPAR( header,'NAXIS*')

imagebc=image-mean(image[1975/3:2040/3,50/2:1950/2])

xstart=0/3 & xend=1700/3
;xstart=300/3 & xend=2000/3
ystart=0/2 & yend=naxis[1]-1;3200/2
image2=imagebc[xstart:xend,ystart:yend]

;message,'Finish'
;
; Remove spec feature
;
spec1d=fltarr(yend-ystart+1)
for i=0,yend-ystart do begin
meanclip,image2[50:160,i],meanvalue,3
;print,meanvalue
spec1d[i]=meanvalue
endfor

;for i=ystart,yend do spec1d[i]=median(image2[0:1000,i])

;zerospec=where(spec1d EQ 0)
;if zerospec GT 1 then spec1d(zerospec)=1.0

;spec1d=spec1d/float(xend-xstart+1)

specnorm=image2
for j=0,xend-xstart do specnorm[j,*]=image2[j,*]/spec1d
imdisp,sigrange(specnorm)


;
; Get slit pattern
;
maxsubregion=5
for,k=0,maxsubregion-1 do begin

	slitpattern=fltarr(xend-xstart+1)
	for j=0,xend-xstart do begin
		meanclip,specnorm[j,naxis[1]*k/maxsubregion:image[1]*(k+1)/maxsubregion],meanvalue,3
	;	meanclip,specnorm[j,2500:2700],meanvalue,3
		slitpattern[j]=meanvalue
	endfor

lowfreqslit=slitpattern
lowfreqslit=lowess(findgen(1701/3),slitpattern,100,2)
;lowfreqslit=medsmooth(slitpattern,20)
plot,lowfreqslit,yrange=[0.98,1.02] & oplot,slitpattern,psym=10

trueslitpattern=slitpattern/lowfreqslit; slit pattern, shift while flexture
plot,trueslitpattern,yrange=[0.95,1.01]
;
; Get PTP flat
;
specnormslit=specnorm
for i=ystart,yend do specnormslit[*,i]=specnorm[*,i]/trueslitpattern; ptp pattern, fixed to CCD

specnormslitcor=specnorm
for i=ystart,yend do specnormslitcor[*,i]=specnorm[*,i]/trueslitpattern[*]
;
; Get Slit Illumination
;
minarray=frebin(specnormslitcor,FIX(1701/30),FIX(3201/60))
fit=rob_mapfit(minarray,5)
largefit=frebin(fit,1701,3201)
largefitsmooth=smooth(largefit,120)

message,'Finish'

imdisp,sigrange(specnormslit)
write_fits,specnormslit,header; ptp output

write_fits,specnormslitcor/largefitsmooth,header

end
