PRO specfft,XXX,YYY,count,FilenameInput=filenameinput

if keyword_set(filenameinput) EQ 0 then begin
	filename=DIALOG_PICKFILE(PATH='/home/ohyama/IDL/',filter='*.xy')
	IF(STRLEN(filename) EQ 0) THEN stop
end else begin
filename=filenameinput
endelse

X=FLTARR(4100)
Y=FLTARR(4100)
ZZ='d'

GET_LUN,U
openr,U,filename
i=0
WHILE NOT EOF(U) DO BEGIN
	READF, U, xx,yy
	X[i]=xx & Y[i]=yy
	i=i+1
ENDWHILE

XXX=FLTARR(i) & YYY=FLTARR(i)
XXX=X[0:i-1] & YYY=Y[0:i-1]
count=i
close,U
FREE_LUN,U

n=n_elements(yyy)
n21=n/2+1
f=findgen(n)
f[n21]=n21-n+findgen(n21-2)
f=f/n

yyyfft=abs(fft(yyy))
result=gaussfit(shift(f,-n21),shift(yyyfft,-n21),fitcoef,nterms=3,est=[1,0,0.2])
print,fitcoef[2]
plot,shift(f,-n21),shift(abs(fft(yyy)),-n21)
oplot,shift(f,-n21),result

logx=alog(xxx)
logx1=min(logx)
logx2=max(logx)
x=findgen(n*2)/n/2*(logx2-logx1)+logx1
interpol_yyy=interpol(yyy,logx,x)

n=n_elements(yyy)*2
n21=n/2+1
f=findgen(n)
f[n21]=n21-n+findgen(n21-2)
f=f/n

yyyfft2=abs(fft(interpol_yyy))
mmax=0.2
mmin=0.05
region2=where((shift(f,-n21) GT -mmax AND shift(f,-n21) LT -mmin) OR (shift(f,-n21) GT mmin AND shift(f,-n21) LT mmax))
result2=gaussfit((shift(f,-n21))[region2],(shift(yyyfft2,-n21))[region2],fitcoef2,nterms=3,est=[1,0,0.2])
print,fitcoef2[2]
print,(x[1]-x[0])/fitcoef2[2]*3e5/1.41/2
print,(x[1]-x[0])/fitcoef2[2]*6200*2.
plot,(shift(f,-n21))[region2],(shift(yyyfft2,-n21))[region2],xrange=[0.05,0.5]
oplot,(shift(f,-n21))[region2],result2

plot,x,interpol_yyy

message,'FINISH'
END
