pro speccalib,TRANSPOSE_COORDINATE=transpose_coordinate,SKYSUBFLAG=skysubflag,BIASSUBFLAG=biassubflag,FLATFIELDFLAG=flatfieldflag,DISPLAYFLAG=displayflag,DISTCALIBFLAG=distcalibflag

read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan


if max([keyword_set(transpose_coordinate),keyword_set(skysubflag), keyword_set(biassubflag), keyword_set(flatfieldflag), keyword_set(displayflag), keyword_set(distcalibflag)]) EQ 0 then begin
result=dialog_checklist(['Transport Coordinate','Sky Subtraction','Bias Subtraction','Flat Fielding','Imdisp Images','Distortion Corection'],/nonexclusive,title='Select Image-processing Action(s)')
if result[0] EQ 0 then transpose_coordinate = 0 else transpose_coordinate = 1
if result[1] EQ 0 then skysubflag=0 else skysubflag=1
if result[2] EQ 0 then biassubflag=0 else biassubflag=1
if result[3] EQ 0 then flatfieldflag=0 else flatfieldflag=1
if result[4] EQ 0 then displayflag=0 else displayflag=1
if result[5] EQ 0 then distcalibflag=0 else distcalibflag=1

endif else begin
IF (keyword_set(transpose_coordinate) EQ 0) THEN $
   transpose_coordinate = 0
IF (keyword_set(skysubflag) EQ 0) THEN $
   skysubflag = 0
IF (keyword_set(biassubflag) EQ 0) THEN $
   biassubflag = 0
IF (keyword_set(flatfieldflag) EQ 0) THEN $
   flatfieldflag = 0
IF (keyword_set(displayflag) EQ 0) THEN $
   displayflag = 0
IF (keyword_set(distcalibflag) EQ 0) THEN $
   distcalibflag = 0
endelse

;print,transpose_coordinate,skysubflag,biassubflag,flatfieldflag

IF distcalibflag then begin
difrot=0.01212
gapsize=71.0652
Y_shift=2.39+1.0
endif else begin
difrot=0.01225
gapsize=67.43465
Y_shift=2.4055320+1.0
endelse

;localfitsdir='/wa51z/aokikn/F1'
;localfitsdir='/wa51a/ohyamayi/M82'
;localfitsdir='/home/falcon/FITS/'
localfitsdir='/home/ohyama/grpscr/'
samplefac=5

xoffset=100 & xend=1900 & yoffset=100 & yend=3900

read_fits,image1,header,dir=localfitsdir
name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')

if biassubflag then biassub_menu,image1,image1_bs,stdbias,overscan,FITSDIR=localfitsdir $
else image1_bs=image1

image1=0

flatnorm1=-1
if flatfieldflag then flatfield_menu,image1_bs,stdbias,image1_ff,flatnorm1,FITSDIR=localfitsdir $
else image1_ff=image1_bs

print,flatnorm1

image1_bs=0

if distcalibflag then distcalib_engine,image1_ff,image1_dc $
else image1_dc=image1_ff
image1_ff=0

;if skysubflag then skysub_mmm,image1_dc,image1_ss $
;else image1_ss=image1_dc
;image1_dc=0

if displayflag then begin
	WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	imdisp,sigrange(image1_ss[xoffset:xend-xoffset,yoffset:yend],fraction=0.999)
endif


;message,'Finish'
do_nothing:

end
