pro spec_efficiency
read_standard,wl_std,flux_std,width_std,FilenameInput=filenameinput

area=!PI*(8.2*100/2)^2-!PI*(1.2*100/2)^2

window,xsize=1000
plot,wl_std,flux_std,xtitle='Wave Length',ytitle='Flux'

num_std=n_elements(wl_std)

read_spec,wl,flux,crval,crpix,cdelt

plot,wl,flux,xtitle='Wave Length',ytitle='Counts per a second'

wl_pix=findgen(n_elements(wl))
count_band=fltarr(num_std)

for j=0,num_std-1 do begin
	select_wl_pix=where((wl GT wl_std[j]-width_std[j]/2) and (wl LT wl_std[j]+width_std[j]/2))
	if N_elements(select_wl_pix) EQ 1 then count_band[j]=0 else count_band[j]=total(flux[select_wl_pix]*(-cdelt))/(width_std[j])
endfor

plot,wl_std,count_band,psym=4,xtitle='Wave Length',ytitle='Counts per a second'
oplot,wl,flux

count_per_flux_per_exptime=count_band/(flux_std/(-cdelt))
result=dialog_plot2(xdata=wl_std,ydata=count_per_flux_per_exptime,xtitle='Wave Length',ytitle='Counts per a second per a unit flux',/ps_option,psym=10)

h=6.6260755e-34 * 1e7
c=2.99792458e8
freq=c/(wl_std*1e-10)
count_per_fluxcount_per_exptime=count_band/(flux_std/(-cdelt)/(h*freq)*area)*100
result=dialog_plot2(xdata=wl_std,ydata=count_per_fluxcount_per_exptime,/ps_option,psym=10)

obj_flux=1e-15
count_per_1hour=count_per_flux_per_exptime*3600*obj_flux
noise=7.
sn_ratio=count_per_1hour/noise
plot,wl_std,sn_ratio

noise=7./2.4
sn_required=5
flux_limit=sn_required*noise/(count_per_flux_per_exptime*3600)
result=dialog_plot2(xdata=wl_std,ydata=flux_limit,/ps_option,/ylog,yrange=[1e-20,1e-17])


message,'FINISH'

end
