pro slitrot_pointing
;
; Hole operation first, then Star operation
;
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

fitsdir=strarr(4)

fitsdir[*]=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir[0] EQ '/' then fitsdir[*]=getenv('PWD')+'/'
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')+'/'

retry:
files2=dialog_input(prompt=["Mask 1","Star 1"],nfield=2,title='FCSA000XXXXX (last five number)')
files=strarr(4)
files[0]=files2[0]
files[1]=strtrim(string(long(files2[0])+1),1)
files[2]=files2[1]
files[3]=strtrim(string(long(files2[1])+1),1)


files=fitsdir+'FCSA000'+files+'.fits'
print,files

d = FINDFILE (files[0], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'
	goto,retry
endif
d = FINDFILE (files[1], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'
	goto,retry
endif

nterm=2

objectselectflag = DIALOG_MENU (['Click Point','Pick Object','Numerical Input'], TITLE = 'How to select the object?')

hole_x=fltarr(nterm) & hole_y=fltarr(nterm) & star_x=fltarr(nterm) & star_y=fltarr(nterm) & hole_x2=fltarr(nterm) & hole_y2=fltarr(nterm)

slitimage1=MRDFITS(files[0],0,headers1,/silent,/fscale)
suboverscan,slitimage1,slitimage1_os,1,overscan
slitiamge1=0
slitimage1_os=filter_image(slitimage1_os,median=3,/all)

slitimage2=MRDFITS(files[1],0,headers2,/silent,/fscale)
suboverscan,slitimage2,slitimage2_os,1,overscan
slitiamge2=0
slitimage2_os=filter_image(slitimage2_os,median=3,/all)

combine_chip12,slitimage1_os,slitimage2_os,slitimage_os,headers1

window,/free
winid=!D.WINDOW
hist=histogram(slitimage_os,min=0,max=1000)
plot,FINDGEN(size(hist,/N_ELEMENTS)),hist,yrange=[0,1000]

countlevel=[10,200,300,800]
count_input_retry:
countlevel=dialog_input(prompt=["Bottom Count of Slit",'Top Count of Slit','Bottom Count of Object','Top Count of Object'],nfield=4,initial=countlevel,title="Input Count Level")
if (n_elements(countlevel) NE 4 ) then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,count_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif

if (FIX(countlevel[0]) GT FIX(countlevel[1])) OR (FIX(countlevel[1]) GT FIX(countlevel[2])) OR (FIX(countlevel[2]) GT FIX(countlevel[3])) then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,count_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif

slitbottom=float(countlevel[0])
slittop=float(countlevel[1])
starbottom=float(countlevel[2])
startop=float(countlevel[3])

wdelete,winid

;
; Star operation
;
starimage1=MRDFITS(files[2],0,headers1,/silent,/fscale)
suboverscan,starimage1,starimage1_os,1,overscan
starimage1=0
starimage1_os=filter_image(starimage1_os,median=3,/all)

starimage2=MRDFITS(files[3],0,headers2,/silent,/fscale)
suboverscan,starimage2,starimage2_os,1,overscan
starimage2=0
starimage2_os=filter_image(starimage2_os,median=3,/all)

combine_chip12,starimage1_os,starimage2_os,starimage_os,headers1

CASE objectselectflag OF
	'Click Point': get_star_pos_click_multi,starimage_os < 40000 > starbottom,nterm,star_x,star_y,range=[starbottom,startop]
	'Pick Object': get_star_pos_multi,starimage_os < 40000 > starbottom,nterm,star_x,star_y,range=[starbottom,startop],winid=1,mytitle='Objects'
	'Numerical Input':begin
		for i=0,nterm-1 do begin
			numinput=dialog_input(prompt=["Object X",'Object Y'],nfield=2,title="Object Positions")
			star_x[i]=float(numinput[0]) & star_y[i]=float(numinput[1])
			print,star_x[i],star_y[i]
		end
	end
ENDCASE
;
; Mask Operation
;
;get_star_pos_click_multi,holeimage_med,nterm,hole_x,hole_y
;get_star_pos_mean_multi,holeimage_med < skylevel > cutlevel ,nterm,hole_x,hole_y,range=[cutlevel,skylevel]
;get_star_pos_multi,holeimage_med < holetop > holebottom,nterm,hole_x,hole_y,range=[holebottom,holetop],seeing=1.0,winid=0,mytitle='Alignment Hole'
get_slitpos_multi,slitimage_os < slittop > slitbottom,nterm,star_x,hole_x,hole_y,range=[slitbottom,slittop],seeing=1.0,winid=0,mytitle='Slit'
;
; Calculation
;
x_shift=fltarr(nterm) & y_shift=fltarr(nterm)
ang_star=fltarr(nterm) & ang_hole=fltarr(nterm) & difangle=fltarr(nterm)

x_shift=star_x-hole_x
y_shift=star_y-hole_y

;ang=-atan(y_shift[0]-y_shift[1],star_x[0]-star_x[1])*180/3.141592
ang=-atan((y_shift[0]-y_shift[1])/(star_x[0]-star_x[1]))*180/3.141592
print,x_shift,y_shift

print,'Move Insrot',ang,' (deg.), relatively.'
print,'Telescope should be moved by', mean(star_y-hole_y)*0.1038,' arcsec Y'
result=dialog_message(['Move Insrot'+string(ang)+' (deg.), relatively.','Telescope should be moved by '+string(mean(y_shift)*0.1038)+' arcsec Y'],/information)

;message,'Finish'

END
