PRO skysub,image,skysubimage

sigma=3

s=size(image)
endx=s[1]-1
startx=0
endy=s[2]-1
starty=0

spacecut=fltarr(endx-startx+1)
for j=0,endx-startx do spacecut[j]=mean(image[j,where(finite(image[j,*]))],/NAN);meanclip_func(image[j,*],clipsig=sigma)

window,/free,title="Space Cut of Spectra"
plot,spacecut,/ynozero

CURSOR,xclick,yclick,3,/device
XY = CONVERT_COORD(xclick,yclick,/device,/TO_DATA)
skystart=xy[0]

CURSOR,xclick,yclick,3,/device
XY = CONVERT_COORD(xclick,yclick,/device,/TO_DATA)
skyend=xy[0]

CURSOR,xclick,yclick,3,/device
XY = CONVERT_COORD(xclick,yclick,/device,/TO_DATA)
skystart2=xy[0]

CURSOR,xclick,yclick,3,/device
XY = CONVERT_COORD(xclick,yclick,/device,/TO_DATA)
skyend2=xy[0]

wdelete,!D.WINDOW

skyspec=fltarr(endy-starty+1)
xval=findgen(s[1])
for j=0,endy-starty do skyspec[j]=meanclip_func(image[where(((xval GE skystart) AND (xval LE skyend)) OR ((xval GE skystart2) AND (xval LE skyend2))),j],clipsig=sigma)

skysubimage=fltarr(endx-startx+1,endy-starty+1)

spacex=findgen(endx-startx+1)
weight=fltarr(endx-startx+1)
weight[*]=0
weight[where((spacex GE FIX(skystart)) AND (spacex LE FIX(skyend)))]=1
weight[where((spacex GE skystart2) AND (spacex LE skyend2))]=1

result=polyfitw(spacex,spacecut,weight,2,skyfit)
oplot,skyfit

skyspecnorm=skyspec/total(skyspec)
skyfitnorm=skyfit/meanw(skyfit,weight)
skyspecimage=transpose(skyspecnorm # skyfitnorm)*n_elements(skyspecnorm)*n_elements(skyfitnorm)

skyspecimage_select=skyspecimage[where( ((spacex GE FIX(skystart)) AND (spacex LE FIX(skyend))) OR ((spacex GE FIX(skystart2)) AND (spacex LE FIX(skyend2)))) ,*]
image_select       =image       [where( ((spacex GE FIX(skystart)) AND (spacex LE FIX(skyend))) OR ((spacex GE FIX(skystart2)) AND (spacex LE FIX(skyend2)))) ,*]

stat=moment(skyspecimage_select)
mincount=stat[1]
meanclip,skyspecimage_select,mean_scale1,sig,clipsig=sigma
meanclip,       image_select,mean_scale2,sig,clipsig=sigma

skyspecimage_scale=mean_scale2/mean_scale1*skyspecimage

;for j=0,endy-starty do begin
;	meanclip,image[*,j],scale1,sig,clipsig=sigma
;	meanclip,skyspecimage_scale[*,j],scale2,sig,clipsig=sigma
;	skysubimage[*,j]=image[*,j]-scale1/scale2*skyspecimage_scale[*,j]
;endfor

skysubimage=image-skyspecimage_scale

window,0,ysize=1000,xsize=(endx-startx+1),title='Sky-subtracted Spectrum"
imdisp,sigrange(skysubimage)

;message,'FINISH'

END
