; $Id: sfit.pro,v 1.5 1998/01/15 18:44:00 scottm Exp $
;
; Copyright (c) 1993-1998, Research Systems, Inc.  All rights reserved.
;       Unauthorized reproduction prohibited.

function sfitxyz, z, x, y,degree, kx=kx
;+
; NAME:
;	SFIT
;
; PURPOSE:
;	This function determines a polynomial fit to a surface.
;
; CATEGORY:
;	Curve and surface fitting.
;
; CALLING SEQUENCE:
;	Result = SFIT(Data, Degree)
;
; INPUTS:
; 	Data:	The two-dimensional array of data to fit. The sizes of
;		the dimensions may be unequal.
;
;	Degree:	The maximum degree of fit (in one dimension).
;
; OUTPUT:
;	This function returns a fitted array.
;
; OUTPUT KEYWORDS:
;	Kx:	The array of coefficients for a polynomial function
;		of x and y to fit data.
;		This parameter is returned as a (Degree+1) by (Degree+1) 
;		element array.
;
; PROCEDURE:
; 	Fit a 2D array Z as a polynomial function of x and y.
; 	The function fitted is:
;  	    F(x,y) = Sum over i and j of kx(j,i) * x^i * y^j
; 	where kx is returned as a keyword.
;
; MODIFICATION HISTORY:
;	July, 1993, DMS		Initial creation
;
;-

   on_error, 2

   nx = n_elements(x)
   ny = n_elements(y)
   m = nx * ny		;# of points to fit
   n2=(degree+1)^2		;# of coefficients to solve

   ut = dblarr(n2, nx, /nozero)

   for i=0, degree do for j=0,degree do $
	ut[i*(degree+1) + j, *] = x^i * y^j

   kk = invert(ut # transpose(ut)) # ut
   kx = fltarr(degree+1, degree+1) + float(kk # z)
   fit = reform(reform(kx,n2) # ut, nx)
   return, fit
end

