pro readnoise,FITSDIR=fitsdir

countmax=7850
countmin=7750

; Calculate readout noise from a bias image

	samplefac=4
	hist_min=7600
	hist_max=8000

IF (N_ELEMENTS(fitsdir) EQ 0) THEN $
   fitsdir = '/home/falcon/FITS'
;;;
;;; main program
;;;

	bfilename1=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits')
	IF(STRLEN(bfilename1) EQ 0) THEN goto,do_nothing
;
; read main image array
;
	bimage1= MRDFITS(bfilename1, 0, header)
;	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        bimage1=trim(bimage1,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

;
; read bias image array
;
;	bfilename2=DIALOG_PICKFILE(PATH='/export/home/ccd/messia/m3/',filter='t*.fits')
;	IF(STRLEN(bfilename2) EQ 0) THEN stop
;
; read main image array
;
;	bimage2= MRDFITS(bfilename2, 0, header)
;       xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
;       bimage2=trim(bimage2,xmin,xmax,ymin,ymax)
;       naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1
;
; bias - bias
;
	image = bimage1; - bimage2
	image = image + 32768
;	bigbias= [bimage1, bimage2]
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=bfilename1

	wset,0
	ERASE
	TV,BYTSCL(sigrange(image2,fraction=0.99)),/device

	print,'Set lower-left and upper right corners by mouse cursor.'
        CURSOR,line,column,/device
        line=line*samplefac & column=column*samplefac
       	startx=FIX(line) & starty=FIX(column)

	wait, 0.3

;	print,'CURSOR 2'
        CURSOR,line,column,/device
        line=line*samplefac & column=column*samplefac
        endx=FIX(line) & endy=FIX(column)

	result=moment(image[startx:endx,starty:endy] < countmax > countmin)
	print,'Readout Noise =',sqrt(result[1]),'(ADU)'

hist=histogram(image[startx:endx,starty:endy],min=hist_min,max=hist_max)
bin= FINDGEN(FIX(N_elements(hist)))+hist_min
WINDOW,1,xsize=1000,ysize=500,TITLE='Pixel Histograpm of '+bfilename1
plot,bin,hist,xrange=[hist_min,hist_max]

message,'FINISH'

do_nothing:
END
