PRO read_standard,wl,flux,width,FilenameInput=filenameinput

if keyword_set(filenameinput) EQ 0 then begin
	filename=DIALOG_PICKFILE(PATH='/home/ohyama/',filter='*.dat')
	IF(STRLEN(filename) EQ 0) THEN stop
end else begin
filename=filenameinput
endelse

maxnum=numlines(filename)

;maxnum=100
h=6.6260755e-34 * 1e7
c=2.99792458e8

wl=FLTARR(maxnum)
flux=FLTARR(maxnum)
width=FLTARR(maxnum)

fnuzero=3.68e-20
area=!PI*(8.2*100/2)^2-!PI*(1.2*100/2)^2

GET_LUN,U
openr,U,filename
i=0
WHILE NOT EOF(U) DO BEGIN
	READF, U,wl1,flux1,width1
;	print,wl1,flux1,width1

	freq=c/(wl1*1e-10)

	wl[i]=wl1 & flux[i]=fnuzero*10^(-0.4*flux1)*c/(wl1*1.e-10)^2*1e-10 & width[i]=width1; per Ang.
	i=i+1
ENDWHILE

close,U
FREE_LUN,U

;
message,'FINISH'
END
