PRO read_sbrfocus_trans,X1,Y1,X2,Y2,length,width,priority,object,naxis,type

;if checkfocana() then dir='.' else dir='/work/o99004/'
dir=getenv("FOCASRED_FITS_IN")+'/'
if dir EQ '/' then dir='./'

filename=DIALOG_PICKFILE(PATH=dir,filter='*.sbr',title='Input MDP file')
IF(STRLEN(filename) EQ 0) THEN return

maxnum=numlines(filename)

X1=FLTARR(maxnum)
Y1=FLTARR(maxnum)
x2=FLTARR(maxnum)
Y2=FLTARR(maxnum)
width=FLTARR(maxnum)
width_pix=fltarr(maxnum)
type=strarr(maxnum)
radius=fltarr(maxnum)
buf=''

GET_LUN,U
openr,U,filename
i=0
WHILE NOT EOF(U) DO BEGIN
	readf,u,buf
	s=strsplit(buf,/extract)
	n=n_elements(s)
	if n EQ 6 then begin
		type[i]=s[0] & X1[i]=float(s[1]) & y1[i]=float(s[2]) & x2[i]=float(s[3]) & y2[i]=float(s[4]) & width[i]=float(s[5])
		y1[i]=y1[i]-(width[i]+0.086)/2
		y2[i]=y2[i]+(width[i]+0.086)/2
	endif else begin
		type[i]=s[0] & X1[i]=float(s[1]) & x2[i]=x1[i] & y1[i]=float(s[2]) & y2[i]=y1[i] & radius[i]=float(s[3])
		x1[i]=x1[i]-radius[i] & x2[i]=x2[i]+radius[i] & y1[i]=y1[i]-radius[i] & y2[i]=y2[i]+radius[i]
	endelse
	i=i+1
ENDWHILE

count=i
close,U
FREE_LUN,U


read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

width_pix=(width+0.086)*beta/0.015
radius_pix=radius*beta/0.015

r1 = sqrt(x1^2+y1^2)
r2 = sqrt(x2^2+y2^2)

theta1 = atan(y1,x1)
theta2 = atan(y2,x2)

r1_on_ccd=r1
r2_on_ccd=r2

for m=0,n_elements(x1)-1 do begin
for i=0,10000 do begin
	k=float(i)/100.
	r1_guess = k*(coef[0] + coef[1]*k + coef[2]*k^2 + coef[3]*k^3)
	if r1_guess GE r1[m] then begin
		r1_on_ccd[m]=k
		goto,skip1
	endif
endfor
skip1:
endfor

for m=0,n_elements(x1)-1 do begin
for i=0,10000 do begin
	k=float(i)/100.
	r2_guess = k*(coef[0] + coef[1]*k + coef[2]*k^2 + coef[3]*k^3)
	if r2_guess GE r2[m] then begin
		r2_on_ccd[m]=k
		goto,skip2
	endif
endfor
skip2:
endfor
;r1_on_ccd = r1/(coef[0] + coef[1]*r1 + coef[2]*r1^2 + coef[3]*r1^3)
;r2_on_ccd = r2/(coef[0] + coef[1]*r2 + coef[2]*r2^2 + coef[3]*r2^3)

r1_pix=r1_on_ccd*beta/0.015
r2_pix=r2_on_ccd*beta/0.015

x1_pix=r1_pix*cos(theta1)+XDistCenter
y1_pix=r1_pix*sin(theta1)+XDistCenter; bug
x2_pix=r2_pix*cos(theta2)+YDistCenter; bug
y2_pix=r2_pix*sin(theta2)+YDistCenter

plot,x1_pix,y1_pix,xrange=[0,4000],yrange=[0,4000]
GET_LUN,U
openw,U,'~/aho.dat'
for i=0,count-1 do begin
	if type[i] EQ 'B,' then $
	printf,u,type[i],x1_pix[i],',',(y1_pix[i]+y2_pix[i])/2,',',x2_pix[i],',',(y1_pix[i]+y2_pix[i])/2,',',width_pix[i] $
	else printf,u,type[i],(x1_pix[i]+x2_pix[i])/2-radius_pix[i],',',(y1_pix[i]+y2_pix[i])/2-radius_pix[i],',',radius_pix[i]
endfor

close,u
i=0
message,'FINISH'
END
