PRO read_mdp_radec,wcsinfo,X1,Y1,X2,Y2,length,width,priority,object,naxis,type,DIR=dir

if not N_elements(dir) then begin
        dir=getenv("FOCASRED_FITS_IN")+'/'
	if dir EQ '/' then dir=getenv('PWD')
end

filename=DIALOG_PICKFILE(PATH=dir,filter='*.mdp',title='Input MDP (RA-DEC format) file')
IF(STRLEN(filename) EQ 0) THEN begin
		return
	endif else begin
		maxnum=numlines(filename)
	endelse

hh=fltarr(maxnum) & mm=fltarr(maxnum) & ss=fltarr(maxnum)
dhh=fltarr(maxnum) & dmm=fltarr(maxnum) & dss=fltarr(maxnum)
ra=fltarr(maxnum) & dec=fltarr(maxnum)

Xcen=FLTARR(maxnum) & Ycen=FLTARR(maxnum)
width=FLTARR(maxnum) & length=FLTARR(maxnum)
priority=FLTARR(maxnum)
object=strarr(maxnum)
type=intarr(maxnum)
types=strarr(maxnum)
buf=''


GET_LUN,U
openr,U,filename
i=0
WHILE NOT EOF(U) DO BEGIN
	readf,u,buf
	s=strsplit(buf,/extract)
        ; ra, ra, ra, dec, dec, dec, length, width, priority, types, comments
        hh[i]=float(s[0]) & mm[i]=float(s[1]) & ss[i]=float(s[2]) & dhh[i]=float(s[3]) & dmm[i]=float(s[4]) & dss[i]=float(s[5])
	length[i]=float(s[6]) & width[i]=float(s[7]) & priority[i]=float(s[8]) & types[i]=s[9]
	n=n_elements(s)
	if n EQ 10 then object[i]='' else object[i]=strjoin(s[10:n-1], ' ')
	object[i]=strtrim(object[i],2)
	i=i+1
ENDWHILE

for j=0,i-1 do begin
	if (types[j] EQ 'C') or (types[j] EQ 'C,') then type[j]=1 else type[j]=0
endfor

for j=0,i-1 do begin
	dec[j]=ten(dhh[j],dmm[j],dss[j])
	ra[j]=ten(hh[j],mm[j],ss[j])*15.
	ad2xy,ra[j],dec[j],wcsinfo,xcen_tmp,ycen_tmp
	xcen[j]=xcen_tmp & ycen[j]=ycen_tmp
;	print,xcen[j],ycen[j]
endfor

count=i
close,U
FREE_LUN,U

result=dialog_menu(['CCD Coordinate','Sky Coordinate'])

if result EQ 'CCD Coordinate' then begin
; (x1,y1) --- lower left corner of slit, (x2, y2) --- upper right corner of slit
	x1=xcen-length/2
	x2=xcen+length/2
	y1=ycen-width/2
	y2=ycen+width/2
end else begin
	x1=xcen-width/2
	x2=xcen+width/2
	y1=ycen-length/2
	y2=ycen+length/2

	dx1=x1-naxis[0]/2
	dx2=x2-naxis[0]/2
	dy1=y1-naxis[1]/2
	dy2=y2-naxis[1]/2

	tmp1=dy1
	tmp2=dy2
	dy1=-dx1
	dy2=-dx2

	dx1=tmp1
	dx2=tmp2

	x1=dx1+naxis[1]/2
	x2=dx2+naxis[1]/2
	y1=dy2+naxis[0]/2
	y2=dy1+naxis[0]/2
endelse

;message,'FINISH'

END
