pro n_distortion

samplefac=5
width=15
fac=1.0175
beta=0.29958085*0.990
;xFOVcenter=2024 & yFOVcenter=2005

X_inc = 5*beta; 5 mm per aperture * focus ratio
Y_inc = 5*beta; 1/3.324226
pix_inc=0.015; mm/pix
fitsdir='/wa51a/ohyamayi/DIST/'
X_INC_FACTOR=1.

;;;
;;; main program
;;;

nfiles=dialog_input(prompt="How many sets of files?")
filename=STRARR(nfiles)
filename2=STRARR(nfiles)

for i=0,nfiles-1 do begin
	filename[i]=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits')
	IF(STRLEN(filename[i]) EQ 0) THEN stop
	filename2[i]=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits')
	IF(STRLEN(filename[i]) EQ 0) THEN stop
endfor

X_obs12_3d=FLTARR(925,nfiles)
Y_obs12_3d=FLTARR(925,nfiles)
X_pos12_3d=FLTARR(925,nfiles)
Y_pos12_3d=FLTARR(925,nfiles)
rotangle_shift=FLTARR(nfiles)
difrotangle_shift=FLTARR(nfiles)
ele=FLTARR(nfiles)
pa=FLTARR(nfiles)

for i=0,nfiles-1 do begin
	image1=mrdfits(filename[i],0,header,/silent,/fscale)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
	ele[i]=SXPAR( header,'ELEVATION')
	pa[i]=SXPAR( header,'POSITIONANGLE')

; image display after rebinning nicely

	xoffset=10 & xend=2000 & yoffset=10 & yend=4000

	readxy,x_pos_id,y_pos_id,ndata,filenameinput='/home1/ohyamayi/IDL/FOCAS/chip13.xy'
	distortion_gaussfits,image1,naxis,X_pos_id,Y_pos_id,X_obs,Y_obs,X_pos,Y_pos,x0,y0
	delta_X=X_obs-X_pos & delta_Y=Y_obs-Y_pos

	!P.MULTI=0

	image2=mrdfits(filename2[i],0,header)
	readxy,x_pos_id2,y_pos_id2,ndata2,filenameinput='/home1/ohyamayi/IDL/FOCAS/chip232.xy'
	distortion_gaussfits,image2,naxis,X_pos_id2,Y_pos_id2,X_obs2,Y_obs2,X_pos2,Y_pos2,x02,y02
	delta_X2=X_obs2-X_pos2 & delta_Y2=Y_obs2-Y_pos2
;
;Rotate
;
!P.MULTI=0

	fit_result_rotate=poly_fit(Y_obs[0:34],X_obs[0:34],1,yfit,yband,sigma_result,cor,/double)
	rotangle=fit_result_rotate[1]
	print,"rotangle=",rotangle*180/3.141592,"+-",sigma_result

	fit_result_rotate=poly_fit(Y_obs2[0:34],X_obs2[0:34],1,yfit,yband,sigma_result,cor,/double)
	rotangle2=fit_result_rotate[1]
	print,"rotangle2=",rotangle2*180/3.141592,"+-",sigma_result

	distortion_chipcombine,naxis,X_pos_id,y_pos_id,X_pos_id2,Y_pos_id2,x_obs,y_obs,x_obs2,y_obs2,x_pos,y_pos,x_pos2,y_pos2,x0,y0,x02,y02,rotangle,rotangle2,$
		x_obs12,y_obs12,x_pos12,y_pos12,delta_X12,delta_Y12,x_pos_id12,y_pos_id12,y_shift,gapsize

	window,3,xsize=(3980-20)/samplefac,ysize=(3980-20)/samplefac,title='Distortion Plot'
	!P.MULTI=0
	xoffset=0 & xend=naxis[0] & yoffset=0 & yend=naxis[1]
	partvelvec,delta_X12,delta_Y12,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend]
;	partvelvec,X_obs12-X_pos12,Y_obs12-Y_pos12,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend]

	X_obs12_3d[0,i]=X_obs12
	Y_obs12_3d[0,i]=Y_obs12

	X_pos12_3d[0,i]=X_pos12
	Y_pos12_3d[0,i]=Y_pos12

	rotangle_shift[i]=rotangle
	difrotangle_shift[i]=difrot
endfor
xoffset=0 & xend=naxis[0] & yoffset=0 & yend=naxis[1]

j=1 & ref=0
X_PLOT=X_obs12_3d[*,j]-X_obs12_3d[*,ref]-mean(X_obs12_3d[*,j]-X_obs12_3d[*,ref])
Y_PLOT=Y_obs12_3d[*,j]-Y_obs12_3d[*,ref]-mean(Y_obs12_3d[*,j]-Y_obs12_3d[*,ref])

partvelvec,[X_PLOT,1],[Y_PLOT,1],[X_pos12_3d[*,ref],250],[Y_pos12_3d[*,ref],250],[xoffset,xend],[yoffset,yend]

message,'Finish!'

     formInfo = cmps_form(Cancel=canceled, Create=create)

     IF NOT canceled THEN BEGIN
        IF create THEN BEGIN
           thisDevice = !D.Name
           Set_Plot, "PS"
           Device, _Extra=formInfo

	partvelvec,[X_obs12_3d[*,j]-X_obs12_3d[*,ref]-mean(X_obs12_3d[*,j]-X_obs12_3d[*,ref]),1],[Y_obs12_3d[*,j]-Y_obs12_3d[*,ref]-mean(Y_obs12_3d[*,j]-Y_obs12_3d[*,ref]),1],[X_pos12_3d[*,ref],250],[Y_pos12_3d[*,ref],250],[xoffset,xend],[yoffset,yend]

           Device, /Close
           Set_Plot, thisDevice
        ENDIF ELSE BEGIN
           info.ps_config = formInfo
	ENDELSE
    ENDIF

DO_NOTHING:
END
