pro n_conttrace

; pick multi files
; measure pos, FWHM, etc, at various positions
; analysis and plot

	nsum=10
	delay=0.0
	samplefac=4; 2 for DAO
	significance=20.
;;;
;;; main program
;;;

	nfilename=DIALOG_PICKFILE(PATH='~/FOCAS/SUBJECT/SLITROT',filter='*.fits',/MULTIPLE_FILES)
	IF(STRLEN(nfilename[0]) EQ 0) THEN stop
	IF(size(nfilename,/N_ELEMENTS) EQ 1) THEN BEGIN
		print,'Number of files must be > 2!'
		stop
	END
	nfiles=size(nfilename,/N_ELEMENTS)
	filename=nfilename[0]
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
;	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

;
; read ascii extension
;
;	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2)),/device

	result_xy=dialog_menu(['X direction','Y direction'],TITLE='Scan Direction?')
	CASE result_xy OF
		'X direction': BEGIN
			END
		'Y direction': BEGIN
			image=rotate(image,1); rotate 90 deg clockwise
			image2=rotate(image2,1)
			temp=naxis[0]
			naxis[0]=naxis[1]
			naxis[1]=temp
			END
	ENDCASE

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2)),/device

	PRINT,'Clit 2 times to select X region'
	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	startx=FIX(line)

	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	endx=FIX(line)

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
;		Y[i]=image(FIX(startx),i)
                Y[i]=total(image(FIX(startx)-FIX(nsum/2):FIX(startx)+FIX(nsum/2),i),1)
	ENDFOR

	ERASE
	WINDOW,0,xsize=1024,ysize=512,TITLE='Select a Line (CLICK 2 times)'
	PLOT,X,Y,/ynozero

	print,'Find sky region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	skystarty=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	skyendy=FIX(XY[0])
	skywidth=abs(skystarty-skyendy)

	print,'Find object region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	PRINT,Xnew,X2new

	objwidth=abs(X2new-Xnew) < 50
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]
	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]
	
	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	coef_ini = coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	skyoffset=FIX(abs(skyendy-coef[1]))
;	print,'skyoffset=',skyoffset


	colnum=dialog_slider([1,FIX(abs(startx-endx+1)/10)],prompt='# of tracing points?')

	step=FIX((endx-startx+1)/(colnum+1))
	num=FIX((endx-startx+1)/step)+1

	ypos=FLTARR(nfiles,num)
	xpos=FLTARR(nfiles,num)
	skew=FLTARR(nfiles,num)
	kurt=FLTARR(nfiles,num)
	FWHM=FLTARR(nfiles,num)
	flux=FLTARR(nfiles,num)
	amp=FLTARR(nfiles,num)

	rot=FLTARR(nfiles)
	pos=FLTARR(nfiles)
	sequence=FLTARR(nfiles)
;
; Start main loop
;

FOR fileid=0,nfiles-1 DO BEGIN
	sequence[fileid]=fileid
	print,nfilename[fileid]

	image= MRDFITS(nfilename[fileid], 0)
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)

	CASE result_xy OF
		'X direction': BEGIN
			END
		'Y direction': BEGIN
			image=rotate(image,1); rotate 90 deg clockwise
			END
	ENDCASE

	coef_new=coef_ini
	coef=coef_new
	i=0
	FOR column=startx,endx,step DO BEGIN
		coef=coef_new
		FOR k=0,naxis[1]-1 do begin
			X[k]=k
;			Y[k]=image(column,k)
	                Y[k]=total(image(FIX(column)-FIX(nsum/2):FIX(column)+FIX(nsum/2),k),1)
		ENDFOR

		Xnew=FIX(coef[1]-objwidth/2)
		X2new=FIX(coef[1]+objwidth/2)

		XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	        IF abs(MAX(YY)-MIN(YY)) LT STDDEV(YY[1:10]*significance) then begin
        	        print,'SKIP'            
                	goto,SKIP
	        ENDIF

		YY=YY-MIN(YY) & YY=YY/MAX(YY)
		plot,XX,YY,/YNOZERO

		est=[1,coef[1],coef[2],0]
		result=GAUSSFIT(XX,YY,coef_new,NTERMS=4,ESTIMATE=est)

		oplot,XX,result,psym=10
		wait,delay

		xpos[fileid,i]=column
		amp[fileid,i]=coef_new[0]
		ypos[fileid,i]=coef_new[1]
		FWHM[fileid,i]=coef_new[2]
		skew[fileid,i]=skewness(YY)
		kurt[fileid,i]=kurtosis(YY)

		skyflux=0
		for j=FIX(ypos[fileid,i]-skyoffset-skywidth/2),FIX(ypos[fileid,i]-skyoffset+skywidth/2) do begin
		skyflux=skyflux+Y[j]
		endfor

		skyflux=skyflux/skywidth

		for j=FIX(ypos[fileid,i]-objwidth/2),FIX(ypos[fileid,i]+objwidth/2) do begin
		flux[fileid,i]=flux[fileid,i]+Y[j]-skyflux
		endfor

		i=i+1

SKIP:

	ENDFOR ; column loop

	id=where(ypos[fileid,*] gt 0)

	fit_result=POLY_FIT(xpos[fileid,id],ypos[fileid,id],1,fit)
	dx=abs(startx-endx)
	dy=fit_result[1]*dx
	rot[fileid]=ATAN(dy/dx)*180/3.1415926535
	pos[fileid]=fit_result[1]*naxis[0]/2+fit_result[0]

	
ENDFOR ; nfiles loop


WINDOW,0,xsize=1024,ysize=512,TITLE=''

REPEAT BEGIN
flag = DIALOG_MENU (['TRACE','AMP','FLUX','FWHM','SKEW','KURT','POS-CHANGE','ROT-CHANGE','END'], TITLE = 'Analysis Result')
	CASE flag OF

	'TRACE': BEGIN
		plotfile=dialog_slider([0,(nfiles-1)],prompt='Which file do you want to plot?')
		id=where(xpos[plotfile,*] gt 0)
		result=DIALOG_PLOT2(XDATA=xpos[plotfile,id],YDATA=ypos[plotfile,id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Peak Position',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)

	END

	'AMP': BEGIN
		plotfile=dialog_slider([0,nfiles-1],prompt='Which file do you want to plot?')
		id=where(xpos[plotfile,*] gt 0)
		result=DIALOG_PLOT2(XDATA=xpos[plotfile,id],YDATA=amp[plotfile,id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Amplitude',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'FLUX': BEGIN
		plotfile=dialog_slider([0,nfiles-1],prompt='Which file do you want to plot?')
		id=where(xpos[plotfile,*] gt 0)
		result=DIALOG_PLOT2(XDATA=xpos[plotfile,id],YDATA=flux[plotfile,id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Flux',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'FWHM': BEGIN
		plotfile=dialog_slider([0,nfiles-1],prompt='Which file do you want to plot?')
		id=where(xpos[plotfile,*] gt 0)
		result=DIALOG_PLOT2(XDATA=xpos[plotfile,id],YDATA=FWHM[plotfile,id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Width (FWHM)',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'SKEW': BEGIN
		plotfile=dialog_slider([0,nfiles-1],prompt='Which file do you want to plot?')
		id=where(xpos[plotfile,*] gt 0)
		result=DIALOG_PLOT2(XDATA=xpos[plotfile,id],YDATA=skew[plotfile,id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Skewness',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'KURT': BEGIN
		plotfile=dialog_slider([0,nfiles-1],prompt='Which file do you want to plot?')
		id=where(xpos[plotfile,*] gt 0)
		result=DIALOG_PLOT2(XDATA=xpos[plotfile,id],YDATA=kurt[plotfile,id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Kurtosis',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'POS-CHANGE': BEGIN
		result=DIALOG_PLOT2(XDATA=sequence,YDATA=pos,/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='Frame No.',YTITLE='Continuum Peak Position',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'ROT-CHANGE': BEGIN
		result=DIALOG_PLOT2(XDATA=sequence,YDATA=rot,/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='Frame No.',YTITLE='Continuum Tilt Angle',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'END': BEGIN & END ; do nothing
	''   : BEGIN & END ; do nothing

	ENDCASE

ENDREP UNTIL ((flag EQ 'END') OR (flag EQ ''))

FINISH:

message,'FINISH'
END
