pro mosaic_focas

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan


result=dialog_checklist(['Mean','Median','3 Sigma Clipping'],title='Select Image Combination Mode',initial=[0,0,0])
if result[0] EQ 0 then meanmode = 0 else meanmode = 1
if result[1] EQ 0 then medianmode =0 else medianmode =1
if result[2] EQ 0 then clipmode =0 else clipmode =1

print,meanmode, medianmode,clipmode

;if checkfocana() then begin
;	fitsdir='/data2/ohyama/M67/'
;	badlistdir='/home/ohyama/IDL/DATA/'
;	outfitsdir=fitsdir
;endif else begin
;	fitsdir='/work/o99004/'
;	badlistdir='/home/focas02/IDL/DATA/'
;	outfitsdir=fitsdir
;endelse

fitsdir=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir EQ '/' then fitsdir='./'
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')
badlistdir=getenv("FOCASRED_DATA_IN")+'/'
if badlistdir EQ '/' then badlistdir=getenv('PWD')

filename=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits',/multiple,title='Input FITS file names (select multiple files)')
header=headfits(filename[0])
naxis=SXPAR( header,'NAXIS*')
nfiles=n_elements(filename)

outfilename=DIALOG_PICKFILE(PATH=fitsoutdir,filter='*.fits',title='Output FITS file name')

image=fltarr(naxis[0],naxis[1],nfiles,/nozero)
for i=0,nfiles-1 do image[*,*,i]=MRDFITS(filename[i],0,header,/silent,/fscale)

badpixlist=DIALOG_PICKFILE(PATH=badlistdir,filter='*.lst',title='Select a badpix list')
IF(STRLEN(badpixlist) EQ 0) THEN goto,do_nothing

maskmake2,badpixlist,image,nfiles,naxis,mask
;maskmake_outoffovzero,badpixlist,nfiles,naxis,mask

xoffset=FLTARR(nfiles) & yoffset=FLTARR(nfiles)

xoffset[0]=0 & yoffset[0]=0
for i=1,nfiles-1 do begin
	imagerot2,image[*,*,0],image[*,*,i],difangle,tmp_xoffset,tmp_yoffset
	xoffset[i]=tmp_xoffset
	yoffset[i]=tmp_yoffset
	image[*,*,i]=rot(image[*,*,i],difangle,/interp)
endfor

print,'MEMORY ALLOC'
xdim=naxis[0] & ydim=naxis[1]
extxsize=FIX(max([-min(xoffset),max(xoffset)]))
extysize=FIX(max([-min(yoffset),max(yoffset)]))

imagee=make_array(xdim+extxsize*2,ydim+extysize*2,nfiles,/float,/nozero)
 maske=make_array(xdim+extxsize*2,ydim+extysize*2,nfiles,/byte,/nozero)

for i=0,nfiles-1 do begin
	image2d=0
	image2d=image[*,*,i]
;	image2d= MRDFITS(filename[i], 0, header,/fscale,/silent)
	naxis= SXPAR(header,'NAXIS*')
	print,'EXTRACTING'
	imagee2d=extrac(image2d,-extxsize,-extysize,xdim+extxsize*2,ydim+extysize*2) & image2d=0
	print,'SHIFINTG'
	imagee2d=shift(imagee2d,-FIX(xoffset[i]),-FIX(yoffset[i]))
	print,'MASK COPY'
	mask2d=0
	mask2d=mask[*,*,i]
	print,'MASK EXTRACTING'
	maske2d=extrac(mask2d,-extxsize,-extysize,xdim+extxsize*2,ydim+extysize*2) & mask2d=0
	print,'MASK SHIFT'
	maske2d=shift(maske2d,-FIX(xoffset[i]),-FIX(yoffset[i]))
	print,'IMAGE COPY'
	imagee[0,0,i]=imagee2d & imagee2d=0
	print,'MASK COPY'
	maske[0,0,i]=maske2d & maske2d=0
endfor

if meanmode then outimage=meanarr(imagee,maske,maskeout)
if medianmode then medarr, imagee, outimage,maske
if clipmode then sigclipavgarr,imagee,outimage,maske

;skysub_mmm,outimage,outimage_ss
imdisp,sigrange(outimage)

;write_fits,outimage,header
MWRFITS,outimage ,outfileName,header

;message,'Finish'
do_nothing:
END
