pro mosaic_engine,image,mask,outimage,xoffset,yoffset

s=size(image)
xdim=s(1) & ydim=s(2) & nfiles=s(3)
extxsize=FIX(max([-min(xoffset),max(xoffset)]))
extysize=FIX(max([-min(yoffset),max(yoffset)]))

imagee=make_array(xdim+extxsize*2,ydim+extysize*2,s[3],/float,/nozero)
imagee2d=fltarr(xdim+extxsize*2,ydim+extysize*2,/nozero)
for i=0,nfiles-1 do begin
	print,'EXTRACTING'
	imagee2d=extrac(image[*,*,i],-extxsize,-extysize,xdim+extxsize*2,ydim+extysize*2); & undefine,image2d
	print,'SHIFINTG'
	imagee[*,*,i]=shift(imagee2d,FIX(xoffset[i]),FIX(yoffset[i])); & undefine,imagee2d
endfor

 maske=make_array(xdim+extxsize*2,ydim+extysize*2,s[3],/byte,/nozero)
 maske2d=bytarr(xdim+extxsize*2,ydim+extysize*2)
for i=0,nfiles-1 do begin
	print,'MASK EXTRACTING'
	maske2d=extrac(mask[*,*,i],-extxsize,-extysize,xdim+extxsize*2,ydim+extysize*2); & undefine,mask2d
	print,'MASK SHIFT'
	maske[*,*,i]=shift(maske2d,FIX(xoffset[i]),FIX(yoffset[i]));=maske2d & undefine,maske2d
endfor

undefine, imagee2d
undefine, maske2d

;sigclipavgarr,imagee,outimage,maske,cutstart=1./8.,cutend=1.
robust_mean,imagee,outimage,maske,cutstart=1./8.,cutend=1.

;imdisp,sigrange(outimage)

;message,'Finish'
END
