;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO mark_position,xpos,ypos,use,binning,win,usearr

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom

        nterm=n_elements(xpos)
        wset,win

    	sqoffset = 100/binning[0]
    	plots, [(xpos[0]-sqoffset)/samplefac,(xpos[0]-sqoffset)/samplefac], [(ypos[0]-sqoffset)/samplefac,(ypos[0]+sqoffset)/samplefac],/DEVICE
    	plots, [(xpos[0]-sqoffset)/samplefac,(xpos[0]+sqoffset)/samplefac], [(ypos[0]+sqoffset)/samplefac,(ypos[0]+sqoffset)/samplefac],/DEVICE,/CONTINUE
    	plots, [(xpos[0]+sqoffset)/samplefac,(xpos[0]+sqoffset)/samplefac], [(ypos[0]+sqoffset)/samplefac,(ypos[0]-sqoffset)/samplefac],/DEVICE,/CONTINUE
    	plots, [(xpos[0]+sqoffset)/samplefac,(xpos[0]-sqoffset)/samplefac], [(ypos[0]-sqoffset)/samplefac,(ypos[0]-sqoffset)/samplefac],/DEVICE,/CONTINUE
        if (use[0] EQ 1) then xyouts,(xpos[0]+10-xoffset)/samplefac,(ypos[0]+10-yoffset)/samplefac,strtrim(string(0),2),/DEVICE,CHARSIZE=1.5
        FOR i=0,nterm-1 do begin
            draw_ellipse,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,100/samplefac/binning[0],$
                    100/samplefac/binning[1],/device
            if(use[i] EQ 1) then begin
                xyouts,(xpos[i]+10-xoffset)/samplefac,(ypos[i]+10-yoffset)/samplefac,strtrim(string(i),2),$
                    /device,charsize=1.5
            endif
        ENDFOR
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO set_intensity_level,holebuttom,holetop,starbuttom,startop

        IF N_elements(holebuttom) EQ 0 THEN countlevel=[10,800,900,1500] $
	ELSE countlevel=[holebuttom,holetop,starbuttom,startop]
        count_input_retry:
        countlevel=dialog_input(prompt=["Bottom Count of Alignment Hole",'Top Count of Alignment Hole',$
            'Bottom Count of Alignment Star','Top Count of Alignment Star (Display purpose only)'],nfield=4,$
            initial=countlevel,title="Input Count Level")
    ; Check 1
        if (n_elements(countlevel) NE 4 ) then begin
            flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong.')
            CASE flag OF
                'Retry': begin
                    goto,count_input_retry
                    end
                'Quit': return;
            ENDCASE
        endif
    ; Check 2
        if (float(countlevel[0]) GT float(countlevel[1])) OR (float(countlevel[1]) GT float(countlevel[2])) $
            OR (float(countlevel[2]) GT float(countlevel[3])) then begin
                flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
                CASE flag OF
                    'Retry': begin
                        goto,count_input_retry
                        end
                    'Quit': return;
                ENDCASE
        endif

        holebuttom=float(countlevel[0]) & holetop=float(countlevel[1])
        starbuttom=float(countlevel[2]) & startop=float(countlevel[3])
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO refit_holes,holeimage,hole_x,hole_y,binning,holebuttom,holetop,winid_hole,winfit,winobs,width, $
    nterm,use,mode=mode
        for i=0,nterm-1 do begin
            if use[i] EQ 1 then begin
                get_star_pos,holeimage,holetop,holebuttom,hole_x[i],hole_y[i],X,Y,binning,i, $
                     winid_hole,winfit,winobs,width,RANGE=[holebuttom,holetop],MODE='SINGLE'
                hole_x[i]=X & hole_y[i]=Y
            endif
        ENDFOR
END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO refit_stars,starimage,star_x,star_y,binning,starbuttom,startop,winid_star,winfit,winobs,width,nterm,use,mode=mode

        for i=0,nterm-1 do begin
            if use[i] EQ 1 then begin
                ;IF mode EQ "STAR2" then begin
                    get_star_pos,starimage,startop,starbuttom,star_x[i],star_y[i],X,Y,binning,i, $
                        winid_star,winfit,winobs,width,RANGE=[starbuttom,startop],MODE='STAR2'
                ;ENDIF ELSE begin
                ;    get_star_pos,starimage,startop,starbuttom,star_x[i],star_y[i],X,Y,binning,i, $
                ;        winid_star,winfit,winobs,width,RANGE=[starbuttom,startop],MODE='SINGLE'
                ;ENDELSE
                star_x[i]=X & star_y[i]=Y
            endif
        ENDFOR
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO get_pos,image,X,Y,XOUT,YOUT,binning,buttom_level,top_level,i,win,win2,win3,width,MODE=MODE
        if mode EQ "STAR" then width2=30 > width else width2 =width > 30

;;;     if mode EQ "STAR2" then width2=30 > width else width2 =width > 30

;;;     if mode EQ "STAR" then width2=width else width2 =width
        IF MODE EQ 'MANUAL' then begin
            get_star_pos_manual,image, top_level, buttom_level,X,Y,XOUT,YOUT,binning,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE='SINGLE'
        endif else begin
            IF MODE EQ 'HOLE' then BEGIN
	        get_star_pos,image, top_level, buttom_level,X,Y,XOUT,YOUT,binning,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE='SINGLE'
            ENDIF ELSE get_star_pos2,image,top_level,buttom_level,X,Y,XOUT,YOUT,binning,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE=MODE
        endelse

        ; get_star_pos inline
END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO get_star_pos,image,top_level,buttom_level,xpos,ypos,xposout,yposout,binning,i,win,win2,win3,width,RANGE=range,MODE=MODE
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom

print,"Entering get_star_pos: ",xpos,ypos,binning,width
    ;on_error,2 
    width2=round(width/binning[0])

    a=fltarr(7)

    ;;; Fit 1

        wset,win

        s=size(image)
        xmax=s(1)
        ymax=s(2)

    click_retry:
        IF xpos LT 0 then begin
            CURSOR,xpos,ypos,/device
            print, "get_star_pos -- Device Coord: xpos = ", xpos, "  ypos = ", ypos
            xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
        ENDIF

        if (xpos-width2 LT 0) or (xpos+width2 GT xmax) or (ypos-width2 LT 0) or (ypos+width2 GT ymax) then begin
            print,'get_star_position: Your Clicked Position was out of range. Try again'
            goto, click_retry
        end

        image3=image[xpos-width2 > width2:xpos+width2 < xmax,ypos-width2 > 0:ypos+width2 < ymax]
        rawimage = image3
        image3 = image3 < top_level > buttom_level
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4;-median(image4[*,0:3])

        wset,win3
        imdisp,image3,margin=0

	    ; Protect the results from gauss2dfit2 if gauss2dfit is unable to converge.
   	    CATCH, Error_status  
	    ;This statement begins the error handler:  
   	    IF Error_status NE 0 THEN BEGIN  
      		PRINT, 'get_star_pos:HOLE: Error index: ', Error_status  
      		PRINT, 'get_star_pos:HOLE: Error message: ', !ERROR_STATE.MSG  
                flag=dialog_message('get_star_pos:HOLE: Unable to fit hole in HOLE mode. (X)')
	        xposout=xpos
                yposout=ypos
		xpos2=xpos
		ypos2=ypos
                buttom_level2=buttom_level
                CATCH, /CANCEL
		GOTO,no_refit
   	    ENDIF
	    result=gauss2dfit2(image3,a,/tilt)
	    print,"get_star_pos: Using gauss2dfit w/tilt."
	    ;;; result=mpfit2dpeak(image3,a,/tilt,/GAUSSIAN)
	    ;;; print,"get_star_pos: Using mpfit2dpeak2 w/GAUSSIAN w/tilt."


            if a[1] LT 0 then begin
                print,'get_star_pos: Fit error!: Amp ',a[1],' is negative!'
                xposout=xpos
                yposout=ypos
                return
            END
        
        error_string = STRING(i,FORMAT='(I2)') + ':  1st Fit Result Out-of-bound!'

        if a[4] GT 2*width2 or a[4] LT 0 then begin
            print,'get_star_pos: Wrong Fit'
	    ;;;flag=dialog_message('Fit Result Out-of-bound! (X)')
            flag=dialog_message(error_string + '(X)')
            xposout=xpos
            yposout=ypos
            return; of procedure
        END

        if a[5] GT 2*width2 OR a[5] LT 0 then begin
            print,'get_star_pos: Wrong Fit'
            ;;;flag=dialog_message('Fit Result Out-of-bound! (Y)')
            flag=dialog_message(error_string + '(Y)')
    ;        a[5]=width
            xposout=xpos
            yposout=ypos
            return; of procedure
        END
       
	if MODE EQ "HOLE" or MODE EQ "SINGLE" then begin
            xpos2=a[4]-width2+xpos
            ypos2=a[5]-width2+ypos
	endif else begin
	    ;;;wrap_cntrd, image3, a, xcen, ycen
            ;;;wrap_cntrd, rawimage, a, xcen, ycen, /DEBUG                  ; using raw data
            ;;;first_moment_cog, image3, a, xcen, ycen, /USEMAX, /DEBUG   ; using max.
            ;;;first_moment_cog, rawimage, a, xcen, ycen, /USEMAX, /DEBUG   ; using raw data & max.
	    ;;;xpos2=xcen-width2+xpos
            xpos2=a[4]-width2+xpos  ; use gauss2dfit results
            ;;;ypos2=ycen-width2+ypos
            ypos2=a[5]-width2+ypos  ; use gauss2dfit results
        endelse

    ;;; Fit 2
    if MODE EQ "SINGLE" then begin
        buttom_level2=buttom_level
        goto,no_refit
    end


        image3=image[xpos2-width2:xpos2+width2,ypos2-width2:ypos2+width2]
        rawimage = image3
        buttom_level2=(buttom_level+a[1]/2.) < (top_level - 100)
        image3 = image3 < top_level > buttom_level2
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4;-median(image4[*,0:3])

        wset,win3
        imdisp,image3,margin=0

	    CATCH, Error_status
  	    ;This statement begins the error handler:  
   	    IF Error_status NE 0 THEN BEGIN  
      	    	PRINT, 'GET_STAR_POS: Error index: ', Error_status  
      		PRINT, 'GET_STAR_POS: Error message: ', !ERROR_STATE.MSG
		flag=dialog_message('GET_STAR_POS: Unable to fit hole in SINGLE mode. (X)')
		xposout=xpos
		yposout=ypos
		xpos2=xpos
		ypos2=ypos
                buttom_level2=buttom_level
		CATCH, /CANCEL
                GOTO,no_refit
   	    ENDIF
	    result=gauss2dfit2(image3,a)
	    print,"get_star_pos: Using gauss2dfit."
	    ;;; result=mpfit2dpeak(image3,a,/GAUSSIAN)
	    ;;; print,"get_star_pos: Using mpfit2dpeak2 w/GAUSSIAN."

            olda=a
            olda[4]=width2 & olda[5]=width2
;;;         result=mpfit2dpeak(image3,a,estimates=olda,/circular)
    ;    ENDELSE

        error_string = STRING(i,FORMAT='(I2)') + ':  2nd Fit Result Out-of-bound!'
        if a[4] GT 2*width2 or a[4] LT 0 then begin
            print,'get_star_pos: Wrong Fit'
            ;;; flag=dialog_message('Fit Result Out-of-bound! (X)')
            flag=dialog_message(error_string + '(X)')
    ;        a[4]=width
            xposout=xpos
            yposout=ypos
            return; of procedure
        END

        if a[5] GT 2*width2 OR a[5] LT 0 then begin
            print,'get_star_pos: Wrong Fit'
            ;;; flag=dialog_message('Fit Result Out-of-bound! (Y)')
	    flag=dialog_message(error_string + '(Y)')
            ;;; a[5]=width2
            xposout=xpos
            yposout=ypos
            return; of procedure

        END

	if MODE EQ "HOLE" then begin
            xpos2=a[4]-width2+xpos2
            ypos2=a[5]-width2+ypos2
	endif else begin
	    ;;;wrap_cntrd,image3,a,xcen,ycen
	    ;;;wrap_cntrd,rawimage,a,xcen,ycen                            ; using raw data
            ;;;first_moment_cog, image3, a, xcen, ycen, /USEMAX, /DEBUG   ; using max.
            ;;;first_moment_cog, rawimage, a, xcen, ycen, /USEMAX, /DEBUG ; using raw data & max.
	    ;;xpos2=xcen-width2+xpos2
            xpos2=a[4]-width2+xpos2  ; gauss2dfit results applied
            ;;ypos2=ycen-width2+ypos2
            ypos2=a[5]-width2+ypos2  ; gauss2dfit results applied
        endelse

    no_refit:

    ;
    ; Draw
    ;
        image3=image[xpos2-width2:xpos2+width2,ypos2-width2:ypos2+width2]
        image3 = image3 < top_level > buttom_level2
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4;-median(image4[*,0:3])

        wset,win2
        show3,image3
        wset,win3
        imdisp,image3,margin=0
        draw_ellipse,100,100,10,10,/device,COLOR=255*255*255

        
        wset,win
        draw_ellipse,(xpos2-xoffset)/samplefac,(ypos2-yoffset)/samplefac,100/samplefac/binning[0],100/samplefac/binning[1],/device
        xyouts,(xpos2+10-xoffset)/samplefac,(ypos2+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

    ;    aper,image,a[4]-width2+xpos,a[5]-width2+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux

        xposout=xpos2 & yposout=ypos2

       print,xposout,yposout

END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO get_star_pos_manual,image,top_level,buttom_level,xpos,ypos,xposout,yposout,binning,i,win,win2,win3,width,RANGE=range,MODE=MODE
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom


    on_error,2 
    width2=round(width/binning[0])

    ;catch,error_status
    ;if error_status NE 0 then begin
    ;    print,'The following error happened, and recovered.'
    ;    print,!ERR_STRING
    ;endif

    a=fltarr(7)

    ;;; Fit 1

        wset,win

        s=size(image)
        xmax=s(1)
        ymax=s(2)

    click_retry:
        IF xpos LT 0 then begin
            CURSOR,xpos,ypos,/device
            xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
        ENDIF

        if (xpos-width2 LT 0) or (xpos+width2 GT xmax) or (ypos-width2 LT 0) or (ypos+width2 GT ymax) then begin
            print,'get_star_pos_manual: Your Clicked Position was out of range. Try again'
            xpos=-1
            goto, click_retry
        end

        image3=image[xpos-width2 > width2:xpos+width2 < xmax,ypos-width2 > 0:ypos+width2 < ymax]
        image3 = image3 < top_level > buttom_level
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4;-median(image4[*,0:3])

        wset,win3
        imdisp,image3,margin=0

        CURSOR,xpos2,ypos2,/normal
        xpos2=xpos2*(2*width2+1)-width2+xpos & ypos2=ypos2*(2*width2+1)-width2+ypos
        

    ;
    ; Draw
    ;
        image3=image[xpos2-width2:xpos2+width2,ypos2-width2:ypos2+width2]
        image3 = image3 < top_level > buttom_level
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4;-median(image4[*,0:3])

        wset,win2
        show3,image3
        wset,win3
        imdisp,image3,margin=0
        draw_ellipse,100,100,10,10,/device,COLOR=255*255*255

        
        wset,win
        draw_ellipse,(xpos2-xoffset)/samplefac,(ypos2-yoffset)/samplefac,100/samplefac/binning[0],100/samplefac/binning[1],/device
        xyouts,(xpos2+10-xoffset)/samplefac,(ypos2+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

    ;    aper,image,a[4]-width2+xpos,a[5]-width2+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux

        xposout=xpos2 & yposout=ypos2

        print,xposout,yposout

END




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO get_star_pos2,image,top_level,buttom_level,xpos,ypos,xposout,yposout,binning,i,win,win2,win3,width,RANGE=range,MODE=MODE
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom

    ;on_error,2
    width2=round(width/binning[0])

    ;image_cut=image < top_level > buttom_level

    ;catch,error_status
    ;if error_status NE 0 then begin
    ;    print,'The following error happened, and recovered.'
    ;    print,!ERR_STRING
    ;endif

    a=fltarr(7)

    ;;; Fit 1

        wset,win

        s=size(image)
        xmax=s(1)
        ymax=s(2)

    ; Setup Zoom-In Window
    zoomWinSize = 180
    ;;WINDOW, zoom, TITLE="ZOOM",XSIZE = zoomWinSize, YSIZE = zoomWinSize, RETAIN=0
    ;;WSET,zoom
    ;;;baseZoomlin = WIDGET_BASE (TITLE = 'Zoomed In Star', /ALIGN_CENTER)
    ;;;zoomWin = WIDGET_DRAW (baseZoom, XSIZE = zoomWinSize, YSIZE = zoomWinSize)
    ;;;WIDGET_CONTROL, zoomWin, GET_VALUE=zoom
    WSET,zoom
    ;;;WIDGET_CONTROL, baseZoom, /REALIZE, /UPDATE
    ;;;WIDGET_CONTROL, baseZoom, /REALIZE

;;;    click_retry:
        IF xpos LT 0 then begin
            ; Ask user to click on first star (usually for hole zero.)
            result = DIALOG_MESSAGE("Left mouse click on star for lowest numbered hole.", DIALOG_PARENT=w1, /INFORMATION)
            ;; Tried to use the ZOOM function but its performance is poor: no bytscl so color doesn't match winid_star
            ;; window; it's slow; must click right to kill window then click left button on star.
            ;;;;;ZOOM,/CONTINUOUS,FACT=5,/NEW_WINDOW,XSIZE=zoomWinSize,YSIZE=zoomWinSize
	    WIDGET_CONTROL, baseZoom, SHOW=1, XOFFSET=5, YOFFSET=20
            ;WIDGET_CONTROL, w1, /DRAW_BUTTON_EVENT
	    WIDGET_CONTROL, w1, /DRAW_BUTTON_EVENTS, /DRAW_MOTION_EVENTS
            boxOff = 50
            XboxMin = boxOff
            YboxMin = boxOff
	    ;;;help,image,/structures
            imageSize = size(image)
            XboxMax = imageSize[1] - boxOff - 1
            YboxMax = imageSize[2] - boxOff - 1
      click_retry:
            event1 = WIDGET_EVENT(w1)
            IF (event1.release EQ 1) THEN BEGIN
                    print, "samplefac = ", samplefac
                    xpos = event1.X
                    ypos = event1.Y

                    ; Disable button_event so that it does not interfere with other widgets and clear the events.
		    ;WIDGET_CONTROL, w1, DRAW_BUTTON_EVENTS=0, /CLEAR_EVENTS
                    WIDGET_CONTROL, w1, DRAW_BUTTON_EVENTS=0, DRAW_MOTION_EVENTS=0,/CLEAR_EVENTS
                    ;WSHOW,zoom,/ICONIC
                    ;WDELETE,zoom
                    ;;WIDGET_CONTROL, baseZoom, /DESTROY ;don't do this here -- do it at a higher level.
                    WIDGET_CONTROL, base, /CLEAR_EVENT
             ;ENDIF ELSE goto, click_retry
             ENDIF ELSE IF (event1.type EQ 2) THEN BEGIN
                    xpos = (event1.X) * samplefac + 1
                    ypos = (event1.Y) * samplefac + 1
                    IF (xpos GT XboxMax) THEN BEGIN xpos = XboxMax
                    ENDIF ELSE IF (xpos LT XboxMin) THEN xpos = XboxMin 
                    IF (ypos GT YboxMax) THEN BEGIN ypos = YboxMax
                    ENDIF ELSE IF (ypos LT XboxMin) THEN ypos = YboxMin
		    newimage = image[(xpos - boxOff):(xpos + boxOff),(ypos - boxOff):(ypos + boxOff)]
		    newimage = CONGRID(newimage,zoomWinSize,zoomWinSize) 
		    TV,BYTSCL(newimage,MIN=starbuttom,MAX=startop) ;; better than TVSCL
                    halfZoomWinSize = (zoomWinSize)/2.0
                    plots, [halfZoomWinSize, halfZoomWinSize], [1,zoomWinSize-1], COLOR=255*255*255, LINESTYLE=2, THICK=1,/DEVICE
		    plots, [1, zoomWinSize-1], [halfZoomWinSize,halfZoomWinSize], COLOR=255*255*255, LINESTYLE=2, THICK=1,/DEVICE
		    ;help, event1, /structures
                    goto, click_retry
             ENDIF ELSE goto, click_retry

            ; Original code: disabled since this command should only be used for windows NOT for draw widgets.
            ; Command would work well inside of draw widget but had difficulty detecting mouse click outside
            ; of the draw widget.
            ;;CURSOR,xpos,ypos,/device

            ; Convert the xpos, ypos device coordinates using samplefac instead of CONVERT_COORD (/TO_DATA)
            xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
        ENDIF


        if (xpos-width2 LT 0) or (xpos+width2 GT xmax) or (ypos-width2 LT 0) or (ypos+width2 GT ymax) then begin
                print,'Your Clicked Position was out of range. Set it at (-1,-1).'
                print, "xpos = ", xpos, " ypos = ", ypos
                xpos=-1 & ypos=-1
                GOTO, CLICK_RETRY
        end
        
         
        image3=image[xpos-width2 > width2:xpos+width2 < xmax,ypos-width2 > 0:ypos+width2 < ymax]
        rawimage = image3
        image3 = image3 < top_level > buttom_level
        image4=filter_image(image3,median=5,/all_pixels)
        ;;;sky=median(image4[*,0:3])
        image3=image4;;;-sky
        ;;; print,sky
        ;;; print, "B4 1st gauss2dfit: size(image) = ", size(image)
        ;;; print, "B4 1st gauss2dfit: size(image3) = ", size(image3)

        wset,win3
        imdisp,image3,margin=0

	result=gauss2dfit2(image3,a)
	print, "get_star_pos2: 1st pass gauss2dfit."
	;;; result=mpfit2dpeak(image3,a,/GAUSSIAN)
	;;; print, "get_star_pos2: Using mpfit2dpeak w/GAUSSIAN."
        
        error_string = STRING(i,FORMAT='(I2)') + ':  1st Fit Result Out-of-bound!'

        if a[4] GT 2*width2 or a[4] LT 0 then begin
            print,'get_star_pos2: Wrong Fit'
            ;;; flag=dialog_message('Fit Result Out-of-bound! (X)')
            flag=dialog_message(error_string + '(X)')
    ;        a[4]=width2
            xposout=xpos
            yposout=ypos
            return; of procedure
        END

        if a[5] GT 2*width2 OR a[5] LT 0 then begin
            print,'Wrong Fit'
            ;;; flag=dialog_message('Fit Result Out-of-bound! (Y)')
            flag=dialog_message(error_string + '(Y)')
    ;        a[5]=width2
            xposout=xpos
            yposout=ypos
            return; of procedure
        END

    ;;;;; Determine centroid of the star.
        ;;;wrap_cntrd,image3,a,centX,centY
	;;;wrap_cntrd,rawimage,a,centX,centY                             ; using raw data
        ;;;first_moment_cog, image3, a, centX, centY, /USEMAX, /DEBUG    ; using max.
        ;;;first_moment_cog, rawimage, a, centX, centY, /USEMAX, /DEBUG  ; using raw data & max.
        ;;;xpos2=centX-width2+xpos
        xpos2=a[4]-width2+xpos  ; gauss2dfit results applied
        ;;;ypos2=centY-width2+ypos
        ypos2=a[5]-width2+ypos  ; gauss2dfit results applied

    ;;; Fit 2

;;;     width=width/2
        width2=20; 14=10*sqrt(2)
        image3=image[xpos2-width2:xpos2+width2,ypos2-width2:ypos2+width2]
        image3 = image3 < top_level > buttom_level
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4-median(image4[*,0:3])

        wset,win3
        imdisp,image3,margin=0

        print, "B4 2nd gauss2dfit: size(image) = ", size(image)
        print, "B4 2nd gauss2dfit: size(image3) = ", size(image3)

	result=gauss2dfit(image3,a,/tilt); was gauss2dfit2
	print, "get_star_pos2: Using gauss2dfit w/tilt."
	;;; result=mpfit2dpeak(image3,a,/tilt,/GAUSSIAN)
	;;; print, "get_star_pos2: Using mpfit2dpeak w/GAUSSIAN and w/tilt."

            olda=a
            olda[4]=width2 & olda[5]=width2

        error_string = STRING(i,FORMAT='(I2)') + ':  2nd Fit Result Out-of-bound!'
        if a[4] GT 2*width2 or a[4] LT 0 then begin
            print,'get_star_pos: Wrong Fit'
            ;;; flag=dialog_message('Fit Result Out-of-bound! (X)')
            flag=dialog_message(error_string + '(X)')
            xposout=xpos
            yposout=ypos
            return; of procedure
        END

        if a[5] GT 2*width2 OR a[5] LT 0 then begin
            print,'get_star_pos2: Wrong Fit'
            ;;; flag=dialog_message('Fit Result Out-of-bound! (Y)')
            flag=dialog_message(error_string + '(Y)')
            xposout=xpos
            yposout=ypos
            return; of procedure

        END
    ;;; Determine centroid of the star here and using the array "a" from gauss2dfit
        ;;;wrap_cntrd,image3,a,centX,centY
	;;;wrap_cntrd,rawimage,a,centX,centY                             ; using raw data
        ;;;first_moment_cog, image3, a, centX, centY, /USEMAX, /DEBUG    ; using max.
        ;;;first_moment_cog, rawimage, a, centX, centY, /USEMAX, /DEBUG  ; using raw data & max.

        ;;;xpos2=centX-width2+xpos2
        xpos2=a[4]-width2+xpos2  ; gauss2dfit results applied
        ;;;ypos2=centY-width2+ypos2
        ypos2=a[5]-width2+ypos2  ; gauss2dfit results applied

    ;
    ; Draw
    ;
        image3=image[xpos2-width2:xpos2+width2,ypos2-width2:ypos2+width2]
        rawimage=image3
        image4=filter_image(image3,median=5,/all_pixels)
        image3=image4-median(image4[*,0:3])

        wset,win2
        show3,image3
        wset,win3
        imdisp,image3,margin=0
        draw_ellipse,100,100,10,10,/device,COLOR=255*255*255
        
        wset,win
        draw_ellipse,(xpos2-xoffset)/samplefac,(ypos2-yoffset)/samplefac,100/samplefac/binning[0],100/samplefac/binning[0],/device
        xyouts,(xpos2+10-xoffset)/samplefac,(ypos2+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

    ;    aper,image,a[4]-width2+xpos,a[5]-width2+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux

        xposout=xpos2 & yposout=ypos2

       print,xposout,yposout

    END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO file_read,files,image,PA,binning
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom

    ;    widget_control,hourglass=1
    ;    device,cursor_standard=32513

        image1=MRDFITS(files[0],0,headers1,/silent,/fscale)
        PA=-0.338-float(sxpar(headers1,'INST-PA'))
        binning=sxpar(headers1,'BIN-FCT*')
        suboverscan_hpk,image1,image1_os,1,XBIN=binning[0]
        image1=0
        image2=MRDFITS(files[1],0,headers2,/silent,/fscale)
        suboverscan_hpk,image2,image2_os,2,XBIN=binning[0]
        image2=0
        combine_chip12_hpk,image1_os,image2_os,image,headers1
        image1_os=0 & image2_os=0

    END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO calc_mosshift,star_x,star_y,hole_x,hole_y,starbin,holebin,PA, $
	winres1,winres2,displacement
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom

    mag=0.015/beta
    ;s=size(holeimage)
    ;maxx=s(1) & maxy=s(2)

    nterm=n_elements(star_x)

    x_shift=fltarr(nterm) & yy_shift=fltarr(nterm)
    ang_star=fltarr(nterm) & ang_hole=fltarr(nterm) & difangle=fltarr(nterm)

    ; CCD coord -> Sky coord
    disttransform_inv,star_x*starbin[0],XDistCenter,star_y*starbin[1],YDistCenter,star_x_trans,star_y_trans,mag,maxx*starbin[0],maxy*starbin[1],coef
    disttransform_inv,hole_x*holebin[0],XDistCenter,hole_y*holebin[1],YDistCenter,hole_x_trans,hole_y_trans,mag,maxx*holebin[0],maxy*holebin[1],coef

    x_shift=star_x*starbin[0]-hole_x*holebin[0]
    yy_shift=star_y*starbin[1]-hole_y*holebin[1]

    ;mean_x_shift=mean(x_shift)
    ;mean_y_shift=mean(y_shift)

    ; Shift value (SKY coord)
    x_shift_trans=star_x_trans-hole_x_trans
    y_shift_trans=star_y_trans-hole_y_trans

    hole_x_mean=mean(hole_x_trans)
    hole_y_mean=mean(hole_y_trans)

    ; Mean shift value (SKY coord)
    mean_x_shift_trans=mean(x_shift_trans)
    mean_y_shift_trans=mean(y_shift_trans)

    ; Move star positions to mean hole positions (SKY coord)
    star_x_shift_trans=star_x_trans-mean(x_shift_trans) 
    star_y_shift_trans=star_y_trans-mean(y_shift_trans)

    ; Rotation calc
    ang_star=atan(star_y_shift_trans-YMaskRotCenter,star_x_shift_trans-XMaskRotCenter)
    ang_hole=atan(hole_y_trans      -YMaskRotCenter,hole_x_trans      -XMaskRotCenter)
    difangle=ang_star-ang_hole
    print,"calc_mosshift:difangle = ",difangle
    r_star=sqrt((star_y_shift_trans-YMaskRotCenter)^2+(star_x_shift_trans-XMaskRotCenter)^2)
    mean_difangle=meanw(difangle,r_star)

    ang_star2=atan(star_y_shift_trans-hole_y_mean,star_x_shift_trans-hole_x_mean)
    ang_hole2=atan(hole_y_trans      -hole_y_mean,hole_x_trans      -hole_x_mean)
    difangle2=ang_star2-ang_hole2
    print,"calc_mosshift:difangle2 = ",difangle2
    r_star2=sqrt((star_y_shift_trans-hole_y_mean)^2+(star_x_shift_trans-hole_x_mean)^2)
    mean_difangle2=meanw(difangle2,r_star2)

    ;;;print,'new theta',mean_difangle2*180/3.141592
    print,'calc_mosshift:mean_difangle',string(mean_difangle*180/3.141592)
    print,'calc_mosshift:mean_difangle2',string(mean_difangle2*180/3.141592)

    dif=sqrt(x_shift_trans^2+y_shift_trans^2)

    ;star_x_new=star_x_trans & star_y_new=star_y_trans

    ; Sky coord -> CCD coord
    disttransform,star_x_shift_trans,XDistCenter,star_y_shift_trans,YDistCenter,star_x_shift,star_y_shift,mag,maxx*starbin[0],maxy*starbin[1],0,0,coef_inv

    ; New position after rotation (SKY coord, NEW coord)
    star_x_new_trans= (star_x_shift_trans-XMASKRotCenter)*cos(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*sin(mean_difangle)+XMASKRotCenter
    star_y_new_trans=-(star_x_shift_trans-XMASKRotCenter)*sin(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*cos(mean_difangle)+YMASKRotCenter

    ; Sky coord -> CCD coord (NEW coord)
    disttransform,star_x_new_trans,XDistCenter,star_y_new_trans,YDistCenter,star_x_new,star_y_new,mag,maxx*starbin[0],maxy*starbin[1],0,0,coef_inv

    ; CCD coord -> Sky coord (NEW coord)
    disttransform_inv,star_x_new,XDistCenter,star_y_new,YDistCenter,star_x_new_trans,star_y_new_trans,mag,maxx*starbin[0],maxy*starbin[1], coef
    disttransform_inv,hole_x*holebin[0],XDistCenter,hole_y*holebin[1],YDistCenter,hole_x_new_trans,hole_y_new_trans,mag,maxx*holebin[0],maxy*holebin[1], coef

    ; Mean shift (SKY coord, NEW coord)
    x_shift_new=star_x_new_trans-hole_x_new_trans
    y_shift_new=star_y_new_trans-hole_y_new_trans

    ; Rotation angle (New coord)
    ang_star_new=atan(star_y_new_trans-YMASKRotCenter,star_x_new_trans-XMASKRotCenter)
    difangle_new=ang_star_new-ang_hole
    print,"calc_mosshift:difangle_new = ",difangle_new
    dif_new=sqrt(x_shift_new^2+y_shift_new^2)

    ; Final shift
    true_X_shift=mean_x_shift_trans+mean(x_shift_new)
    true_Y_shift=mean_y_shift_trans+mean(y_shift_new)
    true_difangle=mean_difangle+meanw(difangle_new,r_star)

    ; Residual plot (SKY coord)
    wset,winres1
    ;!P.MULTI=[0,1,2]
    ;!P.MULTI=[0,2,1]
    partvelvec,[x_shift,1],[yy_shift,1],[star_x*starbin[0],500],[star_y*starbin[1],500],[0,4000],[0,4000]
    draw_ellipse,90,427,10,10,/device
    xyouts,80,400,'1pix by 1pix ref. vec.',/device,charsize=1.0
    wset,winres2
    ; Residual plot (SKY coord, NEW coord)
    partvelvec,[x_shift_new,1],[y_shift_new,1],[star_x*starbin[0],500],[star_y*starbin[1],500],[0,4000],[0,4000]
    draw_ellipse,90,77,10,10,/device
    xyouts,80,55,'1pix by 1pix ref. vec.',/device,charsize=1.0
    !P.MULTI=0

    ; Results output
    print,'calc_mosshift: Shift: X=',true_x_shift,' +-',sigma(x_shift_new),' [pix]; Y=',true_y_shift,' +-',sigma(y_shift_new),' [pix]; angle=',true_difangle*180/3.141592,' +-',mean(difangle_new*180/3.141592),' [deg]'
    print,'*** Detail ***'
    print,'calc_mosshift: Each X Shift:'
    print,indgen(n_elements(x_shift_trans)),FIX(x_shift_trans)
    print,'calc_mosshift: Each Y Shift:'
    print,indgen(n_elements(y_shift_trans)),FIX(y_shift_trans)
    print,'calc_mosshift: Each R Shift:'
    print,indgen(n_elements(y_shift_trans)),FIX(sqrt(y_shift_trans^2+x_shift_trans^2))

    print,'calc_mosshift: Residual offset:',mean(dif_new),' +-',sigma(dif_new),' [pix]'

    pix_scale=0.1038
    delta_ra =( (true_y_shift)*cos(pa*3.141592/180)-(true_x_shift)*sin(pa*3.141592/180))*pix_scale
    ;;if delta_ra GT 0.0 then delta_ra1 = delta_ra + 0.005 else delta_ra1 = delta_ra - 0.005
    delta_ra1 = delta_ra
    delta_raStr = strtrim(string(delta_ra1,FORMAT='(F7.3)'),2)
    PRINT, FORMAT='(%"BEFORE:delta_ra =  %10.6f")', delta_ra
    delta_dec=(-(true_y_shift)*sin(pa*3.141592/180)-(true_x_shift)*cos(pa*3.141592/180))*pix_scale
    ;;if delta_dec GT 0.0 then delta_dec1 = delta_dec + 0.0005 else delta_dec1 = delta_dec - 0.0005
    delta_dec1 = delta_dec
    delta_decStr = strtrim(string(delta_dec1,FORMAT='(F7.3)'),2)
    PRINT, FORMAT='(%"BEFORE:delta_dec =  %10.6f")', delta_dec
    true_difangleStr = strtrim(string(-true_difangle*180/3.141592,FORMAT='(F8.4)'),2)
    PRINT, FORMAT='(%"BEFORE:true_difangle =  %10.6f")', -true_difangle*180/3.141592
    ;;result=dialog_text(['delta Alpha=      '+strtrim(string(delta_ra),2)+' arcsec','delta Dec=        '+strtrim(string(delta_dec),2)+' arcsec','delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.',' ','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],title='OFFSET',xsize=38,ysize=7)
    result=dialog_text(['delta Alpha=      '+delta_raStr+' arcsec','delta Dec=        '+delta_decStr+' arcsec','delta MOS angle = '+true_difangleStr+' deg.',' ','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],title='OFFSET',xsize=38,ysize=7)
    displacement=mean(dif)

    END
    ;---



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO mos_pointing_hpk
;
; Hole operation first, then Star operation
;
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,$
    XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,$
    samplefac,xoffset,yoffset,maxx,maxy,w1,base,starbuttom,startop,zoom,baseZoom

    read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

    ;read_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type;,dir=dir
    read_sbr,x1,y1

    x1=x1/0.015*beta;+XDistCenter
    y1=y1/0.015*beta;+YDistCenter

    x1_offset=x1;-XMaskCenter
    ;x2_offset=x2-XMaskCenter
    y1_offset=y1;-YMaskCenter
    ;y2_offset=y2-YMaskCenter


    r1 = sqrt(x1_offset^2+y1_offset^2)
    ;r2 = sqrt(x2_offset^2+y2_offset^2)

    mag=0.015/beta
    ;; No transformation, just scaling
    r1_trans = r1*(coef_inv[0] + coef_inv[1]*(r1*mag) + coef_inv[2]*(r1*mag)^2 + coef_inv[3]*(r1*mag)^3)
    ;r2_trans = r2

    theta1 = atan(y1_offset,x1_offset)
    ;theta2 = atan(y2_offset,x2_offset)

    mos_rot_offset=-mos_rot;-0.7
    ;;; print,"mos_pointing2005: mos_rot_offset: ",mos_rot_offset
    offset=mos_rot_offset*3.141592/180; MOS theta offset in radian
    ;offset=0
    x1_focus=r1_trans*cos(theta1+offset)
    ;x2_focus=r2_trans*cos(theta2+offset)
    y1_focus=r1_trans*sin(theta1+offset)
    ;y2_focus=r2_trans*sin(theta2+offset)

    x1=x1_focus+XMaskCenter; was XMaskCenter
    ;x2=x2_focus+XMaskCenter
    y1=y1_focus+YMaskCenter; was YMaskCenter
    ;y2=y2_focus+YMaskCenter

    ;holeid=where(type EQ 1)
    ;x1=x1[holeid]
    ;x2=x2[holeid]
    ;y1=y1[holeid]
    ;y2=y2[holeid]

    displacement=100.0 ;

    ;window,/free
    device,cursor_standard=32
    ;wdelete,!D.WINDOW


    fitsdir=strarr(4)

    fitsdir[*]=getenv("FOCASRED_FITS_IN")+'/'
    if fitsdir[0] EQ '/' then fitsdir[*]=getenv('PWD')
    fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
    if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')

    nterm=n_elements(x1)


    hole_x=fltarr(nterm) & hole_y=fltarr(nterm) & star_x=fltarr(nterm) & star_y=fltarr(nterm)

    ;set_intensity_level,holebuttom,holetop,starbuttom,startop
    holebuttom=10
    holetop=800
    starbuttom=900
    startop=1500

    filenameinitial=['00000','00000','00000','00000']
    fldprompt=["Mask 1 (last 6 digits from FCSA000#####)", "Mask 2 (last 6 digits from FCSA000#####)", $
               "Star 1 (last 6 digits from FCSA000#####)", "Star 2 (last 6 digits from FCSA000#####)"]
    comment="Hit <Return> in text field to fill seq."

    retry:
    ;files=dialog_input(prompt=["Mask 1","Mask 2","Star 1", "Star 2"],nfield=4,title='FCSA000XXXXX (last five number)',initial=filenameinitial)
    files=alan_input_dialog(prompt=fldprompt,nfields=4,title='Enter Files Numbers',trailer=comment)

    for i=1,3 do begin
    if(files[i] EQ '') then begin
        ;; files[i]=string(long(files[0])+i,FORMAT='(I5)')
        files[i] = STRTRIM(STRING(long(files[0]) + i),1)
    endif
    endfor

    ;;  filesexp=fitsdir+'FCSA000'+files+'.fits'
    ;;  print,"mos_pointing2005: Formatted files - ",files
    filesexp = fitsdir+'FCSA'+ STRING(files, FORMAT = '(I08)') + '.fits'
    ;; print,"******* mos_pointing2005 filesexp: ",filesexp


    d = FINDFILE (filesexp[0], COUNT = fileExists)
    IF (fileExists EQ 0) THEN begin
        print,'mos_pointing2005: File error'

        flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
        CASE flag OF
            'Retry': begin
                filenameinitial=files
                goto,retry
                end
            'Quit': return;
        ENDCASE
    ENDIF

    d = FINDFILE (filesexp[1], COUNT = fileExists)
    IF (fileExists EQ 0) THEN begin
        print,'mos_pointing2005: File error'
        flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
        CASE flag OF
            'Retry': begin
                goto,retry
                end
            'Quit': return;
        ENDCASE
    ENDIF

    ;widget_control,hourglass=1
    device,cursor_standard=68
    ;wdelete,!D.WINDOW
    file_read,filesexp[0:1],holeimage,pa,holebin
    ;widget_control,hourglass=0
    device,cursor_standard=32
    ;wdelete,!D.WINDOW


    s=size(holeimage) & maxx=s(1) & maxy=s(2)
    xoffset=0 & xend=maxx-1 & yoffset=0 & yend=maxy-1 & samplefac=get_samplefac_x(maxx)*2.0; was 50, 2.5
    IF (samplefac < 3) THEN samplefac=3;

    ;xoffset=0 & xend=maxx-1 & yoffset=0 & yend=maxy-1 & samplefac=3; was 50, 2.5

    width=50

    base = WIDGET_BASE (mbar=bar,TITLE = 'MOS Pointing', /row, MAP = 0)
    menu1=widget_button(bar, value='Quit',/menu)
    button1=widget_button(menu1,value='Quit')

    base0 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
    base1 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
    base2 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
    ;base3 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)

    label_alignmentstars=widget_label(base0,value='     Alignment Stars     ',/DYNAMIC_RESIZE)
    ;w1 = WIDGET_DRAW (base0, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME)
    w1 = WIDGET_DRAW (base0, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME,/MOTION_EVENTS)
    label_alignmentholes=widget_label(base1,value='     Alignment Holes     ',/DYNAMIC_RESIZE)
    w2 = WIDGET_DRAW (base1, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME,/EXPOSE_EVENTS)
    label=widget_label(base2,value='2D')
    w3 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
    label=widget_label(base2,value='3D')
    w4 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
    label=widget_label(base2,value='Before')
    w6 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
    label=widget_label(base2,value='After')
    w7 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)

    button1 = widget_button(base0, VALUE = 'Redraw Star',/frame)
    button1 = widget_button(base1, VALUE = 'Redraw Hole',/frame)

    button1 = widget_button(base0, VALUE = 'Mark Star',/frame)
    button1 = widget_button(base1, VALUE = 'Mark Hole',/frame)

    button1 = widget_button(base0, VALUE = 'Set Star Position',/frame)
    button1 = widget_button(base1, VALUE = 'Set Hole Position',/frame)
    button1 = widget_button(base1, VALUE = 'Set Hole Pos (manual)',/frame)


    ;button1 = widget_button(base0, VALUE = 'File Read',/frame)
    ;button1 = widget_button(base1, VALUE = 'File Read',/frame)

    button1 = widget_button(base0, VALUE = 'Refit Stars',/frame)
    button1 = widget_button(base0, VALUE = 'Refit Stars Semiauto',/frame)
    button1 = widget_button(base1, VALUE = 'Refit Holes',/frame)

    label=widget_label(base0,value='')
    button1 = widget_button(base0, VALUE = 'Change Intensity',/frame)
    button1 = widget_button(base0, VALUE = 'Change Fit Reg. Size',/frame)
    button1 = widget_button(base0, VALUE = 'Copy Hole Pos.',/frame)
    button1 = widget_button(base0, VALUE = 'Refit All',/frame)
    ;;;
    button1 = widget_button(base0, VALUE = 'Change Color Table',/frame)
    message=widget_label(base0,value='----- Message Window -----')

    label=widget_label(base1,value='')
    button1 = widget_button(base1, VALUE = 'CALC',/frame)
    button1 = widget_button(base1, VALUE = 'Show Fit Images',/frame)
    label=widget_label(base1,value='')
    button1 = widget_button(base1, VALUE = 'Delete/ReUse Hole',/frame)
    ;button1 = widget_button(base1, VALUE = 'Reuse Hole',/frame)
    label=widget_label(base1,value='')
    button1 = widget_button(base1, VALUE = 'File Read',/frame)

    WIDGET_CONTROL, base, /REALIZE,/UPDATE
    WIDGET_CONTROL, w1, GET_VALUE = winid_star
    WIDGET_CONTROL, w2, GET_VALUE = winid_hole
    WIDGET_CONTROL, w3, GET_VALUE = winobs
    WIDGET_CONTROL, w4, GET_VALUE = winfit
    ;WIDGET_CONTROL, w5, GET_VALUE = winres
    WIDGET_CONTROL, w6, GET_VALUE = winres1
    WIDGET_CONTROL, w7, GET_VALUE = winres2

    WIDGET_CONTROL, base, MAP = 1
    WIDGET_CONTROL, base0, MAP = 1
    WIDGET_CONTROL, base1, MAP = 1
    WIDGET_CONTROL, base2, MAP = 1
    ;WIDGET_CONTROL, base3, MAP = 1

    zoomWinSize = 180
    baseZoom = WIDGET_BASE (TITLE = 'Zoomed In Star', /ALIGN_CENTER)
    zoomWin = WIDGET_DRAW (baseZoom, XSIZE = zoomWinSize, YSIZE = zoomWinSize)
    WIDGET_CONTROL, zoomWin, GET_VALUE=zoom

    ;
    ; Mask Operation
   
    expand,holeimage,FIX(maxx/samplefac),FIX(maxy/samplefac),holeimage2
    print,"mos_pointing2005:first samplefac, maxx, maxy",samplefac,maxx,maxy
    wset,winid_hole
    TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
    ;;  widget_control,label_alignmentholes,set_value='Holes: FCSA000'+files[0]+'+'+files[1]
    widget_control,label_alignmentholes,set_value='Holes: FCSA'+STRING(files[0], FORMAT='(I08)')+'+'+files[1]

    ;for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i]+x2[i])/2-xoffset)/samplefac,((y1[i]+y2[i])/2-yoffset)/samplefac,100/samplefac,100/samplefac,/device
    sqoffset = 100
    plots, [(x1[0]-sqoffset)/samplefac/holebin[0],(x1[0]-sqoffset)/samplefac/holebin[0]], [(y1[0]-sqoffset)/samplefac/holebin[1],(y1[0]+sqoffset)/samplefac/holebin[1]],/DEVICE
    plots, (x1[0]+sqoffset)/samplefac/holebin[0], (y1[0]+sqoffset)/samplefac/holebin[1],/DEVICE,/CONTINUE
    plots, (x1[0]+sqoffset)/samplefac/holebin[0], (y1[0]-sqoffset)/samplefac/holebin[1],/DEVICE,/CONTINUE
    plots, (x1[0]-sqoffset)/samplefac/holebin[0], (y1[0]-sqoffset)/samplefac/holebin[1],/DEVICE,/CONTINUE
    for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i])-xoffset)/samplefac/holebin[0],((y1[i])-yoffset)/samplefac/holebin[1],100/samplefac/holebin[0],100/samplefac/holebin[0],/device

    widget_control,message,set_value='Click Image for Holes.'

    ;
    ; Automatic Clicks (guess from SDR file)
    ;
    for i=0,nterm-1 do begin
    ;;;;
        get_pos,holeimage,x1[i]/holebin[0],y1[i]/holebin[1],X,Y,holebin,holebuttom*holebin[0]*holebin[1],holetop*holebin[0]*holebin[1],i,winid_hole,winfit,winobs,width,mode="HOLE"
        hole_x[i]=X & hole_y[i]=Y
    ENDFOR

    ;;;;;;;;;;;;;;;;;;
    ; Star operation ;
    ;;;;;;;;;;;;;;;;;;

    width=30; for single fit, was 50 for re-fit
    IF filesexp[0] NE filesexp[2] then begin
    nofile:
        flag = DIALOG_MENU (["Let's go to object image NOW"], TITLE = 'Click here when object image is ready.')

        WIDGET_CONTROL, baseZoom, /REALIZE

        d = FINDFILE (filesexp[3], COUNT = fileExists)
        IF (fileExists EQ 0) THEN BEGIN
            print,"mos_pointing2005: The Files are not ready."
            goto,nofile
        END

    ;    widget_control,hourglass=1
        device,cursor_standard=66
    ;    wdelete,!D.WINDOW

        file_read,filesexp[2:3],starimage,pa,starbin
    ;    widget_control,hourglass=0
        device,cursor_standard=32
    ;    wdelete,!D.WINDOW


        expand,starimage,FIX(maxx/samplefac),FIX(maxy/samplefac),starimage2
    ENDIF ELSE BEGIN
        starimage=holeimage
        starimage2=holeimage2
        starbin=holebin
    ;    star_x=hole_x & star_y=hole_y; copy hole position
        star_x=x1 & star_y=y1; use default pos from SBR.

    ENDELSE

    ;
    ; Countlevel tuning
    ;
    resistant_mean,starimage2,2.5,starbuttom
    starbuttom=starbuttom*0.8
    startop=2*starbuttom
    holetop=starbuttom/0.8*0.6

    wset,winid_star
    TV,BYTSCL(starimage2,min=starbuttom,max=startop)
    ;;  widget_control,label_alignmentstars,set_value='Stars: FCSA000'+files[2]+'+'+files[3]
    widget_control,label_alignmentstars,set_value='Stars: FCSA'+STRING(files[2], FORMAT='(I08)')+'+'+files[3]

    ;for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i]+x2[i])/2-xoffset)/samplefac,((y1[i]+y2[i])/2-yoffset)/samplefac,100/samplefac,100/samplefac,/device
    sqoffset = 100
    plots, [(x1[0]-sqoffset)/samplefac/starbin[0],(x1[0]-sqoffset)/samplefac/starbin[0]], [(y1[0]-sqoffset)/samplefac/starbin[1],(y1[0]+sqoffset)/samplefac/starbin[1]],/DEVICE
    plots, (x1[0]+sqoffset)/samplefac/starbin[0], (y1[0]+sqoffset)/samplefac/starbin[1],/DEVICE,/CONTINUE
    plots, (x1[0]+sqoffset)/samplefac/starbin[0], (y1[0]-sqoffset)/samplefac/starbin[1],/DEVICE,/CONTINUE
    plots, (x1[0]-sqoffset)/samplefac/starbin[0], (y1[0]-sqoffset)/samplefac/starbin[1],/DEVICE,/CONTINUE
    for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i])-xoffset)/samplefac/starbin[0],((y1[i])-yoffset)/samplefac/starbin[1],100/samplefac/starbin[0],100/samplefac/starbin[1],/device

    star_x=hole_x & star_y=hole_y
    ;get_pos,starimage,-1,-1,X,Y,starbin,starbuttom,50000,0,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
    get_pos,starimage,-1,-1,X,Y,starbin,starbuttom,100000,0,winid_star,winfit,winobs,width,mode="STAR";
    star_x=star_x-(star_x[0]-X)
    star_y=star_y-(star_y[0]-Y)

    for i=1,nterm-1 do begin
        ;get_pos,starimage,star_x[i],star_y[i],X,Y,starbin,starbuttom,50000,i,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
        get_pos,starimage,star_x[i],star_y[i],X,Y,starbin,starbuttom,100000,i,winid_star,winfit,winobs,width,mode="STAR";
        star_x[i]=X & star_y[i]=Y
    ENDFOR

    calc_mosshift,star_x,star_y,hole_x,hole_y,starbin,holebin,PA,winres1,winres2,displacement

    use=intarr(nterm)
    use[*]=1

    ;;;WIDGET_CONTROL, baseZoom, /DESTROY

    NEXT:

    usearr=0
    for j=1,nterm-1 do if use[j] EQ 1 then usearr=[usearr,j]

    if use[0] EQ 0 then Usearr=usearr[1:*]

    event = WIDGET_EVENT (base)
    ;help, event, /struct2
    WIDGET_CONTROL, event.id, GET_VALUE = value;

    ; Event Loop

    IF (value EQ 'Redraw Star') THEN begin
        wset,winid_star
        TV,BYTSCL(starimage2,min=starbuttom,max=startop)
        GOTO,NEXT
    END

    IF (value EQ 'Redraw Hole') THEN begin
        wset,winid_hole
        TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
        GOTO,NEXT
    END

    IF (value EQ 'Delete/ReUse Hole') THEN begin
        use = dialog_menu_alan(string(indgen(nterm)),use,title='Holes Being Used')
        print, "mos_pointing2005: Delete Hole: use = ", use
        GOTO,NEXT
    ENDIF

    ;IF (value EQ 'Reuse Hole') THEN begin
    ;;    i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
    ;;    i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
    ;;    use[i]=1
    ;;;   use = dialog_menu_alan(string(indgen(nterm)),use,title='Holes Being Used')
    ;;;   print, "mos_pointing2005: Delete Hole: use = ", use
    ;    GOTO,NEXT
    ;ENDIF

    IF (value EQ 'Set Star Position') THEN begin
        wset,winid_star
    ;    i=dialog_input(prompt=["Star ID"],title="",nfield=1)
        i=fix(dialog_menu(string(indgen(nterm)),title='Star ID'))
        ;get_pos,starimage,-1,-1,X,Y,starbin,starbuttom,50000,i,winid_star,winfit,winobs,width,mode="STAR2"; 50000 was startop
        get_pos,starimage,-1,-1,X,Y,starbin,starbuttom,100000,i,winid_star,winfit,winobs,width,mode="STAR2";
        star_x[i]=X & star_y[i]=Y
        GOTO,NEXT
    END

    IF (value EQ 'Set Hole Position') THEN begin
        wset,winid_hole
    ;    i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
        i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
        get_pos,holeimage,-1,-1,X,Y,holebin,holebuttom,holetop,i,winid_hole,winfit,winobs,width,mode="HOLE"
        hole_x[i]=X & hole_y[i]=Y
        GOTO,NEXT
    END

    IF (value EQ 'Set Hole Pos (manual)') THEN begin
        wset,winid_hole
    ;    i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
        i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
        get_pos,holeimage,-1,-1,X,Y,holebin,holebuttom,holetop,i,winid_hole,winfit,winobs,width,mode="MANUAL"
        hole_x[i]=X & hole_y[i]=Y
        GOTO,NEXT
    END

    IF (value EQ 'Change Intensity') THEN begin
        set_intensity_level,holebuttom,holetop,starbuttom,startop        
        wset,winid_star
        TV,BYTSCL(starimage2,min=starbuttom,max=startop)
        wset,winid_hole
        TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
        GOTO,NEXT
    END

    IF (value EQ 'CALC') THEN begin
        calc_mosshift,star_x[usearr],star_y[usearr],hole_x[usearr],hole_y[usearr],starbin,holebin,PA,winres1,winres2,displacement
        GOTO,NEXT
    END

    IF (value EQ 'Mark Star') THEN begin
        mark_position,star_x,star_y,use,starbin,winid_star, usearr
        GOTO,NEXT
    END

    IF (value EQ 'Mark Hole') THEN begin
        mark_position,hole_x,hole_y,use,holebin,winid_hole, usearr
        GOTO,NEXT
    END

    IF (value EQ 'Change Fit Reg. Size') THEN begin
        result=dialog_input(prompt="Width (pixel)",title=" ",initial=width)
        width=FIX(result)
        GOTO,NEXT
    END

    IF (value EQ 'Quit') THEN begin
        result=dialog_message('Do you really want to quit?',/question)
        if result EQ 'Yes' then begin
    ;        message,'Finish'    
            WIDGET_CONTROL, baseZoom, /DESTROY
            WIDGET_CONTROL, base, /DESTROY
            goto,ending
        ENDIF

        GOTO,NEXT
    END

    IF (value EQ 'Refit All') THEN begin
        refit_holes,holeimage,hole_x,hole_y,holebin,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode='HOLE'
        ;refit_stars,starimage,star_x,star_y,starbin,starbuttom,50000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
        refit_stars,starimage,star_x,star_y,starbin,starbuttom,100000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
        calc_mosshift,star_x[usearr],star_y[usearr],hole_x[usearr],hole_y[usearr],starbin,holebin,PA,winres1,winres2,displacement

        ;dispsize=round(25/starbin[0]); was 100
	dispsize=round(25/starbin[0]); was 100
        
	sortx_star_x = sort(star_x)
        text_sortx_star_x = string(sortx_star_x)

        multistarimage=fltarr((dispsize*2+1)*n_elements(star_x),(dispsize*2+1))
        for i=0,n_elements(star_x)-1 do begin
	    j = sortx_star_x[i]
            ;multistarimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(starimage[star_x[i]-dispsize:star_x[i]+dispsize,star_y[i]-dispsize:star_y[i]+dispsize])
	    multistarimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(starimage[star_x[j]-dispsize:star_x[j]+dispsize,star_y[j]-dispsize:star_y[j]+dispsize])
        endfor

        multiholeimage=fltarr((dispsize*2+1)*n_elements(star_x),(dispsize*2+1))
        for i=0,n_elements(star_x)-1 do begin
	    j = sortx_star_x[i]
            ;multiholeimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(holeimage[hole_x[i]-dispsize:hole_x[i]+dispsize,hole_y[i]-dispsize:hole_y[i]+dispsize],min=holebuttom,max=holetop)
	    multiholeimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(holeimage[hole_x[j]-dispsize:hole_x[j]+dispsize,hole_y[j]-dispsize:hole_y[j]+dispsize],min=holebuttom,max=holetop)
        endfor

        multiimage=[[multiholeimage],[multistarimage]]

        s=size(multiimage)
        magdispfac=2*starbin[0]
        multiimage=rebin(multiimage,s[1]*magdispfac,s[2]*magdispfac)
        for i=1,n_elements(star_x)-1 do begin
            multiimage[((dispsize*2+1)*i+0.5)*magdispfac:((dispsize*2+1)*i+0.5)*magdispfac,*]=255
        endfor
        multiimage[*,(dispsize*2+0.5)*magdispfac]=255
        xline=fltarr(n_elements(star_x))
        for i=0,n_elements(star_x)-1 do xline[i]=((dispsize*2+1)*i+dispsize+0.5)*magdispfac
        yline=[(dispsize+0.5)*magdispfac,(dispsize*3+1.5)*magdispfac]
        Wtitle = 'Upper: Stars, Lower: Holes, Sorted by X-value from least to highest '
        ;result=dialog_draw2(multiimage,xsize=s[1]*magdispfac,ysize=s[2]*magdispfac,wintitle='Upper: Stars; Lower: Holes', XLINE=xline, yline=yline)
        result=dialog_draw_slider(multiimage,xsize=s[1]*magdispfac,ysize=s[2]*magdispfac,wintitle=Wtitle, XLINE=xline, yline=yline,STARNUM=text_sortx_star_x,/SLIDER_OPTION)

        GOTO,NEXT
    END

    IF (value EQ 'Refit Holes') THEN begin
        refit_holes,holeimage,hole_x,hole_y,holebin,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode='HOLE'
        GOTO,NEXT
    END


    IF (value EQ 'Refit Stars') THEN begin
        ;refit_stars,starimage,star_x,star_y,starbin,starbuttom,50000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
        refit_stars,starimage,star_x,star_y,starbin,starbuttom,100000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
        GOTO,NEXT
    END


    IF (value EQ 'Refit Stars Semiauto') THEN begin
        star_x=hole_x & star_y=hole_y
        ;get_pos,starimage,-1,-1,X,Y,starbin,starbuttom,50000,0,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
        get_pos,starimage,-1,-1,X,Y,starbin,starbuttom,100000,0,winid_star,winfit,winobs,width,mode="STAR";
        star_x=star_x-(star_x[0]-X)
        star_y=star_y-(star_y[0]-Y)

        for i=1,nterm-1 do begin
            ;get_pos,starimage,star_x[i],star_y[i],X,Y,starbin,starbuttom,50000,i,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
            get_pos,starimage,star_x[i],star_y[i],X,Y,starbin,starbuttom,100000,i,winid_star,winfit,winobs,width,mode="STAR";
            star_x[i]=X & star_y[i]=Y
        ENDFOR

        GOTO,NEXT
    END


    IF (value EQ 'Copy Hole Pos.') THEN begin
        star_x=hole_x & star_y=hole_y
        GOTO,NEXT
    END

    IF (value EQ 'Show Fit Images') THEN begin
        ;dispsize=25/starbin[0]; was 100
	dispsize=40/starbin[0]; was 100

	sortx_star_x = sort(star_x)
        text_sortx_star_x = string(sortx_star_x)

        multistarimage=fltarr((dispsize*2+1)*n_elements(star_x),(dispsize*2+1))
        for i=0,n_elements(star_x)-1 do begin
	    j = sortx_star_x[i]
            ;multistarimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(starimage[star_x[i]-dispsize:star_x[i]+dispsize,star_y[i]-dispsize:star_y[i]+dispsize],min=starbuttom)
	    multistarimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(starimage[star_x[j]-dispsize:star_x[j]+dispsize,star_y[j]-dispsize:star_y[j]+dispsize],min=starbuttom)
        endfor

        multiholeimage=fltarr((dispsize*2+1)*n_elements(star_x),(dispsize*2+1))

        for i=0,n_elements(star_x)-1 do begin
            j=sortx_star_x[i]
            ;multiholeimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(holeimage[hole_x[i]-dispsize:hole_x[i]+dispsize,hole_y[i]-dispsize:hole_y[i]+dispsize],min=holebuttom,max=holetop)
            multiholeimage[(dispsize*2+1)*i:(dispsize*2+1)*(i+1)-1,0:dispsize*2]=bytscl(holeimage[hole_x[j]-dispsize:hole_x[j]+dispsize,hole_y[j]-dispsize:hole_y[j]+dispsize],min=holebuttom,max=holetop)
	endfor

        multiimage=[[multiholeimage],[multistarimage]]

        s=size(multiimage)
        magdispfac=2*starbin[0]
        multiimage=rebin(multiimage,s[1]*magdispfac,s[2]*magdispfac)
        for i=1,n_elements(star_x)-1 do begin
            multiimage[((dispsize*2+1)*i+0.5)*magdispfac:((dispsize*2+1)*i+0.5)*magdispfac,*]=255
        endfor
        multiimage[*,(dispsize*2+0.5)*magdispfac]=255
        xline=fltarr(n_elements(star_x))
        for i=0,n_elements(star_x)-1 do xline[i]=((dispsize*2+1)*i+dispsize+0.5)*magdispfac
        yline=[(dispsize+0.5)*magdispfac,(dispsize*3+1.5)*magdispfac]
        ;result=dialog_draw2(multiimage,xsize=s[1]*magdispfac,ysize=s[2]*magdispfac,wintitle='Upper: Stars; Lower: Holes', XLINE=xline, yline=yline)
        Wtitle = 'Upper: Stars, Lower: Holes, Sorted by X-value from least to highest  '
        ;result=dialog_draw_slider(multiimage,xsize=s[1]*magdispfac,ysize=s[2]*magdispfac,wintitle=Wtitle, XLINE=xline, YLINE=yline,/SLIDER_OPTION)
	result=dialog_draw_slider(multiimage,xsize=s[1]*magdispfac,ysize=s[2]*magdispfac,WINTITLE=Wtitle, XLINE=xline, YLINE=yline,STARNUM=text_sortx_star_x,/SLIDER_OPTION)

        GOTO,NEXT
    END

    IF (value EQ 'Change Color Table') THEN begin
        XLOADCT, /BLOCK
        wshow,winid_star
        ;TV,BYTSCL(starimage2,min=starbuttom,max=startop)
        wshow,winid_hole
        ;TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
        GOTO,NEXT
    END


    IF (value EQ 'File Read') THEN begin
        oldstarbin=starbin
        oldholebin=holebin

    retry_in_fileread:

        fldprompt=["Mask 1 (last 6 digits from FCSA00######)", "Mask 2 (last 6 digits from FCSA00######)", $
                   "Star 1 (last 6 digits from FCSA00######)", "Star 2 (last 6 digits from FCSA00######)"]

	;; Added code here to check that files has not been changed by earlier call to "Read Files" to ''
        if (N_ELEMENTS(files) GT 1) then  oldFiles = files $
	else files = oldfiles
	
print, "mos_pointing2005: displacement=",displacement
        ;;IF (displacement GT 40.0) THEN begin
        ;;    initFiles = [long(files[0]), long(files[1]), long(files[3])+1, long(files[3])+2]
        ;;ENDIF ELSE begin
        ;;    initFiles = [long(files[0])+10, long(files[1])+10, long(files[0])+10, long(files[1])+10]
        ;;ENDELSE

        bigDispFiles = [long(files[0]), long(files[1]), long(files[3])+1, long(files[3])+2]
        initFiles = bigDispFiles
        print, "mos_pointing2005: ",initFiles
      
        files=alan_input_dialog(prompt=fldprompt,nfield=4,title='Enter Files Numbers', initial=initFiles)

	;; Check that files array is has more than one element, i.e. user did not cancel.
	if (N_ELEMENTS(files) EQ 1) THEN GOTO, NEXT
	print,"mos_pointing2005: N_ELEMENTS(files) = ",N_ELEMENTS(files)


        for i=1,3 do begin
        if(files[i] EQ '') then begin
            ;; files[i]=string(long(files[0])+i,FORMAT='(I5)')
            files[i] = STRTRIM(STRING(long(files[0]) + i),1)
        endif
        endfor

        ;; filesexp=fitsdir+'FCSA000'+files+'.fits'
        filesexp = fitsdir + 'FCSA' + STRING(files, FORMAT = '(I08)') + '.fits'
        ;; print,"******* mos_pointing2005: filesexp - ", filesexp

        d = FINDFILE (filesexp[0], COUNT = fileExists)
        IF (fileExists EQ 0) THEN begin
            flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Do you want to cancel File Read?')
            CASE flag OF
                    'Retry': begin
                            goto,retry_in_fileread
                            end
                    'Quit':  begin
                            ; restore oldFiles to files since files is now empty
                            files = oldFiles
                            goto,NEXT ;message,'Finish!'
                            end
            ENDCASE

        ENDIF

        d = FINDFILE (filesexp[1], COUNT = fileExists)
        IF (fileExists EQ 0) THEN begin
            print,'mos_pointing2005: File error'
            flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
            CASE flag OF
                'Retry': begin
                    goto,retry_in_fileread
                    end
                'Quit': begin
                        ; restore oldFiles to files since files is now empty
                        files = oldFiles
                        goto,NEXT; message,'Finish!'
                        end
            ENDCASE
        ENDIF

        widget_control,hourglass=1
        device,cursor_standard=66
    ;    wdelete,!D.WINDOW

        file_read,filesexp[0:1],holeimage,pa,holebin
        widget_control,hourglass=0
        device,cursor_standard=32
    ;    wdelete,!D.WINDOW

        s=size(holeimage) & maxx=s(1) & maxy=s(2)
        xend=maxx-1 & yend=maxy-1
        samplefac=samplefac*oldholebin[0]/holebin[0]
        expand,holeimage,FIX(maxx/samplefac),FIX(maxy/samplefac),holeimage2
print,"mos_pointing2005: second samplefac,maxx,maxy ",samplefac,maxx,maxy
        hole_x=hole_x*oldholebin[0]/holebin[0]
        hole_y=hole_y*oldholebin[1]/holebin[1]
        holetop=holetop*holebin[0]*holebin[1]/oldholebin[0]/oldholebin[1]
        holebuttom=holebuttom*holebin[0]*holebin[1]/oldholebin[0]/oldholebin[1]

        if filesexp[0] EQ filesexp[2] then begin
            starimage=holeimage
            starimage2=holeimage2
            star_x=hole_x & star_y=hole_y; copy hole position
            starbin=holebin
            startop=startop*starbin[0]*starbin[1]/oldstarbin[0]/oldstarbin[1]
            starbuttom=starbuttom*starbin[0]*starbin[1]/oldstarbin[0]/oldstarbin[1]
        endif else begin
    ;        widget_control,hourglass=1
            device,cursor_standard=66
    ;        wdelete,!D.WINDOW
            file_read,filesexp[2:3],starimage,pa,starbin
    ;        widget_control,hourglass=0
            device,cursor_standard=32
    ;        wdelete,!D.WINDOW


            expand,starimage,FIX(maxx/samplefac),FIX(maxy/samplefac),starimage2
;            star_x=star_x*oldstarbin[0]/starbin[0]
;            star_y=star_y*oldstarbin[1]/starbin[1]
            star_x=hole_x & star_y=hole_y; copy hole position
            startop=startop*starbin[0]*starbin[1]/oldstarbin[0]/oldstarbin[1]
            starbuttom=starbuttom*starbin[0]*starbin[1]/oldstarbin[0]/oldstarbin[1]
        endelse

        wset,winid_star
        ;TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
        TV,BYTSCL(starimage2,min=starbuttom,max=startop)
        ;;  widget_control,label_alignmentstars,set_value='Stars: FCSA000'+files[2]+'+'+files[3]
        widget_control,label_alignmentstars,set_value='Stars: FCSA'+STRING(files[2],FORMAT='(I08)')+'+'+files[3]
        wset,winid_hole
        ;TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
        TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
        ;;  widget_control,label_alignmentholes,set_value='Holes: FCSA000'+files[0]+'+'+files[1]
        widget_control,label_alignmentholes,set_value='Holes: FCSA'+STRING(files[0], FORMAT='(I08)')+'+'+files[1]

        mark_position,star_x,star_y,use,starbin,winid_star,usearr
        mark_position,hole_x,hole_y,use,holebin,winid_hole,usearr
;        mark_position,star_x,star_y,use,starbin,winid_star
;        mark_position,hole_x,hole_y,use,holebin,winid_hole

        refit_holes,holeimage,hole_x,hole_y,holebin,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode='HOLE'
        ;refit_stars,starimage,star_x,star_y,starbin,starbuttom,  50000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
        refit_stars,starimage,star_x,star_y,starbin,starbuttom,  100000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'

        calc_mosshift,star_x[usearr],star_y[usearr],hole_x[usearr],hole_y[usearr],starbin,holebin,PA,winres1,winres2,displacement

        GOTO,NEXT
    ENDIF ELSE BEGIN
	print, "mos_pointing2005: value = ", value
	help, value
    	GOTO,NEXT
    ENDELSE

    ;message,'Finish'












    ;
    ;
    ;
    ; Residual plots
    ;

    window
    r_hole=sqrt((hole_y-YMASKRotCenter)^2+(hole_x-XMASKRotCenter)^2)
    plot,r_star,(r_hole-r_star)/r_star*100,xrange=[0,2000]

    ;
    ; Rotation angle
    ;
    plot,star_y,x_shift_new,psym=2
    result=poly_fit(star_y,x_shift_new,1)
    print,"mos_pointing2005: -result[1]*180/3.141592 = ",-result[1]*180/3.141592

    plot,star_x,y_shift_new,psym=2
    result=poly_fit(star_x_shift,y_shift_new,1)
    print, "mos_pointing2005: -result[1]*180/3.141592 = ",result[1]*180/3.141592

    ;
    ; Distortion (radial) error
    ;
    plot,r_star,(r_star-r_hole)/r_hole*100,psym=1,yrange=[-1,1]
    plot,star_x,(r_star-r_hole),psym=1,yrange=[-10,10]
    plot,r_star,r_star/r_hole,psym=1,yrange=[0.98,1.02]
    plot,r_star,dif_new,psym=2
    ;
    ; Chip 1, 2 gap offset error
    ;
    plot,star_x_shift,x_shift_new,psym=2
    ;
    ; Chip 1, 2 Y offset
    ;
    plot,star_x_shift,y_shift_new,psym=2
    ;
    ; Rot center error
    ;
    plot,ang_star*180/3.14,difangle_new*180/3.14,psym=2

    print,"mos_pointing2005:",sqrt((x_shift_new-mean(x_shift_new))^2+(y_shift_new-mean(y_shift_new))^2)

;    message,'FINISH'


    ;
    ; write shift and rot star image
    ;
    shiftstarimage=shift(starimage_med,-true_x_shift,-true_y_shift)
    shiftrotstarimage=rot(shiftstarimage,true_difangle*180/3.141592,1,XMaskRotCenter,YMaskRotCenter,/pivot,/interp)
    ;write_fits,shiftrotstarimage,header
    write_fits,shiftrotstarimage-holeimage_med ,header
    ;
    ;  Write rotated hole image
    ;
    rotholeimage=rot(holeimage,true_difangle*180/3.141592,1,XMASKRotCenter,YMASKRotCenter,/pivot,/interp)
    write_fits,rotholeimage ,header,dir=fitsoutdir

    ENDING:

    END ;
